// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/code_emitter.h,v 1.2 2001/08/13 09:54:55 xhshi Exp $
//


#ifndef _CODE_EMITTER_H_
#define _CODE_EMITTER_H_

class Arg_Operand;     // forward declaration
class O3_Data_Emitter; // forward declaration

class X86_Opnd_Pool {
public:
    X86_Opnd_Pool(M_Opnd *m, M_Base_Opnd *mb, M_Index_Opnd *mi) 
        : frame(NULL), m_opnd(m), m_base(mb), m_indx(mi) {
        r_opnd[eax_reg] = &eax_opnd;
        r_opnd[ecx_reg] = &ecx_opnd;
        r_opnd[edx_reg] = &edx_opnd;
        r_opnd[ebx_reg] = &ebx_opnd;
        r_opnd[esp_reg] = &esp_opnd;
        r_opnd[ebp_reg] = &ebp_opnd;
        r_opnd[esi_reg] = &esi_opnd;
        r_opnd[edi_reg] = &edi_opnd;
    }
    RM_Opnd *get_rm_opnd(Operand *opnd);
    R_Opnd  *get_r_opnd(Operand *opnd);
    M_Opnd  *get_m_opnd(Operand *opnd);
    M_Opnd  *get_m_opnd_lea(Operand *src1, Operand *src2, bool negate_src2);

    Frame        *frame;
private:
    R_Opnd       *r_opnd[n_reg];
    M_Opnd       *m_opnd;
    M_Base_Opnd  *m_base;
    M_Index_Opnd *m_indx;
};

//
// generic patch used to patch branch and call displacements after
// code has been copied into the code space.
//
class Patch {
protected:
	Patch *const _next;		// next patch in list
	Patch(Patch *n) : _next(n) {}
public:
    virtual void apply(char *code_buffer) = 0;
    Patch *next() {return _next;}
};

class Code_Patch : public Patch {
public:
	Code_Patch(Code_Patch *n,unsigned o) : Patch(n), offset(o) {}
	virtual void apply(char *code_buffer) = 0;
    virtual bool is_overridden_patch() {return false;}
	const unsigned offset;	// offset of instruction being patched
};

class Call_Patch : public Code_Patch {
public:
	Call_Patch(Code_Patch *n,unsigned o,char *t) : Code_Patch(n,o), target(t){}
	//
	// target of this call
	//
	char *const target;
	void apply(char *code_buffer);
	void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
};

class Cfg_Node;
class Branch_Patch : public Code_Patch {
public:
	Branch_Patch(Code_Patch *n,unsigned o, Cfg_Node *t)
        : target(t), Code_Patch(n,o) {}
    void apply(char *code_buffer);
	void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
    Cfg_Node *const target;
};

#ifdef PLDI_OVERRIDDEN
class Overridden_Patch : public Code_Patch {
public:
    Overridden_Patch(Code_Patch *n, unsigned o, unsigned l, 
        Cfg_Node *t, Method_Handle m)
        : m_handle(m), target(t), length(l), Code_Patch(n,o) {}
    void apply(char *code_buffer);
    bool is_overridden_patch() {return true;}
	void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
    Cfg_Node *const target;
    unsigned const  length;
    Method_Handle   m_handle;
};
#endif
class Data_Patch : public Patch {
public:
    Data_Patch(Data_Patch *n, unsigned d_off, unsigned c_off) 
        : Patch(n), data(d_off), offset(c_off) {}

    const unsigned  data;    // offset to the data block
	const unsigned  offset;  // offset to the code block
	void  apply(char *code_buffer, char *data_buffer);
	void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
};

class NextPC_Patch : public Code_Patch {
public:
    NextPC_Patch(Code_Patch *n, unsigned o, Cfg_Node *succ)
        : Code_Patch(n, o), succ(succ) {}
    void apply(char *code_buffer);
	void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
    Cfg_Node *const succ;
};

class Table_Switch_Patch {
public:
    Table_Switch_Patch *const next;
    Cfg_Node *const target;
    char *const data_label;
    Table_Switch_Patch(Table_Switch_Patch *n,char *label, Cfg_Node *t)
        : next(n), data_label(label), target(t) {}
	void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
	void  apply(char *code_buffer);
};

class O3_Emitter : public X86_Emitter {
public:
    O3_Emitter(O3_Data_Emitter& de, Mem_Manager& m,unsigned byteCodeSize) 
        : mem(m), data_emitter(de), X86_Emitter(m,byteCodeSize) { 
        code_patch = NULL;
        table_switch = NULL;
        n_words_pushed = 0;
        patch_switch_br = NULL;
    }

    Mem_Manager& mem;
    O3_Data_Emitter& data_emitter; 
    Code_Patch *code_patch; // for branches
    Table_Switch_Patch *table_switch; 
    Cfg_Node *curr_node; // current cfg_node that we are emitting
    int n_words_pushed;  // n_words that are pushed onto the runtime stack
    char *patch_switch_br;
};


#endif // _CODE_EMITTER_H_
