// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/stack.h,v 1.2 2001/08/13 10:00:42 xhshi Exp $
//



#ifndef _STACK_H_
#define _STACK_H_

#include "register_manager.h"
#include "Mem_Manager.h"

#ifdef _CSE
#include "cse.h"
#endif // _CSE

#define MAX_FP_STACK   8

class Code_Emitter;
class Operand;
class Pre_Alloc_Operand_Pool;
class CG_Prepass;

class Stack {
public:
	Stack(Mem_Manager& mem_manager,Code_Emitter& e,
		Pre_Alloc_Operand_Pool& p, Frame& f,unsigned sz,
        CG_Prepass& pre, bool fp_strict) : prepass(pre), fp_strict_mode(fp_strict),
#ifdef _CSE
		cse(new (mem_manager) CSE(mem_manager,sz)),
#endif // _CSE
		emitter(e), op_pool(p), _frame(f), size(sz), reg_manager(mem_manager){
		_top = _spill_mark = _home_mark = 0 ;
		_fp_cnt = 0;
		// allocate space from heap
		_elems = (Operand**)mem_manager.alloc(sizeof(Operand*)*sz);
		reg_manager.init_stack(this);
		_curr_bc = NULL;
		_hint_for_call_site = 0;
	}
	void reset() {
		_top = _spill_mark = _home_mark = 0;
		reg_manager.reset();
#ifdef _CSE
		cse->clear_cse_stack();
#endif // _CSE
	}
	Operand *pop();
	void pop(unsigned n);
	void pop64(Operand *&opnd_lo, Operand *&opnd_hi);
	void push(Operand *opnd);
	void push64(Operand *opnd_lo,Operand *opnd_hi);
	Operand *top() { return (_top == 0)? NULL : _elems[_top-1];}
	Operand *nth(unsigned i) { return _elems[_top - i - 1];} // top() == nth(0)
	void replace_nth(unsigned i, Operand *opnd) {_elems[_top - i - 1] = opnd;}
	int  spill_one(unsigned local_regs);
	void home_all();
	void call_home(unsigned n_args);
	void spill_opnds_contain(X86_Reg_No);
	unsigned depth() {return _top;}
	void no_laziness(Frame& frame, unsigned var_no, X86_Reg_No reg);
	void no_laziness(Frame& frame, unsigned var_no, X86_Reg_No reg_lo, X86_Reg_No reg_hi);
    void maintain_precise_exception();
	//
	// record bytecode that generates calls
	//
	void mark_curr_bc(const unsigned char *bc)  {_curr_bc = bc;}
	void mark_first_bc(const unsigned char *bc) {_first_bc = bc;}
	const unsigned char *curr_bc() {return _curr_bc;}
	int  curr_bc_index() {return _curr_bc - _first_bc;}

#ifdef _CSE
	void push_cse(Operand *opnd,int cse_len);
	void combine_cse_exp(Operand *dst,int len,unsigned is_long);
	void update_cse(Operand *opnd,int ith_popped) {
		cse->update_cse(_first_bc,opnd,reg_manager.local_regs(),ith_popped);
	}
	CSE *const cse;
#endif // _CSE
        void fp_inc_cnt() {_fp_cnt++;}

	void fp_dec_cnt() {
	    if (fp_get_cnt() > 0) {
                _fp_cnt--;
            }
        }

	int fp_get_cnt()  {return _fp_cnt;}
	void fp_reset_stack() {_fp_cnt = 0;}
	bool fp_check_stack(unsigned is_dbl, Pre_Alloc_Operand_Pool &op_pool, Code_Emitter &e);
    Frame& frame() {return _frame;}
	Register_Manager  reg_manager;
	Code_Emitter&     emitter;
	Pre_Alloc_Operand_Pool& op_pool;
	const unsigned size;
    const bool fp_strict_mode;
private:
	int  _home_one_opnd_with_caller_reg(unsigned local_regs);
	int  _spilling_without_extra_reg(Operand *opnd, unsigned entry);
	void _home_opnd(Operand *opnd, unsigned entry);

	unsigned _top, _spill_mark, _home_mark;
	Operand **_elems;
	Frame& _frame;
	int _fp_cnt;
	const unsigned char *_curr_bc;
	const unsigned char *_first_bc;
	CG_Prepass& prepass;
	unsigned _hint_for_call_site;
};
#endif // _STACK_H_
