// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/profiling.cpp,v 1.2 2001/08/13 10:00:42 xhshi Exp $
//

#include "platform.h"
#include <iostream.h>
#include "defines.h"
#include "jit_intf.h"
#include "internal_jit_intf.h"
#include "bit_vector.h"
#include "code_emitter.h"
#include "operand.h"
#include "jit.h"
#include "profiling.h"
#include "lazy_code_selector.h"

bool statistics    = false;
bool inner_statistics = false ;
bool b_inner_counter = false;
FILE* emitter_offset_fp = NULL;

void print_profiling_info(JIT_Handle jit_handle) {
    if (!statistics) return;
	FILE* fp_profile = NULL;
	if ( fp_profile == NULL)
		fp_profile = fopen( "o1_profile.txt", "w+");

	assert(fp_profile) ;

    for (Method_Iterator mi = method_get_first_method_jit(jit_handle); 
         mi != JAVA_METHOD_END;
         mi = method_get_next_method_jit(mi)) {
        Method_Handle m = method_get_method_jit(mi);
        // retrieve method info
        Small_Method_Info *smi = (Small_Method_Info*)method_get_info_block(m,jit_handle);
        Profile_Rec *prof_rec = smi->prof_rec;
        if (prof_rec == NULL) continue;
		/*
        cout << class_get_name(method_get_class(m)) << "."
                 << method_get_name(m)
                 << method_get_descriptor(m)
		        << " : ";
        // print profiling info
		cout << "\tTimes being entered=" ;
		char buf[64] ;
		sprintf(buf, "%I64u",prof_rec->m_entry) ;
		cout << buf << "; " << endl;
		*/

        unsigned short *bc_idx = (unsigned short*)&prof_rec->back_edge[prof_rec->n_back_edge];

		fprintf( fp_profile,"Method_Name: %s.%s%s\n",class_get_name(method_get_class(m)),
											method_get_name(m) ,
											method_get_descriptor(m)) ;

		fprintf( fp_profile, "      BB # %d\t%p\t%I64u\n", 0, &prof_rec->m_entry, prof_rec->m_entry);
		unsigned i = 0 ;
/*
        for (i = 0; i < prof_rec->n_bb; i++) {
            if (info[i] == 1)
				fprintf(fp,"      BB #@ %d\t" , label[i]) ;
            else
				fprintf(fp,"      BB # %d\t" , label[i]) ;
            if (sizeof(O3_PROF_COUNTER) == sizeof(uint64)) {
				fprintf(fp,"%p\t%I64u\n", &prof_rec->bb[i], prof_rec->bb[i]) ;
            } else
				fprintf(fp,"%p\t%lu\n", &prof_rec->bb[i], prof_rec->bb[i]) ;
        }
*/		

		for (i = 0; i < prof_rec->n_back_edge; i++)
		{
			fprintf( fp_profile, "      BB # %d\t%p\t%I64u\n", i + 1, &prof_rec->back_edge[i], prof_rec->back_edge[i]);
			fflush( fp_profile);
		}

		///
		//
		// print out inner bb counters
		//
        for (i = 0; i < prof_rec->n_back_edge * (unsigned)INNER_BRANCH; i++){
			PROF_COUNTER c = ((PROF_COUNTER*)&((unsigned short*)&prof_rec->back_edge[prof_rec->n_back_edge])[prof_rec->n_back_edge])[i] ;
			if(c == __UINT64_C(0xFFFFFFFFFFFFFFFF) ) break ;
			
			//sprintf(buf, "Inner Basic Block Counter Address [%x] = %I64u",&((PROF_COUNTER*)&((unsigned short*)&prof_rec->back_edge[prof_rec->n_back_edge])[prof_rec->n_back_edge])[i],c) ;
			fprintf(fp_profile, "Inner_bb_counter: %p\t%I64u\n",&((PROF_COUNTER*)&((unsigned short*)&prof_rec->back_edge[prof_rec->n_back_edge])[prof_rec->n_back_edge])[i],c) ;
			fflush(fp_profile);
			//cout << buf << "; " ;
		}
		//cout << endl ;
    }
}

/*
void print_profiling_info(JIT_Handle jit_handle) {
    if (!statistics) return;
    cout << "\n\n=============== profile output ====================" << endl; 
    for (Method_Iterator mi = method_get_first_method_jit(jit_handle); 
         mi != JAVA_METHOD_END;
         mi = method_get_next_method_jit(mi)) {
        Method_Handle m = method_get_method_jit(mi);
        // retrieve method info
        Small_Method_Info *smi = (Small_Method_Info*)method_get_info_block(m,jit_handle);
        Profile_Rec *prof_rec = smi->prof_rec;
        if (prof_rec == NULL) continue;
        cout << class_get_name(method_get_class(m)) << "."
                 << method_get_name(m)
                 << method_get_descriptor(m)
		         << " : ";
        // print profiling info
		cout << "\tTimes being entered=" ;
		char buf[64] ;
		sprintf(buf, "%I64u",prof_rec->m_entry) ;
		cout << buf << "; " ;

        unsigned short *bc_idx = (unsigned short*)&prof_rec->back_edge[prof_rec->n_back_edge];
        for (unsigned i = 0; i < prof_rec->n_back_edge; i++){
            cout << "\tBC " << bc_idx[i] << "\t Basic Block[" << i << "]: " ;
			sprintf(buf, "%I64u",prof_rec->back_edge[i]) ;
            cout << buf << "; " ;
		}
		cout << endl ;
		//
		// print out inner bb counters
		//
        for (i = 0; i < prof_rec->n_back_edge * (unsigned)INNER_BRANCH; i++){
			PROF_COUNTER c = ((PROF_COUNTER*)&((unsigned short*)&prof_rec->back_edge[prof_rec->n_back_edge])[prof_rec->n_back_edge])[i] ;
			if(c > __UINT64_C(0)){
				sprintf(buf, "Inner Basic Block Counter Address [%x] = %I64u",&((PROF_COUNTER*)&((unsigned short*)&prof_rec->back_edge[prof_rec->n_back_edge])[prof_rec->n_back_edge])[i],c) ;
				cout << buf << "; " ;
			}
		}
		cout << endl ;
    }
}
*/

void inserting_instrumenting_code(Code_Emitter& emitter, 
                                  Profile_Patch& prof_patch,
                                  unsigned bc_idx,
                                  unsigned* cnt_addr) {
    if (!instrumenting) return;

    if (statistics) {
		//
		// Record the offset and address in emitter.offset_buf
		//
		if(emitter.offset_buf){
			assert(emitter.offset_buf_offset < 4997) ;
			emitter.offset_buf[emitter.offset_buf_offset*2] = emitter.get_offset() ;
			emitter.offset_buf[emitter.offset_buf_offset*2+1] = (unsigned)cnt_addr ;
			emitter.offset_buf_offset++ ;
		}

	    emitter.emit_alu(add_opc,&M_Opnd((unsigned)cnt_addr),&Imm_Opnd(1));
        if (sizeof(PROF_COUNTER) == sizeof(int64))
            emitter.emit_alu(adc_opc,&M_Opnd((unsigned)(cnt_addr+1)), &Imm_Opnd(0));
    } else {
    //    emitter.emit_alu(sub_opc,&M_Opnd((unsigned)cnt_addr),&Imm_Opnd(1));
        emitter.emit_dec(&M_Opnd((unsigned)cnt_addr));
        if (!recompilation_thread) {
	        emitter.emit_branch32(cc_eq,&Imm_Opnd(0),0);
            //
            // record offset & addr for code patching later
            //
            unsigned entry = prof_patch.entry++;
            prof_patch.IP_offset[entry] = emitter.get_offset();
            prof_patch.addr[entry] = emitter.get_next() - 4;
            prof_patch.bc_idx[entry] = bc_idx;
        }
    }
}

unsigned estimate_prof_rec_size(unsigned num_be_entries) {
    unsigned extra_entries = (num_be_entries == 0)? 0 : num_be_entries-1;
	unsigned inner_branch_num = 0 ;
	if(inner_statistics){ // for inner basic block counters in one method.
		inner_branch_num = num_be_entries*INNER_BRANCH > MIN_INNER_BRANCH_SIZE ? num_be_entries*INNER_BRANCH : MIN_INNER_BRANCH_SIZE ;
	} 
    return sizeof(Profile_Rec) +                     // default size
           sizeof(PROF_COUNTER)*extra_entries +      // for back_edge counters
           sizeof(unsigned short)*(num_be_entries) + // for bc_idx mapping
		   sizeof(PROF_COUNTER)* inner_branch_num ;		   
}

//
// create a profiling record for each method
//
Profile_Rec *create_profile_rec(Method_Handle m_handle,
                                Compile_Handle comp_handle,
                                unsigned n_be,
                                unsigned bc_size) {
    if (!instrumenting) return NULL;

    unsigned sz = estimate_prof_rec_size(n_be);
    Profile_Rec *prof_rec = 
        (Profile_Rec*)method_allocate_jit_data_block(m_handle,comp_handle,sz);
    // 
    // initialize profiling record
    //
    prof_rec->n_back_edge = n_be;
    prof_rec->been_recompiled = false;
    if (statistics) {
        prof_rec->m_policy = sizeof(PROF_COUNTER)==sizeof(uint64) ? __UINT64_C(0) : 0;
        prof_rec->m_entry = sizeof(PROF_COUNTER)==sizeof(uint64) ? __UINT64_C(0) : 0;  // set counter to zero
		unsigned i = 0 ;
        for (i = 0; i < n_be; i++)
            prof_rec->back_edge[i] = sizeof(PROF_COUNTER)==sizeof(uint64) ? __UINT64_C(0) : 0; // set counter to zero
		for (i = 0 ; i< n_be ; i++)
			((unsigned short*)&prof_rec->back_edge[n_be])[i] = 0 ;
		//
		// Set inner basic block counter to zero
		//
		if(inner_statistics){ // for inner basic block counters in one method.
			unsigned inner_branch_num = n_be*INNER_BRANCH > MIN_INNER_BRANCH_SIZE ? n_be*INNER_BRANCH : MIN_INNER_BRANCH_SIZE ;
			for (i = 0; i < inner_branch_num; i++)
				((PROF_COUNTER*)&((unsigned short*)&prof_rec->back_edge[n_be])[n_be])[i] = sizeof(PROF_COUNTER)==sizeof(uint64) ? __UINT64_C(0) : 0; // set counter to zero
		}
    } else {
        prof_rec->m_entry   = recompilation_policy_method;
        prof_rec->m_policy  = prof_rec->m_entry;
        for (unsigned i = 0; i < n_be; i++)
            prof_rec->back_edge[i] = recompilation_policy_loop; 
    }
    return prof_rec;
}

//
// insert code to call recompilation routine which will trigger dynamic 
// optimizer
//
char *addr_of_trigger_recompilation();
void insert_call_recompilation(Mem_Manager&   mm,
                               Code_Emitter&  emitter, 
                               Code_Patch*&   code_patch_list,
                               Profile_Patch& prof_patch,
                               JIT_Handle     jit_handle,
                               Method_Handle  m_handle,
                               Jit_Method_Info *m_info,
                               Recomp_Entry   *recomp_entries) {
    char *addr = addr_of_trigger_recompilation();
    for (unsigned i = 0; i < prof_patch.entry; i++) {
        //
        // patch the offset of the branch that branches to this call
        //
	    Imm_Opnd(emitter.get_offset() - prof_patch.IP_offset[i]).emit32(prof_patch.addr[i]);
        //
        // push 2 arguments, jit_handle and method_info
        //
        unsigned call_off = emitter.get_offset();
        m_info->cs_info[m_info->cnt].call_IP = call_off;
	    emitter.emit_push(&Imm_Opnd((unsigned)jit_handle));
	    make_esp_record(emitter.get_offset(),0,m_info,mm);
	    emitter.emit_push(&Imm_Opnd((unsigned)m_handle));
	    make_esp_record(emitter.get_offset(),1,m_info,mm);
        //
        // emit call trigger_recompilation()
        //
	    unsigned patch_offset = emitter.get_offset()+1;
        m_info->cs_info[m_info->cnt].precall_IP = emitter.get_offset();
        m_info->cs_info[m_info->cnt].returns_ref = 0; 
	    emitter.emit_call((char*)addr);
        m_info->cs_info[m_info->cnt].ret_IP = emitter.get_offset();
        m_info->cs_info[m_info->cnt].outarg_bv = 0; // none of outarg is a ref
        m_info->cs_info[m_info->cnt].m_handle = NULL;
        m_info->cs_info[m_info->cnt++].num_out_args = 2;
	    code_patch_list = new(mm) Call_Patch(code_patch_list,patch_offset,(char*)addr);
        //
        // jump back to the next IP of the branch that branches to this call
        //
        int disp = prof_patch.IP_offset[i] - emitter.get_offset();
        emitter.emit_jump(disp);
        //
        // find corresponding recomp_entry and fill in call_off
        //
	
	    Recomp_Entry *re;
        for (re = recomp_entries; re != NULL; re = re->next) 
            if (re->bc_index == prof_patch.bc_idx[i]) break;
        assert(re != NULL);
        re->IP_offset = call_off;
    }
}


//
// For statistics instrument in inner bb
//
void inner_bb_instrumenting_code(Code_Emitter& emitter, 
                                  unsigned* cnt_addr) {
    if (inner_statistics) {
		//
		// Record the offset and address in emitter.offset_buf
		//
		if(emitter.offset_buf){
			assert(emitter.offset_buf_offset < 9997) ;
			unsigned buf_len = emitter.prof_rec->n_back_edge * (unsigned)INNER_BRANCH > MIN_INNER_BRANCH_SIZE ? 
							emitter.prof_rec->n_back_edge * (unsigned)INNER_BRANCH : MIN_INNER_BRANCH_SIZE ;
			assert(emitter.inner_bb_cnt_offset < buf_len-1) ;
			emitter.offset_buf[emitter.offset_buf_offset*2] = emitter.get_offset() ;
			emitter.offset_buf[emitter.offset_buf_offset*2+1] = (unsigned)cnt_addr ;
			emitter.offset_buf_offset++ ;
		}

	    emitter.emit_alu(add_opc,&M_Opnd((unsigned)cnt_addr),&Imm_Opnd(1));
        if (sizeof(PROF_COUNTER) == sizeof(int64))
            emitter.emit_alu(adc_opc,&M_Opnd((unsigned)(cnt_addr+1)), &Imm_Opnd(0));
    }
}
