// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/lazy_code_selector.h,v 1.2 2001/08/13 09:59:59 xhshi Exp $
//


#ifndef _LAZY_CODE_SELECTOR_H_
#define _LAZY_CODE_SELECTOR_H_

class Code_Emitter;
class CG_Prepass;
class Frame;
class Stack;
class Pre_Alloc_Operand_Pool;
class M_Opnd;
class Register_Allocator;
class Dbg;

#include "jit_intf.h"
#include "jit.h"
#include "code_gen.h"

#ifdef VTune_Support
#include "ijitprof.h"
#endif // VTune_Support

JIT_Result	select_code(Mem_Manager&	mem_manager,
                        Code_Emitter&	emitter,
                        CG_Prepass&		prepass,
                        Frame&          frame,
                        Stack&          stack,
                        Pre_Alloc_Operand_Pool&	op_pool,
                        Compile_Handle  compilationHandle,
                        Class_Handle    classHandle,
                        Method_Handle   methodHandle,
                        const BYTE      *byteCodeAddr,
                        size_t          byteCodeSize,
                        JIT_Flags       flags,
                        Jit_Method_Info *method_info,
                        Register_Allocator *regalloc,
                        Profile_Rec     *prof_rec,
                        Dbg             *dbg_support,
                        CODE_MI         code_mi
#ifdef VTune_Support
                        , iJIT_Method_Load *mInfo
#endif // VTune_Support
                        );

extern void gen_store32(Code_Emitter& emitter,Stack& stack,
                        M_Opnd *opnd,Operand*& src);

extern void make_esp_record (unsigned code_offset,
                             unsigned num_args_on_stack,
                             Jit_Method_Info *method_info,
                             Mem_Manager &mem_manager);

//
// generic patch used to patch branch and call displacements after
// code has been copied into the code space.
//
class Patch {
protected:
	Patch *const _next;		// next patch in list
	Patch(Patch *n) : _next(n) {}
public:
    virtual void apply(char *code_buffer) = 0;
    Patch *next() {return _next;}
};

class Data_Patch : public Patch {
public:
	Data_Patch(Patch *n,char *d) : Patch(n), data(d) {}
	char *data;		// ptr to data being patched
};

class Code_Patch : public Patch {
public:
	Code_Patch(Code_Patch *n,unsigned o) : Patch(n), offset(o) {}
	//Code_Patch *next() {return (Code_Patch*)_next;}
	virtual void apply(char *code_buffer) = 0;
	const unsigned offset;	// offset of instruction being patched
};

class Call_Patch : public Code_Patch {
public:
	Call_Patch(Code_Patch *n,unsigned o,char *t) 
		: Code_Patch(n,o), target(t) {}
	//
	// target of this branch
	//
	char *const target;
	void apply(char *code_buffer);
	void *operator new(size_t sz,Mem_Manager& m) {
		return m.alloc(sz);
	}
};

class Branch_Patch : public Code_Patch {
public:
	Branch_Patch(Code_Patch *n,unsigned o,Branch_Patch *b) 
		: Code_Patch(n,o) {next_branch = b;}
	Branch_Patch(Code_Patch *n,unsigned o,unsigned t)
		: Code_Patch(n,o) {target_offset = t;}
	union {
		//
		// offset of branch target
		//
		unsigned		target_offset;
		//
		// next branch to this label
		//
		Branch_Patch	*next_branch;
	};
	void apply(char *code_buffer);
	void *operator new(size_t sz,Mem_Manager& m) {
		return m.alloc(sz);
	}
};
//
// patch for an entry in a switch table
//
class Table_Entry_Patch : public Branch_Patch {
public:
	Table_Entry_Patch(Table_Entry_Patch *n,unsigned d,Branch_Patch *b) 
		: Branch_Patch(n,0,b),data_offset(d) {}
	Table_Entry_Patch(Table_Entry_Patch *n,unsigned d,unsigned o) 
		: Branch_Patch(n,0,o),data_offset(d) {}
	Table_Entry_Patch *next() {return (Table_Entry_Patch*)_next;}
	const unsigned data_offset;
	void apply(char *code_block,char *data_block);
	void *operator new(size_t sz,Mem_Manager& m) {
		return m.alloc(sz);
	}
};

class Mov_Patch : public Branch_Patch {
public:
	Mov_Patch(Code_Patch *n,unsigned o,Branch_Patch *b) 
		: Branch_Patch(n,o,b) {}
	void apply(char *code_block);
	void *operator new(size_t sz,Mem_Manager& m) {
		return m.alloc(sz);
	}
};

union Map_Entry {
	unsigned	  offset;
	Branch_Patch *patch;
};

#endif // _LAZY_CODE_SELECTOR_H_
