// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/cg_load_store.cpp,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//

#include "defines.h"
#include <iostream.h>
#include "code_emitter.h"
#include "stack.h"
#include "operand.h"
#include "lazy_code_selector.h"
#include "cg_prepass.h"
#include "gc_tags.h"
#include "regalloc.h"
#include "cg_load_store.h"

#include "x86.h"

#ifndef NO_BOUNDS_CHECKING
#include "bounds_checking.h"
#endif // NO_BOUNDS_CHECKING

#include "register_allocator.h"

extern void GC_Tags_emit_clear(Frame& frame,Code_Emitter& emitter,
							   CG_Prepass& prepass,unsigned index);

extern void GC_Tags_emit_set(Frame& frame,Code_Emitter& emitter,
							 CG_Prepass& prepass,unsigned index);

void gen_reg_store32(Code_Emitter& emitter,Stack& stack,X86_Reg_No reg,Operand *src) {
    src->emit_mov_to_reg(emitter,&reg_operand_array[reg]);
	src->free_opnd(&stack.reg_manager);
}

void gen_reg_inc32(Code_Emitter &emitter,X86_Reg_No reg, Imm_Opnd *imm) {
    emitter.emit_alu(add_opc,&reg_operand_array[reg],imm);
}

void gen_int_load(Mem_Manager& mem_manager,
					 Code_Emitter& emitter,
					 Stack& stack,
					 Jit_Method_Info *method_info,
                     Register_Allocator *regalloc,
					 Frame& frame,
					 unsigned index,
					 unsigned is_ref) {
	X86_Reg_No reg;
    reg = regalloc->reg_var_allocated_to(index, NULL /*XXX-hack*/);
	//
	// if a reg is assigned to the var, then the register is pushed onto the
	// mimic stack (in other words, there is no need to access memory (load)
	//
	if (reg != n_reg) {
		Reg_Operand *r = stack.reg_manager.get_reg(reg);
		if (is_ref) r->set_ref();
		stack.push(r);
	} else
	if ((reg = stack.reg_manager.find_reg_value(index)) != n_reg) // for LOAD_STORE
		stack.push(stack.reg_manager.get_reg(reg));
	else
		stack.push(new(mem_manager) Mem_Var_Operand(frame,index,is_ref));
}

void gen_int_store(Code_Emitter& emitter,
					  Stack& stack,
					  CG_Prepass& prepass,
					  Jit_Method_Info *method_info,
                     Register_Allocator *regalloc,
					  Frame& frame,
					  unsigned index) {
	if(IS_INVALID_RV_BITMAP(method_info->ref_var_bitmap))
		GC_Tags_emit_clear(frame,emitter,prepass,index);

	Operand *src = stack.pop();
	X86_Reg_No reg = regalloc->reg_var_allocated_to(index, NULL/*XXX-hack*/);
if (reg != n_reg) {
		stack.no_laziness(frame,index,reg);
		gen_reg_store32(emitter,stack,reg,src);
	} else {
		stack.no_laziness(frame,index,n_reg);
		gen_store32(emitter,stack,&M_Var_Opnd(frame,index),src);
		stack.reg_manager.reg_value(src,index);  // for LOAD_STORE
	}
#ifdef _CSE
	stack.cse->kill_reg_cse(stack.curr_bc_index(),index);
#endif // _CSE
}

void gen_astore(Code_Emitter& emitter,
                Stack& stack,
                CG_Prepass& prepass,
                Jit_Method_Info *method_info,
                Register_Allocator *regalloc,
                Frame& frame,
			    unsigned index,
			    const unsigned char *curr_bc
#ifndef NO_BOUNDS_CHECKING
				, Bounds_Checking& bounds
#endif // NO_BOUNDS_CHECKING
                ) {
	if(IS_INVALID_RV_BITMAP(method_info->ref_var_bitmap)) {
	//
	// If this astore is the target of a jsr bytecode (i.e. the first bytecode
	// in a finally), then instead of setting it to be enumerated, make it a kill
	// for the variable. Such an astore is storing a return IP, not a reference!!!.
	//
	struct Finally_Bytecode_List *fbl = prepass.finally_bc_list;
	bool is_finally = FALSE;
	while (fbl) {
		if (fbl->bc == curr_bc) {
			is_finally = TRUE;
			break;
		}
		fbl = fbl->next;
	}
	if (is_finally)
		GC_Tags_emit_clear(frame,emitter,prepass,index);
	else
		GC_Tags_emit_set(frame,emitter,prepass,index);
	}

	Operand *src = stack.pop();

#ifndef NO_BOUNDS_CHECKING
	bounds.reset(index);
	if (src->is_reg()) {
		X86_Reg_No src_no = ((Reg_Operand*)src)->opnd.reg_no();
		if (stack.reg_manager.is_newarray_in_reg(src_no)) {
			bounds.record(index,bounds.scratch_bound(src_no)-1);
		}
	}
#endif // NO_BOUNDS_CHECKING

	X86_Reg_No reg = regalloc->reg_var_allocated_to(index, NULL /*XXX-hack*/);
	if (reg != n_reg) {
		stack.no_laziness(frame,index,reg);
		gen_reg_store32(emitter,stack,reg,src);
	} else {
		stack.no_laziness(frame,index,n_reg);
		gen_store32(emitter,stack,&M_Var_Opnd(frame,index),src);
		stack.reg_manager.reg_value(src,index); // for LOAD_STORE
	}
#ifdef _CSE
	stack.cse->kill_reg_cse(stack.curr_bc_index(),index);
#endif // _CSE
}

void gen_iinc(Code_Emitter& emitter,Stack& stack,
              Jit_Method_Info *method_info,
              Register_Allocator *regalloc,
			  Frame& frame,unsigned index,int imm) {
	X86_Reg_No reg = regalloc->reg_var_allocated_to(index, NULL/*XXX-hack*/);
	if (reg != n_reg) {
		stack.no_laziness(frame,index,reg);
		gen_reg_inc32(emitter,reg,&Imm_Opnd(imm));
	} else {
		stack.no_laziness(frame,index,n_reg);
		emitter.emit_alu(add_opc,&M_Var_Opnd(frame,index),&Imm_Opnd(imm));
		stack.reg_manager.reset_store(index); // for LOAD_STORE
	}
#ifdef _CSE
	stack.cse->kill_reg_cse(stack.curr_bc_index(),index);
#endif // _CSE
}
