// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/debugger/debugger_ia32_breakpoint.cpp,v 1.2 2001/12/07 00:16:00 xli18 Exp $
//

#include "platform.h"
#include <stdio.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <iostream.h>
#include "environment.h"
#include "orp_types.h"
#include "object_layout.h"
#include "jit_intf_cpp.h"
#include "method_lookup.h"
#include "stack_manipulation.h"
#include "Class.h"
#include "sync_bits.h"

#include "compile.h"
#include "ini.h"

#ifdef ORP_POSIX
#include <unistd.h>

#else
#include <io.h>
//#include <orp_io.h>
#endif

#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "jvmdi_clean.h"
#include "orp_utils.h"

#include "jit_intf.h"

#include "level_1a_jit_intf.h"


#include "debugger_jvmdi_ia32.h"
#include "debugger_ia32_utils.h"
#include "debugger_ia32_breakpoint.h"

#ifdef ORP_POSIX
#include "platform2.h"
#endif


void set_breakpoint(char* position,breakpoint_level bp_level,Method *curr_method)
{
    char buff[100];
    char sub_str2[100],sub_str1[100];
    char sub_str3[BUFF_SIZE];
    Method *p_meth = 0;
    Class *p_clss = 0;
    int bp_no;
    if (bp_level==source_level)
        bp_no = breakpoints_num;
    else 
        if (bp_level == bytecode_level)
            bp_no = bytecode_breakpoints_num;
    strcpy(buff,position);
    if (buff[0]==0)
        return;
    if (buff[0] ==':'){ // set breakpoint in curr method,curr class
        if (curr_method == 0){
            orp_cout<< "can't set breakpoint at curr class,curr method"<<endl;
            return;
        } else{
            p_meth = curr_method;
            p_clss = p_meth->get_class();
            strcpy(sub_str3,(char *)(buff+1));
        }
    } else {
        separate_str_from_end(buff,'.',sub_str1,sub_str2);
        if ((!(*sub_str1))||(!(*sub_str2))){
	        orp_cout<<"the breakpoint's format is <class>.<method>[:<line>]"<<endl;
            return;
        }
        strcpy(buff,sub_str2);
        separate_str(buff,':',sub_str2,sub_str3);

        //memset(breakpoints[bp_no].buff_class, 0, BUFF_SIZE);
        str_chg_chs(sub_str1,'.','/');
        char buff_class[100];
        strcpy(buff_class,sub_str1);
        String *p_c_str = ORP_Global_State::loader_env->string_pool.lookup(
                                (const char *)buff_class);

        p_clss  = ORP_Global_State::loader_env->class_table.lookup(p_c_str);

        if (p_clss == 0) {
            Loader_Exception ld_exc;
            p_clss = load_class(ORP_Global_State::loader_env, p_c_str, &ld_exc);
            if (p_clss == 0) {
                orp_cout << "error: can't find class " << breakpoints[bp_no].buff_class << endl;
                return;
            }
        }

        
        char buff_method[100];
        strcpy(buff_method,sub_str2);
        String *p_m_str = ORP_Global_State::loader_env->string_pool.lookup(
                                        (const char *)buff_method);
        int meths_num=0;
	    uint32 selection = -1;
    
	    for (uint32 kk = 0; kk < p_clss->n_methods; kk++) {
                Method *p_m = &(p_clss->methods[kk]);
                if ( !strcmp(p_m->get_name()->bytes, buff_method ) ) {
                    if (meths_num==0)
					    selection = kk;
				    meths_num++;
                }               
        }
        if (meths_num>1) {
		    for (uint32 kk = 0; kk < p_clss->n_methods; kk++) {
				    Method *p_m = &(p_clss->methods[kk]);
				    if ( !strcmp(p_m->get_name()->bytes, buff_method ) ) {
					    orp_cout << (int)kk << ") " << p_clss->methods[kk].get_descriptor() << endl;
				    }               
		    }
		    orp_cout << "select one of the above>";
		    my_gets(buff);
		    if ( strlen(buff) == 0)
			     return;
		    selection = atoi(buff);
		    if ((selection > (uint32)(p_clss->n_methods - 1))||(selection<0))
			    return;
	    }
        p_meth = &(p_clss->methods[selection]);
           ///p_meth = class_lookup_method(p_clss, sig);
        if (p_meth == 0) {
            orp_cout << "error: method does not exist " << endl;
            return;
        }
    }   
    if (bp_level == source_level){
        memset(breakpoints[bp_no].buff_class, 0, BUFF_SIZE);
        strcpy(breakpoints[bp_no].buff_class, p_clss->name->bytes);
        memset(breakpoints[bp_no].buff_method, 0, BUFF_SIZE);
        strcpy(breakpoints[bp_no].buff_method,p_meth->get_name()->bytes);
    } else if (bp_level== bytecode_level){
        memset(bytecode_breakpoints[bp_no].buff_class, 0, BUFF_SIZE);
        strcpy(bytecode_breakpoints[bp_no].buff_class, p_clss->name->bytes);
        memset(bytecode_breakpoints[bp_no].buff_method, 0, BUFF_SIZE);
        strcpy(bytecode_breakpoints[bp_no].buff_method,p_meth->get_name()->bytes);
    }
    
    if (bp_level== source_level){
        memset(breakpoints[bp_no].buff_descriptor, 0, BUFF_SIZE);
        strcpy(breakpoints[bp_no].buff_descriptor, 
                   p_meth->get_descriptor() );
        breakpoints[bp_no].method_handle = (void *)p_meth;
    } else if (bp_level==bytecode_level){
        memset(bytecode_breakpoints[bp_no].buff_descriptor, 0, BUFF_SIZE);
        strcpy(bytecode_breakpoints[bp_no].buff_descriptor, 
                   p_meth->get_descriptor() );
        bytecode_breakpoints[bp_no].method_handle = (void *)p_meth;
    }
    
    if (bp_level == source_level){
        breakpoints[bp_no].line_no = BREAKPOINT_AT_BEGIN;       // means the first line of the method 
	    if (*sub_str3)	
		    breakpoints[bp_no].line_no = atoi(sub_str3);
    } else if (bp_level== bytecode_level){
            bytecode_breakpoints[bp_no].line_no = BREAKPOINT_AT_BEGIN;       //  means the first line of the method 
    	    if (*sub_str3)	
	    	    bytecode_breakpoints[bp_no].line_no = atoi(sub_str3);

    }

    if (p_meth->get_state() == Method::ST_Compiled )
    {
        JVMDI_line_number_entry line_table[1];
        if (bp_level == source_level){
            int n_entry = method_get_line_number_table_size(p_meth);
            if (n_entry == 0){
                orp_cout << "no debug line number information" << endl;
                orp_cout << "continue to set breakpoint,use breakb"<<endl;
                return;
            }
            if (breakpoints[bp_no].line_no==BREAKPOINT_AT_BEGIN) {               //  means the first line
			    memset(line_table, 0, sizeof(JVMDI_line_number_entry));
			    method_get_line_number( p_meth,
									    0,
									    (unsigned *)&(line_table[0].start_location),
									    (unsigned *)&(line_table[0].line_number) );
			    breakpoints[bp_no].line_no = line_table[0].line_number;
		    } else {
       
			    for (int dd = 0; dd < n_entry; dd++) {

				    memset(line_table, 0, sizeof(JVMDI_line_number_entry));

				    method_get_line_number( p_meth,
										    dd,
										    (unsigned *)&(line_table[0].start_location),
										    (unsigned *)&(line_table[0].line_number) );

				    if (line_table[0].line_number == (jlocation)breakpoints[bp_no].line_no) 
					    break;
			    }
                if (line_table[0].line_number != (jlocation)breakpoints[bp_no].line_no){
                    orp_cout<<"     can't find the special line"<<endl;
                    return;
                }
		    }
        } else if (bp_level==bytecode_level){
            line_table[0].start_location = bytecode_breakpoints[bp_no].line_no;
            // in bytecode breakpoint, the line_no is the bytecode number.
        }
		
        JIT_Flags jf; jf.insert_write_barriers = 1; jf.generate_debug_info = 0;
		jf.poll_gc = 0; jf.tracing_write_barriers = 0;
		
		uint32 code_offset =  o1_jit->get_break_point_offset(
							   o1_jit->global_compile_handle,
							   p_meth,
							   jf,
							   (unsigned)line_table[0].start_location);
        if (bp_level==source_level){
			breakpoints[bp_no].loc = (jlocation)code_offset;
			breakpoints[bp_no].loc  +=  (jlocation)p_meth->get_code_addr();
			// toss assert( (breakpoints[bp_no].loc & 0xffFFffFF00000000L) == 0);
        	assert( *(uint8 *)(breakpoints[bp_no].loc) != 0);
            if (breakpoints[bp_no].loc == 0) {
                orp_cout << "error: bad line number, setting bp at first ia32 instruction" << endl;
                //memset(&(breakpoints[bp_no]), 0, sizeof(jvmdi_bp) );
                breakpoints[bp_no].loc = (jlocation)p_meth->get_code_addr();
            }
        } else if (bp_level == bytecode_level){
            bytecode_breakpoints[bp_no].loc = (jlocation)code_offset;
			bytecode_breakpoints[bp_no].loc  +=  (jlocation)p_meth->get_code_addr();
			// toss assert( (bytecode_breakpoints[bp_no].loc & 0xffFFffFF00000000L) == 0);
        	assert( *(uint8 *)(bytecode_breakpoints[bp_no].loc) != 0);
        }
		
        
    }

    if (jvmdi_verbose) {
        if (bp_level == source_level){
            orp_cout << endl << "breakpoint " << bp_no << " is now " << endl 
                << breakpoints[bp_no].buff_class << "." 
                << breakpoints[bp_no].buff_method << " " 
                << breakpoints[bp_no].buff_descriptor << " #" 
                << (int32)breakpoints[bp_no].line_no <<"("<<BREAKPOINT_AT_BEGIN
                <<" means begin)";

            orp_cout << " [eip=" << (void *)breakpoints[bp_no].loc << "]" << endl;
        } else if (bp_level == bytecode_level){
            orp_cout << endl << "breakpoint " << bp_no << " is now " << endl 
                << bytecode_breakpoints[bp_no].buff_class << "." 
                << bytecode_breakpoints[bp_no].buff_method << " " 
                << bytecode_breakpoints[bp_no].buff_descriptor << " #" 
                << (int32)bytecode_breakpoints[bp_no].line_no <<"("<<BREAKPOINT_AT_BEGIN
                <<" means begin)";

            orp_cout << " [eip=" << (void *)bytecode_breakpoints[bp_no].loc << "]" << endl;
        }
    }

#ifdef ORP_NT
    int fd = _creat("c:\\temp\\jvmdi_dbg", _S_IREAD | _S_IWRITE  );

    int stat = _write( fd, breakpoints, ( sizeof(jvmdi_bp) * NBREAKPOINTS ) );
    stat = _write( fd, bytecode_breakpoints, ( sizeof(jvmdi_bp) * NBREAKPOINTS ) );

    stat = _close(fd);
#elif defined (ORP_POSIX)
    int fd = creat("/tmp/jvmdi_dbg", S_IREAD | S_IWRITE  );

    int stat = write( fd, breakpoints, ( sizeof(jvmdi_bp) * NBREAKPOINTS ) );
    stat = write( fd, bytecode_breakpoints, ( sizeof(jvmdi_bp) * NBREAKPOINTS ) );
    stat = close(fd);
#endif
	if (bp_level==source_level)
        breakpoints_num++;
    else if (bp_level==bytecode_level)
        bytecode_breakpoints_num++;
    return;
}

void show_one_breakpoint(jvmdi_bp &bpoint){
    if (bpoint.buff_descriptor[0] == 0) {
		orp_cout << endl;
		return;
	}


	String *p_m_str = ORP_Global_State::loader_env->string_pool.lookup(
						(const char *)bpoint.buff_method);

	String *p_d_str = ORP_Global_State::loader_env->string_pool.lookup(
						(const char *)bpoint.buff_descriptor);

	Signature *sig = ORP_Global_State::loader_env->sig_table.lookup(p_m_str, p_d_str);

	String *p_c_str = ORP_Global_State::loader_env->string_pool.lookup(
						(const char *)bpoint.buff_class);

	Class *p_clss  = ORP_Global_State::loader_env->class_table.lookup(p_c_str);

	if (p_clss == 0) {
		Loader_Exception ld_exc;
		p_clss = load_class(ORP_Global_State::loader_env, p_c_str, &ld_exc);
		if (p_clss == 0) {
			orp_cout << "error: can't find class" << bpoint.buff_class << endl;
			return;
		}
	}
	Method *p_meth = class_lookup_method(p_clss, sig);
	if (p_meth == 0) {
		orp_cout << "whoops..." << endl;
		return;
	}

	printf("%s.%s%s #%d",
		   p_meth->get_class()->name->bytes,
		   p_meth->get_name()->bytes,
		   p_meth->get_descriptor(),
		   bpoint.line_no);
	if (jvmdi_verbose)
		printf("  [eip=%x]", (uint32)bpoint.loc);
	printf("\n");
}

void show_breakpoints(enum breakpoint_level bp_level){
    if (bp_level == source_level)
        for (int zz = 0; zz < breakpoints_num; zz++) 
		    {
			    orp_cout << zz << ") " ;
                show_one_breakpoint(breakpoints[zz]);
    		}
    else if (bp_level== bytecode_level)
         for (int zz = 0; zz < bytecode_breakpoints_num; zz++) 
		    {
			    orp_cout << zz << ") " ;
                show_one_breakpoint(bytecode_breakpoints[zz]);
    		}
}

void remove_breakpoint(const char* index_str,breakpoint_level bp_level){
    if (bp_level==source_level){
        if (!strcmp(index_str,"all")){
	        breakpoints_num=0;
	        memset(breakpoints,0,sizeof(jvmdi_bp)*NBREAKPOINTS);
        } else {
	        int bp_no = atoi(index_str);
	        if (bp_no<0||bp_no>=breakpoints_num){
		        orp_cout<<"the bp doesn't exist"<<endl;
		        return;
	        }
	        breakpoints_num--;
	        memset( &breakpoints[bp_no], 0, sizeof(jvmdi_bp) );
	        for (int i=bp_no;i<breakpoints_num;i++){
		        memcpy(&breakpoints[i],&breakpoints[i+1],sizeof(jvmdi_bp));
	        }
	        memset( &breakpoints[breakpoints_num], 0, sizeof(jvmdi_bp) );
        }
    } else if (bp_level == bytecode_level){
        if (!strcmp(index_str,"all")){
	        bytecode_breakpoints_num=0;
	        memset(bytecode_breakpoints,0,sizeof(jvmdi_bp)*NBREAKPOINTS);
        } else {
	        int bp_no = atoi(index_str);
	        if (bp_no<0||bp_no>=bytecode_breakpoints_num){
		        orp_cout<<"the bp doesn't exist"<<endl;
		        return;
	        }
	        bytecode_breakpoints_num--;
	        memset( &bytecode_breakpoints[bp_no], 0, sizeof(jvmdi_bp) );
	        for (int i=bp_no;i<bytecode_breakpoints_num;i++){
		        memcpy(&bytecode_breakpoints[i],&bytecode_breakpoints[i+1],sizeof(jvmdi_bp));
	        }
	        memset( &bytecode_breakpoints[bytecode_breakpoints_num], 0, sizeof(jvmdi_bp) );
        }
    }


#ifdef ORP_NT
	int fd = _creat("c:\\temp\\jvmdi_dbg", _S_IREAD | _S_IWRITE  );

	int stat = _write( fd, breakpoints, ( sizeof(jvmdi_bp) * NBREAKPOINTS ) );
    stat = _write( fd, bytecode_breakpoints, ( sizeof(jvmdi_bp) * NBREAKPOINTS ) );
	stat = _close(fd);

#elif defined(ORP_POSIX)
	int fd = creat("/tmp/jvmdi_dbg", S_IREAD | S_IWRITE  );

	int stat = write( fd, breakpoints, ( sizeof(jvmdi_bp) * NBREAKPOINTS ) );
    stat = write( fd, bytecode_breakpoints, ( sizeof(jvmdi_bp) * NBREAKPOINTS ) );
	stat = close(fd);

#endif
}

bool set_nextb_breakpoint(Frame_Context fct,uint32 curr_bytecode_idx,bool into_callee){
    uint32 *p_eip = fct.p_eip;
    Method *p_meth = methods.find((void *)*p_eip)->get_method();
    Class *java_class = p_meth->get_class();

    uint32 bc_ip = curr_bytecode_idx;
    char *dis_bc(const Byte *bc_start, unsigned *bc_ip, char *buf, Method_Handle m);
    
    JIT_Flags jf; jf.insert_write_barriers = 1; jf.generate_debug_info = 0;
    jf.poll_gc = 0; jf.tracing_write_barriers = 0;

    uint32 bc_size = p_meth->get_byte_code_size();
    uint32 pre_bc_ip = bc_ip;
    while (bc_ip < bc_size)  {
        pre_bc_ip = bc_ip;
        dis_bc(p_meth->get_byte_code_addr(),(unsigned int *)&bc_ip,disasm_buffer,p_meth);
        // the first nextb bp should be the following bytecode,if it is not unconditional jmp statement.
        bytecode_single_step_points[0].start_location = (jlocation)bc_ip;
        uint32 code_offset =  o1_jit->get_break_point_offset(
                               o1_jit->global_compile_handle,
                               p_meth,
                               jf,
                               (unsigned)bytecode_single_step_points[0].start_location);

        bytecode_single_step_points[0].loc  = (jlocation)(code_offset + 
                                            (uint32)p_meth->get_code_addr());
        // since some bytecode instructions may not transform to native code,we set the breakpoint at 
        // the "real" next bytecode.
        if (bytecode_single_step_points[0].loc != (jlocation)*p_eip)
            break;
    }
    /*
    if (bc_ip >= bc_size) {
        orp_cout<<"       bytecode single step failed!"<<endl;
        memset(bytecode_single_step_points,0,sizeof(jvmdi_ss)*BYTECODE_SINGLE_STEP_PTS);
        return false;
    }
    */
    const Byte *bytecode_ip = p_meth->get_byte_code_addr()+pre_bc_ip;
    const unsigned char *first_bc = p_meth->get_byte_code_addr();
    const unsigned char *curr_bc = bytecode_ip;
    const unsigned char bytecode = *bytecode_ip++;
    switch (bytecode){
    
        // when step over function call,we should set breakpoits at all possible exception
        // hander.
        
        // invokevirtual
    case 0xb6:
        // invokespecial
    case 0xb7:
        // invokestactic
    case 0xb8:
        // invokeinterface
    case 0xb9:
        {
            if (!into_callee){          // nextb
                if (!set_exception_handler_bps(fct,true)){
                    orp_cout<<"     danger if exception happen!"<<endl;
                }
            } else {                    // stepb
                int index = (bytecode_ip[0]<<8) + bytecode_ip[1];
                Method *callee;
                if (bytecode==0xb6)
                    callee = class_resolve_virtual_method(java_class,index);
                else if (bytecode == 0xb7)
                    callee = class_resolve_special_method(java_class,index);
                else if (bytecode == 0xb8)
                    callee = class_resolve_static_method(java_class,index);
                else if (bytecode == 0xb9)
                    callee = class_resolve_interface_method(java_class,index);
                strcpy(bytecode_step_into_break_point.buff_class,
                    callee->get_class()->name->bytes);                
                strcpy(bytecode_step_into_break_point.buff_method,
                    callee->get_name()->bytes);
                strcpy(bytecode_step_into_break_point.buff_descriptor,
                    callee->get_descriptor());
                bytecode_step_into_break_point.line_no = BREAKPOINT_AT_BEGIN;     
                // here line number means bytecode index

                bytecode_step_into_break_point.method_handle = (void *)callee;

                if (callee->get_state() == Method::ST_Compiled ){
                
                    JIT_Flags jf; jf.insert_write_barriers = 1; jf.generate_debug_info = 0;
		            jf.poll_gc = 0; jf.tracing_write_barriers = 0;
		            
		            uint32 code_offset =  o1_jit->get_break_point_offset(
							               o1_jit->global_compile_handle,
							               callee,
							               jf,
            							   (unsigned)BREAKPOINT_AT_BEGIN);
                    bytecode_step_into_break_point.loc = (jlocation)code_offset;
                    bytecode_step_into_break_point.loc += (jlocation)callee->get_code_addr();
                            
                }
            }
            break;
        }
        
        // athrow
    case 0xbf:
        {
            if (!set_exception_handler_bps(fct,true)){
                    orp_cout<<"     danger if exception happen!"<<endl;
            }
            break;
        }
        // if {eq,ne,lt,ge,gt,le}
    case 0x99:
    case 0x9a:
    case 0x9b:
    case 0x9c:
    case 0x9d:
    case 0x9e:

        // if_icmp{eq,ne,lt,ge,gt,le}
    case 0x9f:
    case 0xa0:
    case 0xa1:
    case 0xa2:
    case 0xa3:
    case 0xa4:

        // if_acmp{eq,ne}
    case 0xa5:
    case 0xa6:

    
        // ifnull
    case 0xc6:

        // ifnonnull
    case 0xc7:

        {
            int branch_offset = (*(char *)bytecode_ip<<8)+bytecode_ip[1];
            unsigned target_bc_index = (curr_bc + branch_offset) - first_bc ;
            bytecode_single_step_points[1].start_location = (jlocation)target_bc_index;
            uint32 code_offset =  o1_jit->get_break_point_offset(
                                   o1_jit->global_compile_handle,
                                   p_meth,
                                   jf,
                                   (unsigned)bytecode_single_step_points[1].start_location);

            bytecode_single_step_points[1].loc  = (jlocation)(code_offset + 
                                               (uint32)p_meth->get_code_addr());
            break;
        }

        // jsr
    case 0xa8:
    
        // goto
    case 0xa7:
        {
            uint32 branch_offset = (*(char *)bytecode_ip<<8)+bytecode_ip[1];
            unsigned target_bc_index = (curr_bc + branch_offset) - first_bc ;
            bytecode_single_step_points[0].start_location = (jlocation)target_bc_index;
            uint32 code_offset =  o1_jit->get_break_point_offset(
                                   o1_jit->global_compile_handle,
                                   p_meth,
                                   jf,
                                   (unsigned)bytecode_single_step_points[0].start_location);

            bytecode_single_step_points[0].loc  = (jlocation)(code_offset + 
                                               (uint32)p_meth->get_code_addr());
            break;
        }

        // goto_w
    case 0xc8:
        
        // jsr_w
    case 0xc9:
        {
            uint32 branch_offset = (bytecode_ip[0]<<24)+(bytecode_ip[1]<<16)+
                                   (bytecode_ip[2]<<8) +bytecode_ip[3];
            unsigned target_bc_index = (curr_bc + branch_offset) - first_bc ;            
            bytecode_single_step_points[0].start_location = (jlocation)target_bc_index;
            uint32 code_offset =  o1_jit->get_break_point_offset(
                                   o1_jit->global_compile_handle,
                                   p_meth,
                                   jf,
                                   (unsigned)bytecode_single_step_points[0].start_location);

            bytecode_single_step_points[0].loc  = (jlocation)(code_offset + 
                                               (uint32)p_meth->get_code_addr());
            break;
        }

        // tableswitch
    case 0xaa:
        {
            // skip over padding bytes to align on 4 byte boundary
            bytecode_ip = (curr_bc+1) + ((4 - (curr_bc - first_bc + 1)) & 0x03);
            // offset default label
            int default_offset = ((bytecode_ip[0]<<24) + (bytecode_ip[1]<<16) + 
                (bytecode_ip[2]<<8) + bytecode_ip[3]);
            // low
            int low = ((bytecode_ip[4]<<24) + (bytecode_ip[5]<<16) + (bytecode_ip[6]<<8) + bytecode_ip[7]);
            // high
            int high = ((bytecode_ip[8]<<24) + (bytecode_ip[9]<<16) + (bytecode_ip[10]<<8) + bytecode_ip[11]);
            bytecode_ip += 12;
            int n_entries = high - low + 1;
            if (n_entries + 1 > BYTECODE_SINGLE_STEP_PTS ){
                orp_cout<<"     current debugger can't support "<<n_entries+1<<" entries in tableswitch"<<endl;
                memset(bytecode_single_step_points,0,sizeof(jvmdi_ss)*BYTECODE_SINGLE_STEP_PTS);
                return false;
            }

            unsigned target_bc_index = (curr_bc + default_offset) - first_bc ;            
            bytecode_single_step_points[0].start_location = (jlocation)target_bc_index;
            uint32 code_offset =  o1_jit->get_break_point_offset(
                                   o1_jit->global_compile_handle,
                                   p_meth,
                                   jf,
                                   (unsigned)bytecode_single_step_points[0].start_location);

            bytecode_single_step_points[0].loc  = (jlocation)(code_offset + 
                                               (uint32)p_meth->get_code_addr());

            for (int i=0;i<n_entries;i++){
                int offset = ((bytecode_ip[0]<<24) + (bytecode_ip[1]<<16) + (bytecode_ip[2]<<8) 
                                + bytecode_ip[3]);
                target_bc_index = (curr_bc + offset) - first_bc ;            
                bytecode_single_step_points[i+1].start_location = (jlocation)target_bc_index;
                uint32 code_offset =  o1_jit->get_break_point_offset(
                                       o1_jit->global_compile_handle,
                                       p_meth,
                                       jf,
                                       (unsigned)bytecode_single_step_points[i+1].start_location);

                bytecode_single_step_points[i+1].loc  = (jlocation)(code_offset + 
                                                   (uint32)p_meth->get_code_addr());

                bytecode_ip += 4;
            }
            break;
        }

        // lookupswitch
    case 0xab:
        {
            // skip over padding bytes to align on 4 byte boundary
            bytecode_ip = (curr_bc+1) + ((4 - (curr_bc - first_bc + 1)) & 0x03);
            // offset default label
            int default_offset = ((bytecode_ip[0]<<24) + (bytecode_ip[1]<<16) + 
                (bytecode_ip[2]<<8) + bytecode_ip[3]);
            // number of match-offset pairs in lookup table
            int npairs = ((bytecode_ip[4]<<24) + (bytecode_ip[5]<<16) + (bytecode_ip[6]<<8) + bytecode_ip[7]);
            
            bytecode_ip +=8;
            
            if (npairs + 1 > BYTECODE_SINGLE_STEP_PTS ){
                orp_cout<<"     current debugger can't support "<<npairs+1<<" entries in lookupswitch"<<endl;
                memset(bytecode_single_step_points,0,sizeof(jvmdi_ss)*BYTECODE_SINGLE_STEP_PTS);
                return false;
            }

            unsigned target_bc_index = (curr_bc + default_offset) - first_bc ;            
            bytecode_single_step_points[0].start_location = (jlocation)target_bc_index;
            uint32 code_offset =  o1_jit->get_break_point_offset(
                                   o1_jit->global_compile_handle,
                                   p_meth,
                                   jf,
                                   (unsigned)bytecode_single_step_points[0].start_location);

            bytecode_single_step_points[0].loc  = (jlocation)(code_offset + 
                                               (uint32)p_meth->get_code_addr());
            
            for (int i = 0; i < npairs; i++) {
                int match = ((bytecode_ip[0]<<24) + (bytecode_ip[1]<<16) + (bytecode_ip[2]<<8) 
                            + bytecode_ip[3]);
                // get the offset
                int offset = ((bytecode_ip[4]<<24) + (bytecode_ip[5]<<16) + (bytecode_ip[6]<<8)
                            + bytecode_ip[7]);
                
                target_bc_index = (curr_bc + offset) - first_bc ;            
                bytecode_single_step_points[i+1].start_location = (jlocation)target_bc_index;
                uint32 code_offset =  o1_jit->get_break_point_offset(
                                       o1_jit->global_compile_handle,
                                       p_meth,
                                       jf,
                                       (unsigned)bytecode_single_step_points[i+1].start_location);

                bytecode_single_step_points[i+1].loc  = (jlocation)(code_offset + 
                                                   (uint32)p_meth->get_code_addr());
                bytecode_ip += 8;
            }

            break;

        }

        // ret 
        // we will set break point at every bytecode instruction which after jsr or jsr_w;
    case 0xa9:
        {
            uint32 search_pos = 0;
            int single_bp_cursor = 0;
            while (search_pos < bc_size){
                int pre_search_pos = search_pos;
                dis_bc(p_meth->get_byte_code_addr(),(unsigned int *)&search_pos,disasm_buffer,p_meth);
                const Byte *bytecode_pos = p_meth->get_byte_code_addr() + pre_search_pos;
                const unsigned char search_bytecode = *bytecode_pos;
                if (search_bytecode == 0xa8 || search_bytecode == 0xc9){
                    
                    if (single_bp_cursor >= BYTECODE_SINGLE_STEP_PTS){
                        orp_cout<<"     current debugger can't support single step on ret in this method"<<endl;
                        memset(bytecode_single_step_points,0,sizeof(jvmdi_ss)*BYTECODE_SINGLE_STEP_PTS);
                        return false;                    
                    }
                    bytecode_single_step_points[single_bp_cursor].start_location = (jlocation)search_pos;
                    uint32 loc_offset =  o1_jit->get_break_point_offset(
                                           o1_jit->global_compile_handle,
                                           p_meth,
                                           jf,
                                           (unsigned)bytecode_single_step_points[single_bp_cursor].start_location);

                    bytecode_single_step_points[single_bp_cursor].loc  = (jlocation)(loc_offset + 
                                                        (uint32)p_meth->get_code_addr());
                    single_bp_cursor++;
                                                
                }
            }
            break;
        }
        //ireturn
    case 0xac:
        // areturn
    case 0xb0:
        // freturn
    case 0xae:
        // lreturn
    case 0xad:
        // dreturn
    case 0xaf:
        // return
    case 0xb1:
       
        {
            memset(bytecode_single_step_points,0,sizeof(jvmdi_ss)*BYTECODE_SINGLE_STEP_PTS);
            Frame_Context loc_fct;
            orp_copy_frame_context(&loc_fct,&fct);
            set_breakpoint_for_stepout(&loc_fct);
            break;
        }
    }
    return true;
}

bool set_exception_handler_bps(Frame_Context &curr_frame,bool is_first){
    void *eip_array[1024];
    Frame_Context local_context;
    orp_copy_frame_context(&local_context, &curr_frame);
    unsigned stack_depth = orp_get_stack_depth(&local_context,0,eip_array,1024,is_first);
    if (stack_depth > 1024){
        return false;
    }
    int expt_bp_index =0;
    for (int i=0;i<(signed)stack_depth;i++){
        JIT_Specific_Info *jit_info = methods.find(eip_array[i]);
        unsigned num_exc = jit_info->get_num_target_exception_handlers();
        for (int j=0;j<(signed)num_exc;j++){
            if (expt_bp_index>=EXCEPTION_HANDLER_BREAK_PTS){
                memset(exception_handler_break_points,0,
                        sizeof(jvmdi_ss)*EXCEPTION_HANDLER_BREAK_PTS);
                return false;
            }
            Target_Exception_Handler_Ptr handler =
                jit_info->get_target_exception_handler_info(j);
            if(!handler) {
                continue;
            }
            if(handler->is_in_range(eip_array[i], is_first)){
                exception_handler_break_points[expt_bp_index].loc = 
                    (jlocation)handler->get_handler_ip();
            }
            expt_bp_index++;
        }
        is_first = false;
    }
    return true;
}

void set_breakpoint_for_stepout(Frame_Context *fct){
    
    unwind_it(fct,1);
    single_step_points[0].loc = *(fct->p_eip);
}

bool set_breakpoint_for_next(){
    Frame_Context fc;
    memset(&fc, 0, sizeof(Frame_Context));

    fc.p_eip = p_TLS_orpthread->gc_frame_context.p_eip;
    fc.p_ebp = p_TLS_orpthread->gc_frame_context.p_ebp;
    fc.p_ebx = p_TLS_orpthread->gc_frame_context.p_ebx;
    fc.p_esi = p_TLS_orpthread->gc_frame_context.p_esi;
    fc.p_edi = p_TLS_orpthread->gc_frame_context.p_edi;
    fc.esp   = p_TLS_orpthread->gc_frame_context.esp;

    if (fc.p_eip == 0) 
        return false;

    Method *p_meth = 0;
    if(orp_identify_eip((void *)*(fc.p_eip)) == ORP_TYPE_JAVA) {
        p_meth = methods.find((void *)*(fc.p_eip))->get_method();
    }

    assert(p_meth->get_state() == Method::ST_Compiled );

    int n_entry = method_get_line_number_table_size(p_meth);
    if (n_entry <= 1){
        orp_cout<< "no source info"<<endl;
        return false;
    }

    memset(single_step_points, 0, (sizeof(jvmdi_ss) * SINGLE_STEP_PTS) );

    for (int xx = 0; xx < n_entry; xx++) {

        if (xx >= SINGLE_STEP_PTS) {
            orp_cout<<" too many(>1025) lines in one file"<<endl;
            return false;
        }
        method_get_line_number( p_meth,
                                xx,
                                (unsigned *)&(single_step_points[xx].start_location),
                                (unsigned *)&(single_step_points[xx].line_number) );

        JIT_Flags jf; jf.insert_write_barriers = 1; jf.generate_debug_info = 0;
        jf.poll_gc = 0; jf.tracing_write_barriers = 0;

        uint32 code_offset =  o1_jit->get_break_point_offset(
                               o1_jit->global_compile_handle,
                               p_meth,
                               jf,
                               (unsigned)single_step_points[xx].start_location);

        single_step_points[xx].loc  = (jlocation)(code_offset + 
                                            (uint32)p_meth->get_code_addr());
    }

    enter_the_debugger = false;
    return true;
}

bool set_breakpoint_for_step(uint32 curr_line_index,uint32 curr_bytecode_index,Method *curr_method){
    Frame_Context fc;
    memset(&fc, 0, sizeof(Frame_Context));

    fc.p_eip = p_TLS_orpthread->gc_frame_context.p_eip;
    fc.p_ebp = p_TLS_orpthread->gc_frame_context.p_ebp;
    fc.p_ebx = p_TLS_orpthread->gc_frame_context.p_ebx;
    fc.p_esi = p_TLS_orpthread->gc_frame_context.p_esi;
    fc.p_edi = p_TLS_orpthread->gc_frame_context.p_edi;
    fc.esp   = p_TLS_orpthread->gc_frame_context.esp;

    uint32 next_line_bc_idx = curr_method->get_byte_code_size();
    
    int n_entry = method_get_line_number_table_size(curr_method);
    for (int i =0;i<n_entry;i++){
        jvmdi_ss one_line_info;
        memset(&one_line_info,0,sizeof(jvmdi_ss));
        method_get_line_number(curr_method,i,
                                (unsigned *)&(one_line_info.start_location),
                                (unsigned *)&(one_line_info.line_number));
        if ((unsigned)one_line_info.line_number > curr_line_index)
            if (next_line_bc_idx > (unsigned)one_line_info.start_location)
                next_line_bc_idx = (unsigned)one_line_info.start_location;
    }
    
    const unsigned char *bc_cursor = curr_method->get_byte_code_addr() + curr_bytecode_index;
    const unsigned char *next_line_bc = curr_method->get_byte_code_addr() + next_line_bc_idx;
    while (bc_cursor < next_line_bc){
        const Byte bytecode = (const Byte)*bc_cursor;
        switch (bytecode){
        case 0xb6:
        case 0xb7:
        case 0xb8:
        case 0xb9:
            {
                uint32 bytecode_idx = (uint32)(bc_cursor - curr_method->get_byte_code_addr());
                return set_nextb_breakpoint(fc,bytecode_idx,true);    // into callee
            }
        }
        char *dis_bc(const Byte *bc_start, unsigned *bc_ip, char *buf, Method_Handle m);
        dis_bc((const Byte *)(curr_method->get_byte_code_addr()),(unsigned *)&bc_cursor,disasm_buffer,curr_method);
    }
    
    // come here means,this line is not function call

    return set_breakpoint_for_next();
}