// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/base/exceptions_ia32.cpp,v 1.5 2001/12/07 00:16:00 xli18 Exp $
//


#include "platform.h"
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <float.h>

#include "orp_types.h"
#include "jit_runtime_support.h"
#include "Class.h"
#include "environment.h"
#include "method_lookup.h"
#include "stack_manipulation.h"
#include "object_layout.h"
#include "orp_utils.h"
#include "orp_synch.h"
#include "orp_threads.h"
#include "jit_intf.h"
#include "jit_intf_cpp.h"
#include "compile.h"
#include "ini.h"
#include "orp_stats.h"

#include "exceptions.h"

#include "nogc.h"
#include "../x86/x86.h"

#ifdef ORP_VTUNE_SUPPORT
//M: 
#include "orp_vtune.h"
#endif

#ifdef _DEBUG
#include "jvmdi_clean.h"
#endif

#ifdef ORP_POSIX
#include "platform2.h"
#endif



////////////////////////////////////////////////////////////////////////////
// begin corp exception throwing and catching functions

               
#if 0  // keep this code around for debugging purposes
void  __declspec(naked) asm__transfer_control(
                                              
    uint32 eip_var,     // at esp + 4
    uint32 ebx_var,     // at esp + 8
    uint32 edi_var,     // at esp + c
    uint32 esi_var,     // at esp + 10

    uint32 esp_var,     // at esp + 14
    uint32 ebp_var,     // at esp + 18
    
    uint32 eax_arg)     // at esp + 1c
{
    __asm {

        mov  ebx, dword ptr [esp + 0x08]
        mov  edi, dword ptr [esp + 0x0c]
        mov  esi, dword ptr [esp + 0x10]
        mov  eax, dword ptr [esp + 0x1c]
        mov  edx, dword ptr [esp + 0x04] // gets the eip to jmp to

        mov  ebp, dword ptr [esp + 0x18]

        // Esp must be the last register to be modified.
        mov  ecx, dword ptr [esp + 0x14]
        mov  esp, ecx
        jmp  edx
    }
} //transfer_control

#endif  // if 0

void * getaddress__transfer_control()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;

    //
    // ************* LOW LEVEL DEPENDENCY! ***************
    // This code sequence must be atomic.  The "atomicity" effect is achieved by
    // changing the esp at the very end of the sequence.
    //

    ss = mov(ss, &ebx_opnd, &M_Base_Opnd(esp_reg, +0x08) );
    ss = mov(ss, &edi_opnd, &M_Base_Opnd(esp_reg, +0x0c) );
    ss = mov(ss, &esi_opnd, &M_Base_Opnd(esp_reg, +0x10) );
    ss = mov(ss, &eax_opnd, &M_Base_Opnd(esp_reg, +0x1c) );
    ss = mov(ss, &edx_opnd, &M_Base_Opnd(esp_reg, +0x04) );

    ss = mov(ss, &ebp_opnd, &M_Base_Opnd(esp_reg, +0x18) );
 
    ss = mov(ss, &ecx_opnd, &M_Base_Opnd(esp_reg, +0x14) );
    ss = mov(ss, &esp_opnd, &ecx_opnd );
    ss = jump(ss, &edx_opnd);

    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M: 
    vtune_notify_stub_load_finished("getaddress__transfer_control",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__transfer_control


void transfer_control(Frame_Context *context, uint32 eax_arg) 
{
    uint32 eip_var = *(context->p_eip);
    uint32 ebx_var = *(context->p_ebx);
    uint32 edi_var = *(context->p_edi);
    uint32 esi_var = *(context->p_esi);

    struct {
        uint32 esp;
        uint32 ebp;
    } regs, *p_regs;
    regs.esp = context->esp;
    regs.ebp = *(context->p_ebp);
    p_regs = &regs;



    void *(*gatc)(uint32 eipv, uint32 ebxv, uint32 ediv, uint32 esiv,
                         
                         uint32 espv, uint32 ebpv,
                         
                         uint32 eaxv);

    gatc = ( void * ( *)(uint32 eipv, uint32 ebxv, uint32 ediv, uint32 esiv,
                         
                         uint32 espv, uint32 ebpv,
                         
                         uint32 eaxv) )getaddress__transfer_control();

    (gatc)(eip_var, ebx_var, edi_var, esi_var,
           regs.esp, regs.ebp,       
           eax_arg);

    //asm__transfer_control( 
        
        //eip_var,
        //ebx_var,
        //edi_var,
        //esi_var,

        //regs.esp,
        //regs.ebp,

        //eax_arg);

} //transfer_control


// end corp exception throwing and catching functions
////////////////////////////////////////////////////////////////////////////




////////////////////////////////////////////////////////////////////////////
// begin main entry points for throwing exceptions


// This function never returns 
#pragma optimize( "g", off )
void __stdcall orp_athrow(Boolean is_first,
                          volatile uint32 edi_arg,
                          volatile uint32 esi_arg,
                          volatile uint32 ebx_arg,
                          volatile uint32 ebp_arg,
                          volatile uint32 esp_arg,
                          volatile uint32 eip_arg,
                          volatile Java_java_lang_Object *obj)
{
    assert( !orp_is_gc_enabled(p_TLS_orpthread) );

    Frame_Context fc;
    fc.p_edi = (uint32 *)&edi_arg;
    fc.p_esi = (uint32 *)&esi_arg;
    fc.p_ebx = (uint32 *)&ebx_arg;
    fc.p_ebp = (uint32 *)&ebp_arg;
    fc.p_eip = (uint32 *)&eip_arg;
    fc.esp   = esp_arg + 4;
    fc.ljf   = (uint32)get_orp_last_java_frame();
    orp_throw(&fc, (volatile Java_java_lang_Object **)&obj, is_first);
    transfer_control(&fc, (uint32)obj);
    assert(0);
} //orp_athrow

#pragma optimize( "", on )


void * getaddress__orp_athrow_naked()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;

    ss = alu(ss, sub_opc, &M_Base_Opnd(esp_reg, +0), &Imm_Opnd(5) );
    ss = push(ss, &esp_opnd);
    ss = push(ss, &ebp_opnd);
    ss = push(ss, &ebx_opnd);
    ss = push(ss, &esi_opnd);
    ss = push(ss, &edi_opnd);
    ss = push(ss, &Imm_Opnd(1));
    ss = call(ss, (char *)orp_athrow);
    
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M: 
    vtune_notify_stub_load_finished("getaddress__orp_athrow_naked",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__orp_athrow_naked


void orp_athrow_lazy(Boolean is_first,
                     volatile uint32 edi_arg,
                     volatile uint32 esi_arg,
                     volatile uint32 ebx_arg,
                     volatile uint32 ebp_arg,
                     volatile uint32 esp_arg,
                     volatile uint32 eip_arg,
                     Method *method,
                     volatile uint32 first_arg)
{
    assert( !orp_is_gc_enabled(p_TLS_orpthread) );

#if 0
    printf("*** Throwing lazy exception: %s.%s%s\n",
           method->get_class()->name->bytes,
           method->get_name()->bytes,
           method->get_descriptor());
#endif

    volatile uint8 *args = (volatile uint8 *)&first_arg;
    args += method->get_num_arg_bytes() - 4;

    Frame_Context fc;
    fc.p_edi = (uint32 *)&edi_arg;
    fc.p_esi = (uint32 *)&esi_arg;
    fc.p_ebx = (uint32 *)&ebx_arg;
    fc.p_ebp = (uint32 *)&ebp_arg;
    fc.p_eip = (uint32 *)&eip_arg;

    // Should the correction take the arguments to <init> into account?
    fc.esp   = esp_arg + 4;

    fc.ljf   = (uint32)get_orp_last_java_frame();


    volatile Class *clss = *(volatile Class **)args;

    orp_throw(&fc,
              (volatile Java_java_lang_Object **)&clss,
              is_first,
              method,
              (uint8 *)(args - 4));
    transfer_control(&fc, (uint32)clss);
    assert(0);
} //orp_athrow_lazy


void * getaddress__orp_athrow_lazy_naked()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;

    ss = alu(ss, sub_opc, &M_Base_Opnd(esp_reg, +0), &Imm_Opnd(5) );
    ss = push(ss, &esp_opnd);
    ss = push(ss, &ebp_opnd);
    ss = push(ss, &ebx_opnd);
    ss = push(ss, &esi_opnd);
    ss = push(ss, &edi_opnd);
    ss = push(ss, &Imm_Opnd(1));
    ss = call(ss, (char *)orp_athrow_lazy);
    
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M:
    vtune_notify_stub_load_finished("getaddress__orp_athrow_lazy_naked",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__orp_athrow_lazy_naked

void  __stdcall orp_null_ptr_throw(Frame_Context *context,
                                   volatile Java_java_lang_Object **obj)
{
    orp_throw(context, obj, TRUE);
} //orp_null_ptr_throw


// end main entry points for throwing exceptions
////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////
// begin exception throwing from the jitted code


#define EXC_CODE_NULLPOINTER            1
#define EXC_CODE_ARRAYINDEXOUTOFBOUNDS  2
#define EXC_CODE_ARRAYSTORE             3



//
// TURN OFF OPTIMIZATIONS!
// VC++ optimizer "proves" that some formal parameters are dead and overwrites them.
// We don't want that!!!
#pragma optimize( "g", off )
//
// This function never returns.
//
// We use lazy exception object creation here.
//
static void __stdcall orp_throw_orp_exception(volatile uint32 exc_code,
                                              volatile uint32 edi_arg,
                                              volatile uint32 esi_arg,
                                              volatile uint32 ebx_arg,
                                              volatile uint32 ebp_arg,
                                              volatile uint32 eip_arg)
{
    assert( !orp_is_gc_enabled(p_TLS_orpthread) );

    Global_Env *env = ORP_Global_State::loader_env;
    Class *exc = 0;
    switch(exc_code) {
    case EXC_CODE_NULLPOINTER:
        exc = env->java_lang_NullPointerException_Class;
        break;
    case EXC_CODE_ARRAYINDEXOUTOFBOUNDS:
#ifdef ORP_STATS
        orp_stats_total.num_array_index_throw++;
#endif
        exc = env->java_lang_ArrayIndexOutOfBoundsException_Class;
        break;
    case EXC_CODE_ARRAYSTORE:
        exc = env->java_lang_ArrayStoreException_Class;
        break;
    default:
        assert(0);
        break;
    }

    assert(exc);

    orp_athrow(TRUE,
               edi_arg,
               esi_arg,
               ebx_arg,
               ebp_arg,
               (uint32)&eip_arg,
               eip_arg,
               (Java_java_lang_Object *)exc);

    assert(0);
} //orp_throw_orp_exception


// Is it needed?
#pragma optimize( "", on )


void * getaddress__orp_exception_trampoline()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;

    ss = alu(ss, sub_opc, &M_Base_Opnd(esp_reg, +0), &Imm_Opnd(5) );
    ss = push(ss, &ebp_opnd);
    ss = push(ss, &ebx_opnd);
    ss = push(ss, &esi_opnd);
    ss = push(ss, &edi_opnd);
    ss = push(ss, &ecx_opnd);
    ss = call(ss, (char *)orp_throw_orp_exception);
    
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M:
    vtune_notify_stub_load_finished("getaddress__orp_exception_trampoline",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__orp_exception_trampoline


void * getaddress__orp_exception_nullpointer_naked()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;

    ss = mov(ss, &ecx_opnd, &Imm_Opnd(EXC_CODE_NULLPOINTER) );
    ss = jump(ss, (char *)getaddress__orp_exception_trampoline() );
    
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M: 
    vtune_notify_stub_load_finished("getaddress__orp_exception_nullpointer_naked",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__orp_exception_nullpointer_naked



void * getaddress__orp_exception_arrayindexoutofbounds_naked()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;

    ss = mov(ss, &ecx_opnd, &Imm_Opnd(EXC_CODE_ARRAYINDEXOUTOFBOUNDS) );
    ss = jump(ss, (char *)getaddress__orp_exception_trampoline() );
    
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M:
    vtune_notify_stub_load_finished("getaddress__orp_exception_arrayindexoutofbounds_naked",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__orp_exception_arrayindexoutofbounds_naked


void * getaddress__orp_exception_arraystore_naked()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;

    ss = mov(ss, &ecx_opnd, &Imm_Opnd(EXC_CODE_ARRAYSTORE) );
    ss = jump(ss, (char *)getaddress__orp_exception_trampoline() );
    
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M: 
    vtune_notify_stub_load_finished("getaddress__orp_exception_arraystore_naked",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__orp_exception_arraystore_naked

// end exception throwing from the jitted code
////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
// begin throwing exception from native code

//
// WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!
//
// This method only works when involved from native code that was entered
// using a stub which saved away some info which can be used to unwind the stack
// to the last Java frame.
//


void throw_java_exception_from_native(void *exc)
{
    Frame_Context context;
    // Force an unwind from a native in the first iteration
    context.ljf   = (uint32)get_orp_last_java_frame();
    context.eip   = 0;
    context.p_eip = &(context.eip);
    Boolean result = unwind_to_next_java_frame(&context, FALSE);

    if(result) {
        orp_athrow(FALSE,
                   *context.p_edi,
                   *context.p_esi,
                   *context.p_ebx,
                   *context.p_ebp,
                   context.esp - 4,
                   *context.p_eip,
                   (Java_java_lang_Object *)exc);
    } else {
        print_uncaught_exception_message(stderr, (Java_java_lang_Throwable *)exc);

        orp_exit(1);        
    }

    assert(0);
} //throw_java_exception_from_native



// end throwing exception from native code
////////////////////////////////////////////////////////////////////////////
