/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.rte.comm;

/**
 * describes the "layout" of a packet.
 *
 * A packet consists of multiple parts:
 * <UL>
 * <LI>the RTE header
 * <LI>the request
 * <LI>the reply
 * </UL>
 * This interfaced is used to describe the maximum sizes
 * of these parts
 */
interface PacketLayout {
    /**
     * the maximal size of a command the client can send to the server.
     * @return int
     */
    int maxCmdDataLength ();
    /**
     * the maximal size of request + reply
     * @return int
     */
    int maxDataLength ();
    /**
     * the maximal size of the whole packet (including RTE data)
     * @return int
     */
    int maxSegmentSize ();
    /**
     * the minimal size of a reply
     *
     * this amount is reserved when calculating maxCmdDataLength.
     * @return int
     */
    int minReplySize ();
    /**
     *
     * @return int
     */
    int packetSize ();
    /**
     *
     */
    public void dumpOn (java.io.PrintStream out, String comment);
}
