/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc;

import java.sql.*;
import com.sap.dbtech.jdbc.exceptions.*;
/**
 *
 */
abstract class ConnectionItem {
    protected ConnectionSapDB       connection;
    protected SQLWarning            warningList;
    /**
     *
     * @param connection com.sap.dbtech.jdbc.ConnectionSapDBTech
     */
    public ConnectionItem(ConnectionSapDB connection) {
        this.connection = connection;
        this.warningList = null;
    }
    /**
     *
     * @param warning java.sql.SQLWarning
     */
    final public void addWarning (SQLWarning warning) {
        if (this.warningList == null) {
            this.warningList = warning;
        }
        else {
            this.warningList.setNextWarning (warning);
        }
    }
    /**
     *
     * @exception com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDBTech The exception description.
     */
    final protected void assertOpen () throws SQLExceptionSapDB {
        if (this.connection == null
            || this.connection.session == null) {
            throw new ObjectIsClosedException (this);
        }
    }
    /**
     *
     * @exception java.sql.SQLException The exception description.
     */
    final public void clearWarnings() throws SQLException {
        this.warningList = null;
    }
    /**
     *
     */
    final public void closeDummy () throws SQLException {}
    /**
     *
     * @return java.sql.Connection
     */
    final public Connection getConnection ()
        throws SQLException
    {
        return this.connection;
    }
    /**
     *
     * @return java.sql.Connection
     */
    final public ConnectionSapDB getConnectionSapDB () {
        return this.connection;
    }
    /**
     *
     * @return java.sql.SQLWarning
     * @exception java.sql.SQLException The exception description.
     */
    final public SQLWarning getWarnings() throws SQLException {
        return warningList;
    }

    /**
     * Throws an exception to indicate that a feature is unsupported by the
     * database.
     * @param msg The complete message, already localised.
     * @exception com.sap.dbtech.jdbc.exceptions.JDBCDriverException always.
     */
    final protected void throwNotSupported (String msg)
        throws JDBCDriverException
    {
        throw new JDBCDriverException (msg, this);
    }
}
