#!/bin/sh
# /etc/init.d/daemontools : start or stop daemontools
# written by Adam McKenna <adam@debian.org>

case "$1" in
    start)
	echo -n "Starting daemontools: "
	if [ ! `pidof /usr/bin/svscan` ]; then
		echo -n "svscan "
		cd /var/lib/svscan
		env - PATH="$PATH" svscan 2>&1 | setuidgid daemon multilog t /var/log/svscan &
		echo "."
	else
		echo "already running."
	fi
        ;;
    stop)
	echo -n "Stopping daemontools: "
	if [ `pidof /usr/bin/svscan` ]; then
		echo -n "svscan"
		while [ `pidof /usr/bin/svscan` ]; do
			kill `pidof /usr/bin/svscan`
			echo -n "."
		done
	fi
	echo -n " services"
	for i in `ls -d /var/lib/svscan/*`; do
		svc -dx $i
		echo -n "."
	done
	echo -n " logging "
	for i in `ls -d /var/lib/svscan/*/log`; do
		svc -dx $i
		echo -n "."
	done
	echo ""
	;;
    restart|force-reload)
        $0 stop
        $0 start
        ;;
    *)
        echo 'Usage: /etc/init.d/svscan {start|stop|restart|force-reload}'
        exit 1
esac

exit 0
