/*
 * File:          sidlx_rmi_SimHandle_Impl.c
 * Symbol:        sidlx.rmi.SimHandle-v0.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for sidlx.rmi.SimHandle
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sidlx.rmi.SimHandle" (version 0.1)
 * 
 * implementation of InstanceHandle using the Simocol (simple-protocol), 
 * 	contains all the serialization code
 */

#include "sidlx_rmi_SimHandle_Impl.h"

#line 27 "../../../babel/runtime/sidlx/sidlx_rmi_SimHandle_Impl.c"
/* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimHandle._includes) */
#include "sidl_String.h"

/* DO-NOT-DELETE splicer.end(sidlx.rmi.SimHandle._includes) */
#line 32 "sidlx_rmi_SimHandle_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimHandle__load"

void
impl_sidlx_rmi_SimHandle__load(
  void)
{
#line 43 "../../../babel/runtime/sidlx/sidlx_rmi_SimHandle_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimHandle._load) */
  /* insert implementation here: sidlx.rmi.SimHandle._load (static class initializer method) */
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimHandle._load) */
#line 49 "sidlx_rmi_SimHandle_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimHandle__ctor"

void
impl_sidlx_rmi_SimHandle__ctor(
  /* in */ sidlx_rmi_SimHandle self)
{
#line 58 "../../../babel/runtime/sidlx/sidlx_rmi_SimHandle_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimHandle._ctor) */
  /* insert implementation here: sidlx.rmi.SimHandle._ctor (constructor method) */
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimHandle._ctor) */
#line 66 "sidlx_rmi_SimHandle_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimHandle__dtor"

void
impl_sidlx_rmi_SimHandle__dtor(
  /* in */ sidlx_rmi_SimHandle self)
{
#line 74 "../../../babel/runtime/sidlx/sidlx_rmi_SimHandle_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimHandle._dtor) */
  
  struct sidlx_rmi_SimHandle__data *dptr =
    sidlx_rmi_SimHandle__get_data(self);
  if(dptr) {
    sidl_String_free(dptr->d_protocol);
    sidl_String_free(dptr->d_server);
    sidl_String_free(dptr->d_typeName);
    sidl_String_free(dptr->d_objectID);
    sidlx_rmi_SimHandle__set_data(self, NULL);
  }
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimHandle._dtor) */
#line 93 "sidlx_rmi_SimHandle_Impl.c"
}

/*
 * initialize a connection (intended for use by the ProtocolFactory) 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimHandle_initCreate"

sidl_bool
impl_sidlx_rmi_SimHandle_initCreate(
  /* in */ sidlx_rmi_SimHandle self,
  /* in */ const char* protocol,
  /* in */ const char* server,
  /* in */ int32_t port,
  /* in */ const char* typeName,
  /* out */ sidl_BaseInterface *_ex)
{
#line 106 "../../../babel/runtime/sidlx/sidlx_rmi_SimHandle_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimHandle.initCreate) */
  struct sidlx_rmi_SimHandle__data *dptr =
    sidlx_rmi_SimHandle__get_data(self);
  sidlx_rmi_ClientSocket connSock = NULL;
  sidlx_rmi_Socket locSock = NULL;
  sidlx_rmi_Simsponse resp = NULL;
  int len, lower, upper;
  int32_t clsLen;
  char* str = NULL;
  struct sidl_char__array * carray= NULL;
  if (!dptr) {
    dptr = malloc(sizeof(struct sidlx_rmi_SimHandle__data));
  }
  dptr->d_protocol = sidl_String_strdup(protocol);
  dptr->d_server = sidl_String_strdup(server);
  dptr->d_port = port;
  dptr->d_typeName = sidl_String_strdup(typeName);
  dptr->d_objectID = NULL;
  /*dptr->d_sock = NULL;*/
  sidlx_rmi_SimHandle__set_data(self, dptr);

  /*
   * Here where we make a connection to the ORB
   */
  connSock = sidlx_rmi_ClientSocket__create();
  sidlx_rmi_ClientSocket_init(connSock, sidl_String_strdup(server), port,_ex);SIDL_CHECK(*_ex);
  locSock = sidlx_rmi_Socket__cast(connSock);
  /*dptr->d_sock = sidlx_rmi_Socket__cast(connSock);*/
  
  /*
   * Connected to orb, create typename
   */
  lower = 0;
  upper = 11+sidl_String_strlen(typeName); /*1 for the NULL char.*/
  carray = sidl_char__array_createRow(1, &lower, &upper);
  str = sidl_char__array_first(carray);
  sidl_String_strcpy(str, "CREATE:");
  clsLen = sidl_String_strlen(typeName);  /* serialize the typename as a
                                             string. */
  clsLen = htonl(clsLen);
  memmove(str+7, (char*)(&clsLen),4);
  sidl_String_strcpy(str+11, typeName);

  sidlx_rmi_Socket_writestring(locSock,upper+1,carray, _ex); SIDL_CHECK(*_ex);

  resp = sidlx_rmi_Simsponse__create();
  sidlx_rmi_Simsponse_init(resp, "CREATE", sidl_String_strdup(typeName), NULL, locSock, _ex);
  SIDL_CHECK(*_ex);
  dptr->d_objectID = sidlx_rmi_Simsponse_getObjectID(resp, _ex); SIDL_CHECK(*_ex);
  /*sidlx_rmi_Simsponse_unpackString(resp, "return", &(dptr->d_objectid), _ex);SIDL_CHECK(*_ex);*/

  sidl_char__array_deleteRef(carray);
  sidlx_rmi_Simsponse_deleteRef(resp);
  sidlx_rmi_ClientSocket_deleteRef(connSock);

 EXIT:
  /*TODO: CLEAN UP DANGLING POINTERS AND COME UP WITH A BETTER EXCEPTION HIERATCHY*/
  return 0; /*false*/

  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimHandle.initCreate) */
#line 173 "sidlx_rmi_SimHandle_Impl.c"
}

/*
 * initialize a connection (intended for use by the ProtocolFactory) 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimHandle_initConnect"

sidl_bool
impl_sidlx_rmi_SimHandle_initConnect(
  /* in */ sidlx_rmi_SimHandle self,
  /* in */ const char* protocol,
  /* in */ const char* server,
  /* in */ int32_t port,
  /* in */ const char* typeName,
  /* in */ const char* objectID,
  /* out */ sidl_BaseInterface *_ex)
{
#line 186 "../../../babel/runtime/sidlx/sidlx_rmi_SimHandle_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimHandle.initConnect) */
  struct sidlx_rmi_SimHandle__data *dptr =
    sidlx_rmi_SimHandle__get_data(self);
  sidlx_rmi_ClientSocket connSock = NULL;
  sidlx_rmi_Socket locSock = NULL;
  sidlx_rmi_Simsponse resp = NULL;
  int len, lower, upper;
  int32_t clsLen, objLen;
  char* str = NULL;
  struct sidl_char__array * carray= NULL;
  if (!dptr) {
    dptr = malloc(sizeof(struct sidlx_rmi_SimHandle__data));
  }
  dptr->d_protocol = sidl_String_strdup(protocol);
  dptr->d_server = sidl_String_strdup(server);
  dptr->d_port = port;
  dptr->d_typeName = sidl_String_strdup(typeName);
  dptr->d_objectID = sidl_String_strdup(objectID);
  sidlx_rmi_SimHandle__set_data(self, dptr);

  /*
   * Here where we make a connection to the ORB
   */
  connSock = sidlx_rmi_ClientSocket__create();
  sidlx_rmi_ClientSocket_init(connSock, sidl_String_strdup(server), port,_ex);SIDL_CHECK(*_ex);
  locSock = sidlx_rmi_Socket__cast(connSock);
  
  /*
   * Connected to orb, create typename
   */
  lower = 0;
  upper = 8+4+sidl_String_strlen(objectID)+4+sidl_String_strlen(typeName); 
  /*len+CONNECT:+objid+:+className+'\0'*/

  carray = sidl_char__array_createRow(1, &lower, &upper);
  str = sidl_char__array_first(carray);
  sidl_String_strcpy(str, "CONNECT:");
  str += 8;

  objLen = sidl_String_strlen(objectID);  /* serialize the objectID as a
                                             string. */
  objLen = htonl(objLen);
  memmove(str, (char*)(&objLen),4);
  str += 4;

  sidl_String_strcpy(str, objectID);
  str += objLen;

  clsLen = sidl_String_strlen(typeName);  /* serialize the objectID as a
                                             string. */
  clsLen = htonl(clsLen);
  memmove(str, (char*)(&clsLen),4);
  str += 4;

  sidl_String_strcpy(str, typeName);
  str += clsLen;

  sidlx_rmi_Socket_writestring(locSock,upper+1,carray, _ex); SIDL_CHECK(*_ex);

  resp = sidlx_rmi_Simsponse__create();
  sidlx_rmi_Simsponse_init(resp, "CONNECT", sidl_String_strdup(typeName), NULL, locSock, _ex);
  SIDL_CHECK(*_ex);
  /* If no execption was thrown then the CONNECT was successful, and we're done*/

  sidl_char__array_deleteRef(carray);
  sidlx_rmi_Simsponse_deleteRef(resp);
  sidlx_rmi_ClientSocket_deleteRef(connSock);

 EXIT:
  /*TODO: CLEAN UP DANGLING POINTERS AND COME UP WITH A BETTER EXCEPTION HIERATCHY*/
  return 0; /*false*/
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimHandle.initConnect) */
#line 266 "sidlx_rmi_SimHandle_Impl.c"
}

/*
 * return the name of the protocol 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimHandle_getProtocol"

char*
impl_sidlx_rmi_SimHandle_getProtocol(
  /* in */ sidlx_rmi_SimHandle self,
  /* out */ sidl_BaseInterface *_ex)
{
#line 272 "../../../babel/runtime/sidlx/sidlx_rmi_SimHandle_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimHandle.getProtocol) */
  struct sidlx_rmi_SimHandle__data *dptr =
    sidlx_rmi_SimHandle__get_data(self);
  if (dptr) {
    return sidl_String_strdup(dptr->d_protocol);;
  }
  SIDL_THROW(*_ex, sidlx_rmi_GenNetworkException, "Simhandle has not been initialized");
 EXIT:
  return NULL;
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimHandle.getProtocol) */
#line 292 "sidlx_rmi_SimHandle_Impl.c"
}

/*
 * return the name of the server 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimHandle_getServerName"

char*
impl_sidlx_rmi_SimHandle_getServerName(
  /* in */ sidlx_rmi_SimHandle self,
  /* out */ sidl_BaseInterface *_ex)
{
#line 296 "../../../babel/runtime/sidlx/sidlx_rmi_SimHandle_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimHandle.getServerName) */
  struct sidlx_rmi_SimHandle__data *dptr =
    sidlx_rmi_SimHandle__get_data(self);
  if (dptr) {
    return sidl_String_strdup(dptr->d_server);;
  }
  SIDL_THROW(*_ex, sidlx_rmi_GenNetworkException, "Simhandle has not been initialized");
 EXIT:
  return NULL;

  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimHandle.getServerName) */
#line 319 "sidlx_rmi_SimHandle_Impl.c"
}

/*
 * return the port number on the server 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimHandle_getPort"

int32_t
impl_sidlx_rmi_SimHandle_getPort(
  /* in */ sidlx_rmi_SimHandle self,
  /* out */ sidl_BaseInterface *_ex)
{
#line 321 "../../../babel/runtime/sidlx/sidlx_rmi_SimHandle_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimHandle.getPort) */
  struct sidlx_rmi_SimHandle__data *dptr =
    sidlx_rmi_SimHandle__get_data(self);
  if (dptr) {
    return dptr->d_port;
  }
  SIDL_THROW(*_ex, sidlx_rmi_GenNetworkException, "Simhandle has not been initialized");
 EXIT:
  return -1;

  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimHandle.getPort) */
#line 346 "sidlx_rmi_SimHandle_Impl.c"
}

/*
 * return the session ID 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimHandle_getObjectID"

char*
impl_sidlx_rmi_SimHandle_getObjectID(
  /* in */ sidlx_rmi_SimHandle self,
  /* out */ sidl_BaseInterface *_ex)
{
#line 347 "../../../babel/runtime/sidlx/sidlx_rmi_SimHandle_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimHandle.getObjectID) */
  struct sidlx_rmi_SimHandle__data *dptr =
    sidlx_rmi_SimHandle__get_data(self);
  if (dptr) {
    return sidl_String_strdup(dptr->d_objectID);
  }
  SIDL_THROW(*_ex, sidlx_rmi_GenNetworkException, "Simhandle has not been initialized");
 EXIT:
  return NULL;
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimHandle.getObjectID) */
#line 372 "sidlx_rmi_SimHandle_Impl.c"
}

/*
 * create a handle to invoke a named method 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimHandle_createInvocation"

sidl_rmi_Invocation
impl_sidlx_rmi_SimHandle_createInvocation(
  /* in */ sidlx_rmi_SimHandle self,
  /* in */ const char* methodName,
  /* out */ sidl_BaseInterface *_ex)
{
#line 373 "../../../babel/runtime/sidlx/sidlx_rmi_SimHandle_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimHandle.createInvocation) */
  struct sidlx_rmi_SimHandle__data *dptr =
    sidlx_rmi_SimHandle__get_data(self);
  if (dptr) {
    sidl_rmi_Invocation ret = NULL;
    sidlx_rmi_Simvocation obj = sidlx_rmi_Simvocation__create();
    sidlx_rmi_ClientSocket connSock = NULL;
    sidlx_rmi_Socket locSock= NULL;
    /*
     * Here where we make a connection to the ORB
     */
    connSock = sidlx_rmi_ClientSocket__create();
    locSock = sidlx_rmi_Socket__cast(connSock);
    sidlx_rmi_ClientSocket_init(connSock, sidl_String_strdup(dptr->d_server), dptr->d_port,_ex);SIDL_CHECK(*_ex);
    
    sidlx_rmi_Simvocation_init(obj, methodName, dptr->d_typeName,dptr->d_objectID, 
			       locSock, _ex); SIDL_CHECK(*_ex);
    ret = sidl_rmi_Invocation__cast(obj);
    sidlx_rmi_ClientSocket_deleteRef(connSock);
    return ret;
  }
  SIDL_THROW(*_ex, sidlx_rmi_GenNetworkException, "Simhandle has not been initialized");
 EXIT:
  return NULL;

  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimHandle.createInvocation) */
#line 415 "sidlx_rmi_SimHandle_Impl.c"
}

/*
 * closes the connection (called be destructor, if not done explicitly) 
 * returns true if successful, false otherwise (including subsequent calls)
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_SimHandle_close"

sidl_bool
impl_sidlx_rmi_SimHandle_close(
  /* in */ sidlx_rmi_SimHandle self,
  /* out */ sidl_BaseInterface *_ex)
{
#line 415 "../../../babel/runtime/sidlx/sidlx_rmi_SimHandle_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.SimHandle.close) */
  /*
   * TODO: In the future I think this will deleteref.
   */
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.SimHandle.close) */
#line 437 "sidlx_rmi_SimHandle_Impl.c"
}
