#include <string>
#include <sstream>
using namespace std;
#include "Args.hh"
#include "synch.hh"




#define MYASSERT( AAA ) \
  tracker.startPart(++part_no); \
  tracker.writeComment(#AAA); \
  if ( AAA ) result = synch::ResultType_PASS; \
  else result = synch::ResultType_FAIL;  \
  tracker.endPart(part_no, result);

int main(int argc, char **argv) { 
  synch::ResultType result = synch::ResultType_PASS; 
  synch::RegOut tracker = synch::RegOut::_create();
  int part_no = 0;
  string language = "";
  tracker.setExpectations(-1);
  if (argc == 2) {
    language = argv[1];
  }
  
  { // bool 
     bool out;
     bool inout = true;
    Args::Cbool obj = Args::Cbool::_create();
 
    MYASSERT( obj.returnback( ) == true );
    MYASSERT( obj.passin( true ) == true );
    MYASSERT( obj.passout( out ) == true && out == true );
    MYASSERT( obj.passinout( inout ) == true && inout == false );
    MYASSERT( obj.passeverywhere( true, out, inout ) == true &&
	      out == true && inout == true );    
  } 

  { // char 
    char out;
    char inout = 'A';
    Args::Cchar obj = Args::Cchar::_create();
 
    MYASSERT( obj.returnback( ) == '3' );
    MYASSERT( obj.passin( '3' ) == true );
    MYASSERT( obj.passout( out ) == true && out == '3' );
    MYASSERT( obj.passinout( inout ) == true && inout == 'a' );
    MYASSERT( obj.passeverywhere( '3', out, inout ) == '3' &&
	      out == '3' && inout == 'A' );
  }


  { // int 
    int32_t out;
    int32_t inout = 3;
    Args::Cint obj = Args::Cint::_create();
 
    MYASSERT( obj.returnback( ) == 3 );
    MYASSERT( obj.passin( 3 ) == true );
    MYASSERT( obj.passout( out ) == true && out == 3 );
    MYASSERT( obj.passinout( inout ) == true && inout == -3 );
    MYASSERT( obj.passeverywhere( 3, out, inout ) == 3 &&
	      out == 3 && inout == 3 );
  }


  { // long 
    int64_t out;
    int64_t inout = 3L;
    Args::Clong obj = Args::Clong::_create();
 
    MYASSERT( obj.returnback( ) == 3L );
    MYASSERT( obj.passin( 3L ) == true );
    MYASSERT( obj.passout( out ) == true && out == 3L );
    MYASSERT( obj.passinout( inout ) == true && inout == -3L );
    MYASSERT( obj.passeverywhere( 3L, out, inout ) == 3L &&
	      out == 3L && inout == 3L );
  }


  { // float 
    ostringstream buf;
    float out;
    float inout = 3.1F;
    Args::Cfloat obj = Args::Cfloat::_create();
    buf << "obj.returnback() == " << obj.returnback();
    tracker.writeComment(buf.str());
    MYASSERT( obj.returnback( ) == 3.1F );
    MYASSERT( obj.passin( 3.1F ) == true );
    MYASSERT( obj.passout( out ) == true && out == 3.1F );
    MYASSERT( obj.passinout( inout ) == true && inout == -3.1F );
    MYASSERT( obj.passeverywhere( 3.1F, out, inout ) == 3.1F &&
	      out == 3.1F && inout == 3.1F );
  }


  { // double 
    double out;
    double inout = 3.14;
    Args::Cdouble obj = Args::Cdouble::_create();
 
    MYASSERT( obj.returnback( ) == 3.14 );
    MYASSERT( obj.passin( 3.14 ) == true );
    MYASSERT( obj.passout( out ) == true && out == 3.14 );
    MYASSERT( obj.passinout( inout ) == true && inout == -3.14 );
    MYASSERT( obj.passeverywhere( 3.14, out, inout ) == 3.14 &&
	      out == 3.14 && inout == 3.14 );
  }


  { // fcomplex 
    ostringstream buf;
    complex<float> retval;
    complex<float> in( 3.1F, 3.1F );
    complex<float> out;
    complex<float> inout( 3.1F, 3.1F );
    Args::Cfcomplex obj = Args::Cfcomplex::_create();
 
    buf << "retval = " << obj.returnback( );
    tracker.writeComment(buf.str());
    retval = obj.returnback( ); 
    MYASSERT( retval.real() == 3.1F && retval.imag() == 3.1F);
    MYASSERT( obj.passin( in ) == true );

    MYASSERT( obj.passout( out ) == true && 
	      out.real() == 3.1F && out.imag() == 3.1F );
    MYASSERT( obj.passinout( inout ) == true && 
	      inout.real() == 3.1F && inout.imag() == -3.1F );
    tracker.writeComment("retval = obj.passeverywhere( in, out, inout );");
    retval = obj.passeverywhere( in, out, inout );
    MYASSERT( retval.real() == 3.1F && retval.imag() == 3.1F &&
	      out.real() == 3.1F && out.imag() == 3.1F && 
	      inout.real() == 3.1F && inout.imag() == 3.1F );
  }


  { // dcomplex 
    complex<double> retval;
    complex<double> in( 3.14, 3.14 );
    complex<double> out;
    complex<double> inout( 3.14, 3.14 );
    Args::Cdcomplex obj = Args::Cdcomplex::_create();
 
    tracker.writeComment("retval = obj.returnback( );");
    retval = obj.returnback( );
    MYASSERT( retval.real() == 3.14 && retval.imag() == 3.14);
    MYASSERT( obj.passin( in ) == true );
    MYASSERT( obj.passout( out ) == true && 
	      out.real() == 3.14 && out.imag() == 3.14 );
    MYASSERT( obj.passinout( inout ) == true && 
	      inout.real() == 3.14 && inout.imag() == -3.14 );
    tracker.writeComment("retval = obj.passeverywhere( in, out, inout );");
    retval = obj.passeverywhere( in, out, inout );
    MYASSERT( retval.real() == 3.14 && retval.imag() == 3.14 &&
	      out.real() == 3.14 && out.imag() == 3.14 && 
	      inout.real() == 3.14 && inout.imag() == 3.14 );

  }

  tracker.close();
  return 0;
}

