// 
// File:          gov_cca_ports_BuilderService.cc
// Symbol:        gov.cca.ports.BuilderService-v0.6.3
// Symbol Type:   interface
// Babel Version: 0.10.2
// Description:   Client-side glue code for gov.cca.ports.BuilderService
// 
// WARNING: Automatically generated; changes will be lost
// 
// babel-version = 0.10.2
// 

#ifndef included_gov_cca_ports_BuilderService_hh
#include "gov_cca_ports_BuilderService.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_BaseClass_hh
#include "sidl_BaseClass.hh"
#endif
#ifndef included_sidl_BaseException_hh
#include "sidl_BaseException.hh"
#endif
#include "sidl_String.h"
#include "babel_config.h"
#ifdef SIDL_DYNAMIC_LIBRARY
#include <stdio.h>
#include <stdlib.h>
#include "sidl_Loader.hh"
#endif


//////////////////////////////////////////////////
// 
// User Defined Methods
// 


/**
 * Return true if and only if <code>obj</code> refers to the same
 * object as this object.
 */
bool
gov::cca::ports::BuilderService::isSame( /* in */ ::sidl::BaseInterface iobj )
throw ()

{
  bool _result;
  sidl_bool _local_result;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_isSame))(d_self->d_object,
    /* in */ iobj._get_ior() );
  /*dispatch to ior*/
  _result = _local_result;
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Check whether the object can support the specified interface or
 * class.  If the <code>sidl</code> type name in <code>name</code>
 * is supported, then a reference to that object is returned with the
 * reference count incremented.  The callee will be responsible for
 * calling <code>deleteRef</code> on the returned object.  If
 * the specified type is not supported, then a null reference is
 * returned.
 */
::sidl::BaseInterface
gov::cca::ports::BuilderService::queryInt( /* in */ const ::std::string& name )
throw ()

{
  ::sidl::BaseInterface _result;
  /*pack args to dispatch to ior*/
  _result = ::sidl::BaseInterface( 
    (*(d_self->d_epv->f_queryInt))(d_self->d_object, /* in */ name.c_str() ),
    false);
  /*dispatch to ior*/
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Return whether this object is an instance of the specified type.
 * The string name must be the <code>sidl</code> type name.  This
 * routine will return <code>true</code> if and only if a cast to
 * the string type name would succeed.
 */
bool
gov::cca::ports::BuilderService::isType( /* in */ const ::std::string& name )
throw ()

{
  bool _result;
  sidl_bool _local_result;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_isType))(d_self->d_object,
    /* in */ name.c_str() );
  /*dispatch to ior*/
  _result = _local_result;
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Return the meta-data about the class implementing this interface.
 */
::sidl::ClassInfo
gov::cca::ports::BuilderService::getClassInfo(  )
throw ()

{
  ::sidl::ClassInfo _result;
  /*pack args to dispatch to ior*/
  _result = ::sidl::ClassInfo( 
    (*(d_self->d_epv->f_getClassInfo))(d_self->d_object ), false);
  /*dispatch to ior*/
  /*unpack results and cleanup*/
  return _result;
}



/**
 * 	Creates an instance of a CCA component of the type defined by the 
 * 	string className.  The string classname uniquely defines the
 * 	"type" of the component, e.g.
 * 	    doe.cca.Library.GaussianElmination. 
 * 	It has an instance name given by the string instanceName.
 * 	The instanceName may be empty (zero length) in which case
 * 	the instanceName will be assigned to the component automatically.
 * 	@throws CCAException If the Component className is unknown, or if the
 * 		instanceName has already been used, a CCAException is thrown.
 * 	@return A ComponentID corresponding to the created component. Destroying
 * 		the returned ID does not destroy the component; 
 * 		see destroyInstance instead.
 */
::gov::cca::ComponentID
gov::cca::ports::BuilderService::createInstance( /* in */ const ::std::string& 
  instanceName, /* in */ const ::std::string& className,
  /* in */ ::gov::cca::TypeMap properties )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::ComponentID _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::ComponentID( 
    (*(d_self->d_epv->f_createInstance))(d_self->d_object,
    /* in */ instanceName.c_str(), /* in */ className.c_str(),
    /* in */ properties._get_ior(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 *  Get component list.
 *  @return a ComponentID for each component currently created.
 */
::sidl::array< ::gov::cca::ComponentID>
gov::cca::ports::BuilderService::getComponentIDs(  )
throw ( ::gov::cca::CCAException)

{
  ::sidl::array< ::gov::cca::ComponentID> _result;
  struct gov_cca_ComponentID__array* _local_result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_getComponentIDs))(d_self->d_object,
    &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  _result._set_ior(_local_result);
  /*unpack results and cleanup*/
  return _result;
}



/**
 *  Get property map for component.
 *  @return the public properties associated with the component referred to by
 *  ComponentID. 
 *  @throws a CCAException if the ComponentID is invalid.
 */
::gov::cca::TypeMap
gov::cca::ports::BuilderService::getComponentProperties( /* in */ 
  ::gov::cca::ComponentID cid )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::TypeMap _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::TypeMap( 
    (*(d_self->d_epv->f_getComponentProperties))(d_self->d_object,
    /* in */ cid._get_ior(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * 	Causes the framework implementation to associate the given properties 
 * 	with the component designated by cid. 
 * 	@throws CCAException if cid is invalid or if there is an attempted
 * 	change to a property locked by the framework implementation.
 */
void
gov::cca::ports::BuilderService::setComponentProperties( /* in */ 
  ::gov::cca::ComponentID cid, /* in */ ::gov::cca::TypeMap map )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_setComponentProperties))(d_self->d_object,
    /* in */ cid._get_ior(), /* in */ map._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Get component id from stringified reference.
 *    @return a ComponentID from the string produced by 
 * 	ComponentID.getSerialization(). 
 *    @throws CCAException if the string does not represent the appropriate 
 * 	 serialization of a ComponentID for the underlying framework.
 */
::gov::cca::ComponentID
gov::cca::ports::BuilderService::getDeserialization( /* in */ const 
  ::std::string& s )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::ComponentID _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::ComponentID( 
    (*(d_self->d_epv->f_getDeserialization))(d_self->d_object,
    /* in */ s.c_str(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Get id from name by which it was created.
 *  @return a ComponentID from the instance name of the component
 *  produced by ComponentID.getInstanceName().
 *  @throws CCAException if there is no component matching the 
 *  given componentInstanceName.
 */
::gov::cca::ComponentID
gov::cca::ports::BuilderService::getComponentID( /* in */ const ::std::string& 
  componentInstanceName )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::ComponentID _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::ComponentID( 
    (*(d_self->d_epv->f_getComponentID))(d_self->d_object,
    /* in */ componentInstanceName.c_str(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 *  Eliminate the Component instance, from the scope of the framework.
 *  @param toDie the component to be removed.
 *  @param timeout the allowable wait; 0 means up to the framework.
 *  @throws CCAException if toDie refers to an invalid component, or
 *  if the operation takes longer than timeout seconds.
 */
void
gov::cca::ports::BuilderService::destroyInstance( /* in */ 
  ::gov::cca::ComponentID toDie, /* in */ float timeout )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_destroyInstance))(d_self->d_object,
    /* in */ toDie._get_ior(), /* in */ timeout, &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 *  Get the names of Port instances provided by the identified component.
 *  @param cid the component.
 *  @throws CCAException if cid refers to an invalid component.
 */
::sidl::array< ::std::string>
gov::cca::ports::BuilderService::getProvidedPortNames( /* in */ 
  ::gov::cca::ComponentID cid )
throw ( ::gov::cca::CCAException)

{
  ::sidl::array< ::std::string> _result;
  struct sidl_string__array* _local_result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_getProvidedPortNames))(d_self->d_object,
    /* in */ cid._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  _result._set_ior(_local_result);
  /*unpack results and cleanup*/
  return _result;
}



/**
 *  Get the names of Port instances used by the identified component.
 *  @param cid the component.
 *  @throws CCAException if cid refers to an invalid component. 
 */
::sidl::array< ::std::string>
gov::cca::ports::BuilderService::getUsedPortNames( /* in */ 
  ::gov::cca::ComponentID cid )
throw ( ::gov::cca::CCAException)

{
  ::sidl::array< ::std::string> _result;
  struct sidl_string__array* _local_result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_getUsedPortNames))(d_self->d_object,
    /* in */ cid._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  _result._set_ior(_local_result);
  /*unpack results and cleanup*/
  return _result;
}



/**
 *  Fetch map of Port properties exposed by the framework.
 *  @return the public properties pertaining to the Port instance 
 *    portname on the component referred to by cid. 
 *  @throws CCAException when any one of the following conditions occur:<ul>
 *    <li>portname is not a registered Port on the component indicated by cid,
 *    <li>cid refers to an invalid component. </ul>
 */
::gov::cca::TypeMap
gov::cca::ports::BuilderService::getPortProperties( /* in */ 
  ::gov::cca::ComponentID cid, /* in */ const ::std::string& portName )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::TypeMap _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::TypeMap( 
    (*(d_self->d_epv->f_getPortProperties))(d_self->d_object,
    /* in */ cid._get_ior(), /* in */ portName.c_str(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 *  Associates the properties given in map with the Port indicated by 
 *  portname. The component must have a Port known by portname.
 *  @throws CCAException if either cid or portname are
 * 	invalid, or if this a changed property is locked by 
 * 	 the underlying framework or component.
 */
void
gov::cca::ports::BuilderService::setPortProperties( /* in */ 
  ::gov::cca::ComponentID cid, /* in */ const ::std::string& portName,
  /* in */ ::gov::cca::TypeMap map )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_setPortProperties))(d_self->d_object,
    /* in */ cid._get_ior(), /* in */ portName.c_str(), /* in */ map._get_ior(),
    &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 *   Creates a connection between ports on component user and 
 *   component provider. Destroying the ConnectionID does not
 *   cause a disconnection; for that, see disconnect().
 *   @throws CCAException when any one of the following conditions occur:<ul>
 *   <li>If either user or provider refer to an invalid component,
 *   <li>If either usingPortName or providingPortName refer to a 
 * 	 nonexistent Port on their respective component,
 *   <li>If other-- In reality there are a lot of things that can go wrong 
 * 	 with this operation, especially if the underlying connections 
 * 	 involve networking.</ul>
 */
::gov::cca::ConnectionID
gov::cca::ports::BuilderService::connect( /* in */ ::gov::cca::ComponentID user,
  /* in */ const ::std::string& usingPortName,
  /* in */ ::gov::cca::ComponentID provider,
  /* in */ const ::std::string& providingPortName )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::ConnectionID _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::ConnectionID( 
    (*(d_self->d_epv->f_connect))(d_self->d_object, /* in */ user._get_ior(),
    /* in */ usingPortName.c_str(), /* in */ provider._get_ior(),
    /* in */ providingPortName.c_str(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Returns a list of connections as an array of 
 * 	handles. This will return all connections involving components 
 * 	in the given componentList of ComponentIDs. This
 * 	means that ConnectionID's will be returned even if only one 
 * 	of the participants in the connection appears in componentList.
 * 
 * 	@throws CCAException if any component in componentList is invalid.
 */
::sidl::array< ::gov::cca::ConnectionID>
gov::cca::ports::BuilderService::getConnectionIDs( /* in */ ::sidl::array< 
  ::gov::cca::ComponentID> componentList )
throw ( ::gov::cca::CCAException)

{
  ::sidl::array< ::gov::cca::ConnectionID> _result;
  struct gov_cca_ConnectionID__array* _local_result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_getConnectionIDs))(d_self->d_object,
    /* in */ componentList._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  _result._set_ior(_local_result);
  /*unpack results and cleanup*/
  return _result;
}



/**
 *   Fetch property map of a connection.
 *   @returns the properties for the given connection.
 *   @throws CCAException if connID is invalid.
 */
::gov::cca::TypeMap
gov::cca::ports::BuilderService::getConnectionProperties( /* in */ 
  ::gov::cca::ConnectionID connID )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::TypeMap _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::TypeMap( 
    (*(d_self->d_epv->f_getConnectionProperties))(d_self->d_object,
    /* in */ connID._get_ior(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Associates the properties with the connection.
 *   @param map the source of the properties.
 *   @param connID connection to receive property values.
 *   @throws CCAException if connID is invalid, or if this changes 
 * 	 a property locked by the underlying framework.
 */
void
gov::cca::ports::BuilderService::setConnectionProperties( /* in */ 
  ::gov::cca::ConnectionID connID, /* in */ ::gov::cca::TypeMap map )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_setConnectionProperties))(d_self->d_object,
    /* in */ connID._get_ior(), /* in */ map._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Disconnect the connection indicated by connID before the indicated
 *     timeout in secs. Upon successful completion, connID and the connection
 *     it represents become invalid. 
 *     @param timeout the time in seconds to wait for a connection to close; 0
 *     means to use the framework implementation default.
 *     @throws CCAException when any one of the following conditions occur: <ul>
 *     <li>id refers to an invalid ConnectionID,
 *     <li>timeout is exceeded, after which, if id was valid before 
 * disconnect() was invoked, it remains valid
 * </ul>
 * 
 */
void
gov::cca::ports::BuilderService::disconnect( /* in */ ::gov::cca::ConnectionID 
  connID, /* in */ float timeout )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_disconnect))(d_self->d_object, /* in */ connID._get_ior(),
    /* in */ timeout, &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Remove all connections between components id1 and id2 within 
 *   the period of timeout secs. If id2 is null, then all connections 
 *   to id1 are removed (within the period of timeout secs).
 *   @throws CCAException when any one of the following conditions occur:<ul>
 * 	  <li>id1 or id2 refer to an invalid ComponentID (other than id2 == null),
 * 	  <li>The timeout period is exceeded before the disconnections can be made. 
 * 	  </ul>
 */
void
gov::cca::ports::BuilderService::disconnectAll( /* in */ 
  ::gov::cca::ComponentID id1, /* in */ ::gov::cca::ComponentID id2,
  /* in */ float timeout )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_disconnectAll))(d_self->d_object, /* in */ id1._get_ior(),
    /* in */ id2._get_ior(), /* in */ timeout, &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



//////////////////////////////////////////////////
// 
// End User Defined Methods
// (everything else in this file is specific to
//  Babel's C++ bindings)
// 

// default destructor
gov::cca::ports::BuilderService::~BuilderService () {
  if ( d_self != 0 ) {
    deleteRef();
  }
}

// copy constructor
gov::cca::ports::BuilderService::BuilderService ( const 
  ::gov::cca::ports::BuilderService& original ) {
  d_self = const_cast< ior_t*>(original.d_self);
  d_weak_reference = original.d_weak_reference;
  if (d_self != 0 ) {
    addRef();
  }
}

// assignment operator
::gov::cca::ports::BuilderService&
gov::cca::ports::BuilderService::operator=( const 
  ::gov::cca::ports::BuilderService& rhs ) {
  if ( d_self != rhs.d_self ) {
    if ( d_self != 0 ) {
      deleteRef();
    }
    d_self = const_cast< ior_t*>(rhs.d_self);
    d_weak_reference = rhs.d_weak_reference;
    if ( d_self != 0 ) {
      addRef();
    }
  }
  return *this;
}

// conversion from ior to C++ class
gov::cca::ports::BuilderService::BuilderService ( 
  ::gov::cca::ports::BuilderService::ior_t* ior ) 
    : d_self( ior ), d_weak_reference(false) {
  if ( d_self != 0 ) {
    addRef();
  }
}

// Alternate constructor: does not call addRef()
// (sets d_weak_reference=isWeak)
// For internal use by Impls (fixes bug#275)
gov::cca::ports::BuilderService::BuilderService ( 
  ::gov::cca::ports::BuilderService::ior_t* ior, bool isWeak ) 
    : d_self( ior ), d_weak_reference(isWeak) { 
}

// conversion from a StubBase
gov::cca::ports::BuilderService::BuilderService ( const ::sidl::StubBase& base )
{
  d_self = reinterpret_cast< 
    ior_t*>(base._cast("gov.cca.ports.BuilderService"));
  d_weak_reference = false;
  if (d_self != 0) {
    addRef();
  }
}

// protected method that implements casting
void* gov::cca::ports::BuilderService::_cast(const char* type) const
{
  void* ptr = 0;
  if ( d_self != 0 ) {
    ptr = reinterpret_cast< void*>((*d_self->d_epv->f__cast)(d_self->d_object,
      type));
  }
  return ptr;
}

extern "C" {


} // end extern "C"
