//
// File:        SIDLException.java
// Package:     gov.llnl.babel.parsers.sidl
// Revision:    @(#) $Id: SIDLException.java 4434 2005-03-17 17:05:29Z epperly $
// Description: sidl exception base class for grammar and symbol errors
//
// Copyright (c) 2000-2001, The Regents of the University of Calfornia.
// Produced at the Lawrence Livermore National Laboratory.
// Written by the Components Team <components@llnl.gov>
// UCRL-CODE-2002-054
// All rights reserved.
// 
// This file is part of Babel. For more information, see
// http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
// for Our Notice and the LICENSE file for the GNU Lesser General Public
// License.
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License (as published by
// the Free Software Foundation) version 2.1 dated February 1999.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
// conditions of the GNU Lesser General Public License for more details.
// 
// You should have recieved a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package gov.llnl.babel.parsers.sidl;

/**
 * Exception <code>SIDLException</code> is the base class for both grammar
 * (e.g., parse) and symbol (e.g., analysis) exceptions.  This base class
 * contains location and production information.
 */
public class SIDLException extends Exception {
   private int d_line;
   private int d_column;
   private int d_production;
   
   /**
    * Create a <code>SIDLException</code> located at the specified line and
    * column within the specified production.
    */
   public SIDLException(int line, int column, int production) {
      d_line       = line;
      d_column     = column;
      d_production = production;
   }

   /**
    * Return the line number of the token that caused the exception.
    */
   public int getLineNumber() {
      return d_line;
   }

   /**
    * Return the column number of the token that caused the exception.
    */
   public int getColumnNumber() {
      return d_column;
   }

   /**
    * Return the production number of the token that caused the exception.
    */
   public int getProductionNumber() {
      return d_production;
   }
}
