/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.Assertion;
import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Metadata;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;

public abstract class Extendable
extends Symbol {
    private ArrayList d_all_abstract_methods = new ArrayList();
    private HashSet d_all_basicarrays = new HashSet();
    private HashMap d_all_interfaces = new HashMap();
    private ArrayList d_all_methods = new ArrayList();
    private HashMap d_all_methods_long = new HashMap();
    private HashMap d_all_methods_short = new HashMap();
    private HashSet d_all_references = new HashSet();
    private ArrayList d_all_nonstatic_methods = new ArrayList();
    private ArrayList d_all_static_methods = new ArrayList();
    private HashMap d_local_interfaces = new HashMap();
    private ArrayList d_local_methods = new ArrayList();
    private HashMap d_local_methods_long = new HashMap();
    private HashMap d_local_methods_short = new HashMap();
    private ArrayList d_local_nonstatic_methods = new ArrayList();
    private ArrayList d_local_static_methods = new ArrayList();
    private ArrayList d_invariants = new ArrayList();

    public Extendable(SymbolID id, int type, Comment comment) {
        super(id, type, comment);
        this.d_all_references.add(id);
    }

    public Extendable(SymbolID id, int type, Comment comment, Metadata m) {
        super(id, type, comment, m);
        this.d_all_references.add(id);
    }

    public abstract boolean isAbstract();

    public abstract boolean isInterface();

    public void addMethod(Method method) {
        this.addToMethodLists(method, false);
        this.d_all_references.addAll(method.getSymbolReferences());
        this.d_all_basicarrays.addAll(method.getBasicArrays());
    }

    public int getNumberOfMethods(boolean all) {
        return all ? this.d_all_methods.size() : this.d_local_methods.size();
    }

    public Collection getMethods(boolean all) {
        return all ? this.d_all_methods : this.d_local_methods;
    }

    public Collection getNonstaticMethods(boolean all) {
        return all ? this.d_all_nonstatic_methods : this.d_local_nonstatic_methods;
    }

    public Collection getStaticMethods(boolean all) {
        return all ? this.d_all_static_methods : this.d_local_static_methods;
    }

    public Collection getAbstractMethods() {
        return this.d_all_abstract_methods;
    }

    public Collection getAbstractAndLocalMethods() {
        ArrayList ret = (ArrayList)this.d_local_methods.clone();
        Iterator abs = this.d_all_abstract_methods.iterator();
        while (abs.hasNext()) {
            Method locM;
            Method absM = (Method)abs.next();
            Iterator local = this.d_local_methods.iterator();
            while (local.hasNext() && absM != (locM = (Method)local.next())) {
                if (local.hasNext()) continue;
                ret.add(absM);
            }
        }
        return ret;
    }

    public boolean isLocal(Method m) {
        return m != null && m.equals(this.d_local_methods_long.get(m.getLongMethodName()));
    }

    public Method lookupMethodByLongName(String name, boolean all) {
        return (Method)(all ? this.d_all_methods_long.get(name) : this.d_local_methods_long.get(name));
    }

    public Collection lookupMethodByShortName(String name, boolean all) {
        return (Collection)(all ? this.d_all_methods_short.get(name) : this.d_local_methods_short.get(name));
    }

    public boolean hasMethodByLongName(String name, boolean all) {
        return all ? this.d_all_methods_long.containsKey(name) : this.d_local_methods_long.containsKey(name);
    }

    public boolean hasMethodByShortName(String name, boolean all) {
        return all ? this.d_all_methods_short.containsKey(name) : this.d_local_methods_short.containsKey(name);
    }

    public abstract boolean hasStaticMethod(boolean var1);

    public boolean hasExceptionThrowingMethod(boolean all) {
        boolean has_exception_throwing_method = false;
        Iterator i = this.getMethods(all).iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            if (method.getThrows().size() <= 0) continue;
            has_exception_throwing_method = true;
            break;
        }
        return has_exception_throwing_method;
    }

    public abstract void addParentInterface(Interface var1);

    public Collection getParentInterfaces(boolean all) {
        return all ? this.d_all_interfaces.values() : this.d_local_interfaces.values();
    }

    private boolean findExistingEntry(ArrayList list, Extendable ext) {
        boolean found = false;
        Extendable item = null;
        ListIterator iter = list.listIterator();
        while (iter.hasNext() && !found) {
            item = (Extendable)iter.next();
            if (item != ext) continue;
            found = true;
        }
        return found;
    }

    public ArrayList getAllParentsInOrder() {
        ArrayList<Extendable> ancestors = new ArrayList<Extendable>();
        Collection parents = this.getParents(false);
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            Extendable parent = (Extendable)i.next();
            if (this.findExistingEntry(ancestors, parent)) continue;
            ancestors.addAll(parent.getAllParentsInOrder());
            ancestors.add(parent);
        }
        return ancestors;
    }

    public Collection getParents(boolean all) {
        return this.getParentInterfaces(all);
    }

    public boolean hasAncestor(Extendable ext) {
        Extendable parent;
        if (ext == null) {
            return false;
        }
        Collection parents = this.getParents(false);
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            parent = (Extendable)i.next();
            if (ext != parent) continue;
            return true;
        }
        i = parents.iterator();
        while (i.hasNext()) {
            parent = (Extendable)i.next();
            if (!parent.hasAncestor(ext)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParentInterface(SymbolID id, boolean all) {
        return all ? this.d_all_interfaces.containsKey(id) : this.d_local_interfaces.containsKey(id);
    }

    public Set getSymbolReferences() {
        return this.d_all_references;
    }

    public Set getAllSymbolReferences() {
        return this.getSymbolReferences();
    }

    public Set getBasicArrayRefs() {
        return this.d_all_basicarrays;
    }

    protected void addParentData(Extendable ext) {
        Iterator m = ext.getMethods(true).iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            this.addToMethodLists(method, true);
        }
        if (ext.isInterface()) {
            this.d_all_interfaces.put(ext.getSymbolID(), ext);
            this.d_local_interfaces.put(ext.getSymbolID(), ext);
        }
        Collection parents = ext.getParentInterfaces(true);
        Iterator p = parents.iterator();
        while (p.hasNext()) {
            Extendable e = (Extendable)p.next();
            this.d_all_interfaces.put(e.getSymbolID(), e);
        }
        this.d_all_references.addAll(ext.getSymbolReferences());
        this.d_all_basicarrays.addAll(ext.getBasicArrayRefs());
    }

    public Collection getOverloadedMethodsByName(String shortName) {
        ArrayList<Method> ret = new ArrayList<Method>();
        Iterator i = this.d_all_methods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.getShortMethodName().compareTo(shortName) != 0) continue;
            ret.add(m);
        }
        return ret;
    }

    private void findExistingEntry(ArrayList list, Method method, boolean replaceIt) {
        String name = method.getLongMethodName();
        boolean found = false;
        Method item = null;
        ListIterator iter = list.listIterator();
        while (iter.hasNext() && !found) {
            item = (Method)iter.next();
            if (!item.getLongMethodName().equals(name)) continue;
            found = true;
            iter.remove();
        }
        if (replaceIt) {
            list.add(method);
        }
    }

    private void addToShortMethodList(HashMap list, Method method) {
        String name = method.getShortMethodName();
        if (list.containsKey(name)) {
            this.findExistingEntry((ArrayList)list.get(name), method, true);
        } else {
            ArrayList<Method> sublist = new ArrayList<Method>();
            sublist.add(method);
            list.put(name, sublist);
        }
    }

    private void addToMethodLists(Method method, boolean isParent) {
        String long_name = method.getLongMethodName();
        if (!this.hasMethodByLongName(long_name, true) || !method.isAbstract()) {
            boolean is_static = method.isStatic();
            this.findExistingEntry(this.d_all_methods, method, true);
            this.d_all_methods_long.put(long_name, method);
            this.addToShortMethodList(this.d_all_methods_short, method);
            if (is_static) {
                this.findExistingEntry(this.d_all_static_methods, method, true);
            } else {
                this.findExistingEntry(this.d_all_nonstatic_methods, method, true);
            }
            if (method.isAbstract()) {
                this.findExistingEntry(this.d_all_abstract_methods, method, true);
            } else {
                this.findExistingEntry(this.d_all_abstract_methods, method, false);
            }
            if (!isParent) {
                this.findExistingEntry(this.d_local_methods, method, true);
                this.d_local_methods_long.put(long_name, method);
                this.addToShortMethodList(this.d_local_methods_short, method);
                if (is_static) {
                    this.findExistingEntry(this.d_local_static_methods, method, true);
                } else {
                    this.findExistingEntry(this.d_local_nonstatic_methods, method, true);
                }
            }
        }
    }

    public void addInvariant(Assertion assertion) throws AssertionException {
        if (!assertion.isInvariant()) {
            throw new AssertionException("Extendable: " + this.getFullName(), "Cannot add a(n) \"" + assertion.getTypeName() + "\" assertion to the " + "invariants list.");
        }
        this.d_invariants.add(assertion);
    }

    public boolean hasInvariants(boolean all) {
        boolean has = false;
        has = this.getNumberInvariants(false) > 0 ? true : this.getNumberInvariants(all) > 0;
        return has;
    }

    public int getNumberInvariants(boolean all) {
        return all ? this.d_invariants.size() : this.getAllInvariants().size();
    }

    public ArrayList getInvariants() {
        return this.d_invariants;
    }

    public ArrayList getAllInvariants() {
        ArrayList list = new ArrayList();
        ArrayList parents = this.getAllParentsInOrder();
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            Extendable parent = (Extendable)i.next();
            list.addAll(parent.getAllInvariants());
        }
        list.addAll(this.d_invariants);
        return list;
    }

    public void validateInvariants(boolean all, boolean skip) throws AssertionException {
        ArrayList list = all ? this.getAllInvariants() : this.d_invariants;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Assertion inv = (Assertion)i.next();
            inv.validateExpression(this, null, skip);
        }
    }

    public boolean hasAssertions() {
        boolean has = false;
        if (this.hasInvariants(true)) {
            has = true;
        } else {
            Iterator i = this.getMethods(true).iterator();
            while (i.hasNext() && !has) {
                Method method = (Method)i.next();
                String lname = method.getLongMethodName();
                if (this.getNumberPreconditions(lname) <= 0 && this.getNumberPostconditions(lname) <= 0) continue;
                has = true;
            }
        }
        return has;
    }

    public int getNumberAssertions(String longname) {
        return this.getNumberPreconditions(longname) + 2 * this.getNumberInvariants(true) + this.getNumberPostconditions(longname);
    }

    public int getNumberPreconditions(String longname) {
        return this.getAllPreconditions(longname).size();
    }

    public ArrayList getAllPreconditions(String longname) {
        ArrayList list = new ArrayList();
        ArrayList parents = this.getAllParentsInOrder();
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            Extendable parent = (Extendable)i.next();
            list.addAll(parent.getAllPreconditions(longname));
        }
        Method meth = this.lookupMethodByLongName(longname, false);
        if (meth != null) {
            list.addAll(meth.getPreconditions());
        }
        return list;
    }

    public void validatePreconditions(Method meth, boolean all, boolean skip) throws AssertionException {
        if (meth != null) {
            ArrayList list;
            if (all) {
                String longname = meth.getLongMethodName();
                list = this.getAllPreconditions(longname);
            } else {
                list = meth.getPreconditions();
            }
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Assertion pre = (Assertion)i.next();
                pre.validateExpression(this, meth, skip);
            }
        } else {
            throw new AssertionException("Extendable: " + this.getFullName(), "Cannot validate preconditions for specified method when no method given.");
        }
    }

    public void validatePreconditions(String longname, boolean all, boolean skip) throws AssertionException {
        this.validatePreconditions(this.lookupMethodByLongName(longname, true), all, skip);
    }

    public void validatePreconditions(boolean all, boolean skip) throws AssertionException {
        Iterator im = all ? this.d_all_methods.iterator() : this.d_local_methods.iterator();
        while (im.hasNext()) {
            Method meth = (Method)im.next();
            this.validatePreconditions(meth, all, skip);
        }
    }

    public int getNumberPostconditions(String longname) {
        return this.getAllPostconditions(longname).size();
    }

    public ArrayList getAllPostconditions(String longname) {
        ArrayList list = new ArrayList();
        ArrayList parents = this.getAllParentsInOrder();
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            Extendable parent = (Extendable)i.next();
            list.addAll(parent.getAllPostconditions(longname));
        }
        Method meth = this.lookupMethodByLongName(longname, false);
        if (meth != null) {
            list.addAll(meth.getPostconditions());
        }
        return list;
    }

    public void validatePostconditions(Method meth, boolean all, boolean skip) throws AssertionException {
        if (meth != null) {
            ArrayList list;
            if (all) {
                String longname = meth.getLongMethodName();
                list = this.getAllPostconditions(longname);
            } else {
                list = meth.getPostconditions();
            }
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Assertion post = (Assertion)i.next();
                post.validateExpression(this, meth, skip);
            }
        } else {
            throw new AssertionException("Extendable: " + this.getFullName(), "Cannot validate postconditions for specified method when no method given.");
        }
    }

    public void validatePostconditions(String longname, boolean all, boolean skip) throws AssertionException {
        this.validatePostconditions(this.lookupMethodByLongName(longname, true), all, skip);
    }

    public void validatePostconditions(boolean all, boolean skip) throws AssertionException {
        Iterator im = all ? this.d_all_methods.iterator() : this.d_local_methods.iterator();
        while (im.hasNext()) {
            Method meth = (Method)im.next();
            this.validatePostconditions(meth, all, skip);
        }
    }

    public void validateAssertions(boolean all, boolean skip) throws AssertionException {
        this.validateInvariants(all, skip);
        Iterator im = all ? this.d_all_methods.iterator() : this.d_local_methods.iterator();
        while (im.hasNext()) {
            Method meth = (Method)im.next();
            this.validatePreconditions(meth, all, skip);
            this.validatePostconditions(meth, all, skip);
        }
    }

    public boolean hasReservedMethodAssertion(int type) {
        boolean hasIt = false;
        ArrayList list = this.getAllInvariants();
        Iterator i = list.iterator();
        while (i.hasNext() && !hasIt) {
            Assertion inv = (Assertion)i.next();
            if (!inv.hasReservedMethod(type)) continue;
            hasIt = true;
        }
        if (!hasIt) {
            Iterator im = this.d_all_methods.iterator();
            while (im.hasNext() && !hasIt) {
                Method meth = (Method)im.next();
                if (!meth.hasReservedMethodAssertion(type)) continue;
                hasIt = true;
            }
        }
        return hasIt;
    }
}

