/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.repository;

import gov.llnl.babel.parsers.xml.SymbolToDOM;
import gov.llnl.babel.repository.Repository;
import gov.llnl.babel.repository.RepositoryException;
import gov.llnl.babel.repository.RepositoryFactory;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Version;

public class RepositoryTest {
    public static void main(String[] argv) {
        if (argv.length != 2 && argv.length != 3) {
            System.err.println("usage: gov.llnl.babel.repository.RepositoryTest repository-URI symbol-name [symbol-version]");
            System.exit(1);
        }
        Repository repository = null;
        try {
            String r = argv[0];
            repository = RepositoryFactory.getInstance().createRepository(r);
        }
        catch (RepositoryException ex) {
            System.err.println("Babel: Error: RepositoryException");
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        SymbolTable.getInstance().addSymbolResolver(repository);
        Symbol symbol = null;
        if (argv.length == 2) {
            symbol = repository.lookupSymbol(argv[1]);
        } else {
            try {
                SymbolID id = new SymbolID(argv[1], new Version(argv[2]));
                symbol = repository.lookupSymbol(id);
            }
            catch (NumberFormatException ex) {
                System.err.println("Babel: Error: NumberFormatException");
                System.err.println(ex.getMessage());
                System.exit(1);
            }
        }
        if (symbol == null) {
            System.out.println("Symbol not found in repository");
        } else {
            System.out.println(SymbolToDOM.convertToString(symbol));
        }
    }
}

