/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.c;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.ArrayMethods;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class C {
    public static final String FUNCTION_RESULT = "_result";
    public static final String NULL = "NULL";
    public static final String RAW_ARRAY_EXT = "_tmp";
    private static final String[] s_types = new String[]{"void", "sidl_bool", "char", "struct sidl_dcomplex", "double", "struct sidl_fcomplex", "float", "int32_t", "int64_t", "void*", "char*"};
    private static final String[] s_array_types = new String[]{null, "struct sidl_bool__array*", "struct sidl_char__array*", "struct sidl_dcomplex__array*", "struct sidl_double__array*", "struct sidl_fcomplex__array*", "struct sidl_float__array*", "struct sidl_int__array*", "struct sidl_long__array*", "struct sidl_opaque__array*", "struct sidl_string__array*"};
    private static String s_exceptionType = null;
    private static String s_exceptionObjPtr = null;
    private static String s_self = "self";

    public static String getFullSelfDecl(SymbolID id) {
        return C.getSymbolName(id) + " " + s_self;
    }

    public static String getHeaderFile(SymbolID id) {
        return C.getSymbolName(id) + ".h";
    }

    public static String getStubFile(SymbolID id) {
        return C.getSymbolName(id) + "_Stub.c";
    }

    public static String getSkelFile(SymbolID id) {
        return C.getSymbolName(id) + "_Skel.c";
    }

    public static String getImplHeaderFile(SymbolID id) {
        return C.getSymbolName(id) + "_Impl.h";
    }

    public static String getImplSourceFile(SymbolID id) {
        return C.getSymbolName(id) + "_Impl.c";
    }

    public static String getDataName(SymbolID id) {
        return "struct " + C.getSymbolName(id) + "__data";
    }

    public static String getDataGetName(SymbolID id) {
        return C.getSymbolName(id) + "__get_data";
    }

    public static String getDataSetName(SymbolID id) {
        return C.getSymbolName(id) + "__set_data";
    }

    public static String getPrivateDestructor(SymbolID id) {
        return C.getSymbolName(id) + "__delete";
    }

    public static String getSymbolObjectPtr(SymbolID id) {
        return C.getObjectStructName(id) + "*";
    }

    public static String getSymbolName(SymbolID id) {
        return id.getFullName().replace('.', '_');
    }

    public static String getEnumName(SymbolID id) {
        return "enum " + C.getSymbolName(id) + "__enum";
    }

    public static String getObjectName(SymbolID id) {
        return C.getSymbolName(id);
    }

    public static String getObjectStructName(SymbolID id) {
        return "struct " + C.getObjectName(id) + "__object";
    }

    public static String getSetEPVName(SymbolID id) {
        return C.getSymbolName(id) + "__set_epv";
    }

    public static String getSetSEPVName(SymbolID id) {
        return C.getSymbolName(id) + "__set_sepv";
    }

    public static String getMethodImplName(SymbolID id, String methodName) {
        return "impl_" + C.getSymbolName(id) + '_' + methodName;
    }

    public static String getMethodSkelName(SymbolID id, Method method) {
        return method.hasArrayOrderSpec() ? "skel_" + C.getSymbolName(id) + '_' + method.getLongMethodName() : C.getMethodImplName(id, method.getLongMethodName());
    }

    public static String getFullMethodName(SymbolID id, Method method) {
        return C.getSymbolName(id) + "_" + method.getLongMethodName();
    }

    public static String getFullMethodName(SymbolID id, String methodName) {
        return C.getSymbolName(id) + "_" + methodName;
    }

    public static String getEnsureArray(Type arrayType) {
        switch (arrayType.getDetailedType()) {
            case 12: 
            case 13: {
                return ArrayMethods.generateEnsureName(arrayType.getSymbolID());
            }
            case 11: {
                return "sidl_int__array_ensure";
            }
        }
        return "sidl_" + arrayType.getTypeString() + "__array_ensure";
    }

    public static String getDelRefArray(Type arrayType) {
        switch (arrayType.getDetailedType()) {
            case 12: 
            case 13: {
                return ArrayMethods.generateDelRefName(arrayType.getSymbolID());
            }
            case 11: {
                return "sidl_int__array_deleteRef";
            }
        }
        return "sidl_" + arrayType.getTypeString() + "__array_deleteRef";
    }

    public static String getExceptionType() {
        return s_exceptionType;
    }

    public static Method getExecMethod() throws CodeGenerationException {
        Method m_exec = new Method();
        String[] cmmnt = new String[]{"Exec method for rmi and reflexity."};
        m_exec.setMethodName("_exec");
        m_exec.setComment(new Comment(cmmnt));
        m_exec.setReturnType(new Type(0));
        Argument a = new Argument(false, 0, new Type(10), "methodName");
        m_exec.addArgument(a);
        Symbol tmpSym = Utilities.lookupSymbol("sidl.io.Deserializer");
        a = new Argument(false, 0, new Type(tmpSym.getSymbolID()), "inArgs");
        m_exec.addArgument(a);
        tmpSym = Utilities.lookupSymbol("sidl.io.Serializer");
        a = new Argument(false, 0, new Type(tmpSym.getSymbolID()), "outArgs");
        m_exec.addArgument(a);
        return m_exec;
    }

    public static Method getSExecMethod() throws CodeGenerationException {
        Method m_exec = new Method();
        String[] cmmnt = new String[]{"static Exec method for reflexity."};
        m_exec.setMethodName("_sexec");
        m_exec.setComment(new Comment(cmmnt));
        m_exec.setDefinitionModifier(3);
        m_exec.setReturnType(new Type(0));
        Argument a = new Argument(false, 0, new Type(10), "methodName");
        m_exec.addArgument(a);
        Symbol tmpSym = Utilities.lookupSymbol("sidl.io.Deserializer");
        a = new Argument(false, 0, new Type(tmpSym.getSymbolID()), "inArgs");
        m_exec.addArgument(a);
        tmpSym = Utilities.lookupSymbol("sidl.io.Serializer");
        a = new Argument(false, 0, new Type(tmpSym.getSymbolID()), "outArgs");
        m_exec.addArgument(a);
        return m_exec;
    }

    public static void generateArgumentList(LanguageWriterForC writer, String self, boolean is_interface, SymbolID id, Method method, boolean in_signature, boolean add_type, boolean obj_ptr, boolean do_throws, boolean do_return, boolean do_indices, boolean do_rarrays) throws CodeGenerationException {
        String excVar = do_throws ? "_ex" : "";
        C.generateArgumentList(writer, self, is_interface, id, method, in_signature, add_type, obj_ptr, excVar, do_return, do_indices, do_rarrays);
    }

    public static void generateArgumentList(LanguageWriterForC writer, String self, boolean is_interface, SymbolID id, Method method, boolean in_signature, boolean add_type, boolean obj_ptr, String exc_var, boolean do_return, boolean do_indices, boolean do_rarrays) throws CodeGenerationException {
        boolean doThrows = !exc_var.equals("") && !method.getThrows().isEmpty();
        String excVar = doThrows ? exc_var : "";
        Type returnType = do_return ? method.getReturnType() : null;
        ArrayList args = null;
        args = do_indices ? method.getArgumentListWithIndices() : method.getArgumentListWithOutIndices();
        String m_self = in_signature ? (add_type ? (obj_ptr ? C.getSymbolObjectPtr(id) + " " + self : C.getObjectName(id) + " " + self) : self) : (is_interface ? self + "->d_object" : s_self);
        C.generateArguments(writer, m_self, (List)args, method.isStatic(), excVar, returnType, add_type, obj_ptr, do_rarrays);
    }

    public static void generateArguments(LanguageWriterForC writer, String self, List args, boolean isStatic, boolean doThrows, Type returnType, boolean addType, boolean objPtr, boolean doRaw) throws CodeGenerationException {
        String excVar = doThrows ? "_ex" : "";
        C.generateArguments(writer, self, args, isStatic, excVar, returnType, addType, objPtr, doRaw);
    }

    public static void generateArguments(LanguageWriterForC writer, String self, List args, boolean isStatic, String excVar, Type returnType, boolean addType, boolean objPtr, boolean doRaw) throws CodeGenerationException {
        boolean doReturn;
        boolean doThrows = excVar != null && !excVar.equals("");
        boolean bl = doReturn = returnType != null && returnType.getType() != 0;
        if (!isStatic) {
            if (addType) {
                writer.print("/* in */ ");
            }
            writer.print(self);
            if (args.size() > 0 || doThrows || doReturn) {
                writer.println(",");
            }
        } else if (addType && args.size() == 0 && !doThrows && !doReturn) {
            writer.print("void");
        }
        Iterator a = args.iterator();
        while (a.hasNext()) {
            boolean isRaw;
            Argument arg = (Argument)a.next();
            boolean bl2 = isRaw = doRaw && arg.getType().isRarray();
            if (addType) {
                writer.print("/* " + arg.getModeString() + " */ ");
                writer.print(IOR.getArgumentWithFormal(arg, objPtr, isRaw, false));
            } else if (isRaw) {
                if (arg.getMode() == 1) {
                    writer.print("&");
                }
                writer.print(arg.getFormalName() + RAW_ARRAY_EXT);
            } else {
                writer.print(arg.getFormalName());
            }
            if (!a.hasNext() && !doThrows && !doReturn) continue;
            writer.println(",");
        }
        if (doThrows) {
            if (addType) {
                writer.print("/* out */ ");
                if (objPtr) {
                    writer.print(s_exceptionObjPtr + " *");
                } else {
                    writer.print(s_exceptionType + " *");
                }
            }
            writer.print(excVar);
            if (doReturn) {
                writer.println(",");
            }
        }
        if (doReturn) {
            if (addType) {
                writer.print("/* out */ ");
                writer.print(IOR.getReturnString(returnType, objPtr, false));
            }
            writer.print(" _result");
        }
    }

    static {
        SymbolID id = new SymbolID(BabelConfiguration.getBaseExceptionType(), new Version());
        s_exceptionType = C.getObjectName(id);
        s_exceptionObjPtr = C.getSymbolObjectPtr(id);
    }
}

