/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.FileListener;
import gov.llnl.babel.backend.writers.ChangeWriter;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class FileManager {
    private static FileManager s_instance = null;
    private boolean d_package_dirs = true;
    private boolean d_glue_dirs = false;
    private boolean d_language_dir;
    private File d_root_dir;
    private File d_vpath_dir;
    private Collection d_listeners = new LinkedList();

    protected FileManager() {
    }

    public static FileManager getInstance() {
        if (s_instance == null) {
            s_instance = new FileManager();
        }
        return s_instance;
    }

    public void addListener(FileListener listener) {
        this.d_listeners.add(listener);
    }

    public void removeListener(FileListener listener) {
        this.d_listeners.remove(listener);
    }

    private void notifyListeners(SymbolID id, int type, String role, String dir, String name) {
        Iterator i = this.d_listeners.iterator();
        while (i.hasNext()) {
            FileListener l = (FileListener)i.next();
            l.newFile(id, type, role, dir, name);
        }
    }

    public static void setInstance(FileManager instance) {
        s_instance = instance;
    }

    public boolean getJavaStylePackageGeneration() {
        return this.d_package_dirs;
    }

    public void setJavaStylePackageGeneration(boolean java_style) {
        this.d_package_dirs = java_style;
    }

    public void setGlueSubdirGeneration(boolean glue_dir) {
        this.d_glue_dirs = glue_dir;
    }

    public boolean getGlueSubdirGeneration() {
        return this.d_glue_dirs;
    }

    public void setVPathDirectory(String directory) throws CodeGenerationException {
        if (directory == null || directory.equals("") || directory.equals(".")) {
            this.d_vpath_dir = null;
            return;
        }
        File d = new File(directory);
        if (d.isFile()) {
            throw new CodeGenerationException("'" + directory + "' is a file, not a directory.");
        }
        if (!d.isDirectory()) {
            throw new CodeGenerationException("'" + directory + "' not found.");
        }
        this.d_vpath_dir = d;
    }

    public void setFileGenerationRootDirectory(String directory) throws CodeGenerationException {
        if (directory == null || directory.equals("") || directory.equals(".")) {
            this.d_root_dir = null;
            return;
        }
        File d = new File(directory);
        if (d.isFile()) {
            throw new CodeGenerationException("'" + directory + "' is a file, not a directory.");
        }
        if (!d.isDirectory() && !d.mkdirs()) {
            throw new CodeGenerationException("'" + directory + "' can neither be found nor created as a directory.");
        }
        this.d_root_dir = d;
    }

    public PrintWriter createFile(SymbolID id, int type, String groupname, String filename) throws CodeGenerationException {
        return new PrintWriter(this.createWriter(id, type, groupname, filename));
    }

    public Writer createWriter(SymbolID id, int type, String groupname, String filename) throws CodeGenerationException {
        if (id == null || groupname == null || filename == null || filename.equals("")) {
            throw new CodeGenerationException("Non-null, non-empty input parameters required.");
        }
        File dir = this.expandDirectory(id, type);
        BabelConfiguration babel_config = BabelConfiguration.getInstance();
        if (babel_config.makeLanguageSubdir()) {
            dir = this.expandLanguageSubdir(id, dir, babel_config.getTargetLanguage());
        }
        if (!(!this.d_glue_dirs || groupname.startsWith("IMPL") || groupname.startsWith("JAVA") || groupname.equals("STUBJAVA") || groupname.equals("PYMOD_SRCS") || groupname.startsWith("PYTHONSRC") || groupname.startsWith("PYTHONADMIN"))) {
            dir = this.expandGlueSubdir(id, dir);
        }
        String dirname = "";
        if (dir != null && !dir.toString().equals("")) {
            dir.mkdirs();
            dirname = dir.toString() + File.separator;
        }
        this.notifyListeners(id, type, groupname, dirname, filename);
        Writer writer = null;
        try {
            writer = ChangeWriter.createWriter(filename, dirname);
        }
        catch (IOException ex) {
            throw new CodeGenerationException(ex.getMessage());
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeSplicer getCodeSplicer(SymbolID id, int type, String file) throws IOException {
        File vpath_dir = this.expandVPathDirectory(id, type);
        File target_dir = this.expandDirectory(id, type);
        BabelConfiguration babel_config = BabelConfiguration.getInstance();
        if (babel_config.makeLanguageSubdir()) {
            target_dir = this.expandLanguageSubdir(id, target_dir, babel_config.getTargetLanguage());
        }
        String path = "";
        String vpath = ".";
        CodeSplicer splicer = null;
        FileReader reader = null;
        if (target_dir != null && !target_dir.toString().equals("")) {
            path = path + target_dir.toString() + File.separator;
        }
        path = path + file;
        if (vpath_dir == null || vpath_dir.toString().equals("") || vpath_dir.toString().equals(".")) {
            vpath = path;
        } else {
            vpath = vpath_dir.toString() + File.separator + file;
            File f = new File(vpath);
            if (!(f.exists() && f.isFile() && f.canRead())) {
                vpath = path;
            }
        }
        try {
            reader = new FileReader(vpath);
            splicer = new CodeSplicer(new BufferedReader(reader), vpath, path);
        }
        catch (FileNotFoundException ex) {
            splicer = new CodeSplicer();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return splicer;
    }

    public File expandDirectory(SymbolID id, int type) {
        StringBuffer path = new StringBuffer();
        if (this.d_root_dir != null) {
            path.append(this.d_root_dir.getPath()).append(File.separator);
        }
        if (id != null && this.d_package_dirs) {
            String pkg = null;
            pkg = type == 14 ? id.getFullName() : SymbolUtilities.getParentPackage(id.getFullName());
            path.append(pkg.replace('.', File.separatorChar)).append(File.separator);
        }
        if (path.length() == 0) {
            return null;
        }
        return new File(path.toString());
    }

    public File expandLanguageSubdir(SymbolID id, File file, String language) {
        StringBuffer path = new StringBuffer();
        if (file != null) {
            path.append(file.getPath());
        }
        if (id != null) {
            if (path.length() > 0) {
                path.append(File.separator);
            }
            path.append(language);
        }
        if (path.length() == 0) {
            return null;
        }
        return new File(path.toString());
    }

    public File expandGlueSubdir(SymbolID id, File file) {
        StringBuffer path = new StringBuffer();
        if (file != null) {
            path.append(file.getPath());
        }
        if (id != null && this.d_glue_dirs) {
            if (path.length() > 0) {
                path.append(File.separator);
            }
            path.append("glue");
        }
        if (path.length() == 0) {
            return null;
        }
        return new File(path.toString());
    }

    public File expandVPathDirectory(SymbolID id, int type) {
        File f;
        if (this.d_vpath_dir == null || this.d_vpath_dir.equals(this.d_root_dir)) {
            return null;
        }
        String path = this.d_vpath_dir.getPath() + File.separator;
        if (id != null && this.d_package_dirs) {
            String pkg = null;
            pkg = type == 14 ? id.getFullName() : SymbolUtilities.getParentPackage(id.getFullName());
            path = path + pkg.replace('.', File.separatorChar) + File.separator;
        }
        if ((f = new File(path)).isDirectory()) {
            return f;
        }
        return null;
    }
}

