/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.eclipse.swt.graphics.Color;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class UpSpeedItem
extends CoreTableColumn
implements TableCellAddedListener,
ParameterListener {
    private static final String CONFIG_ID = "StartStopManager_iMinSpeedForActiveSeeding";
    private int iMinActiveSpeed;

    public UpSpeedItem(String sTableID) {
        super("upspeed", 2, -2, 70, sTableID);
        this.setRefreshInterval(-2);
        this.iMinActiveSpeed = COConfigurationManager.getIntParameter(CONFIG_ID);
        COConfigurationManager.addParameterListener(CONFIG_ID, this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        COConfigurationManager.removeParameterListener(CONFIG_ID, this);
    }

    public void cellAdded(TableCell cell) {
        cell.addRefreshListener(new RefreshListener());
    }

    public void parameterChanged(String parameterName) {
        this.iMinActiveSpeed = COConfigurationManager.getIntParameter(CONFIG_ID);
    }

    public class RefreshListener
    implements TableCellRefreshListener {
        private int iLastState;

        public void refresh(TableCell cell) {
            long value;
            int iState;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                iState = -1;
                value = 0L;
            } else {
                iState = dm.getState();
                value = dm.getStats().getUploadAverage();
            }
            if (!cell.setSortValue(value) && cell.isValid() && iState == this.iLastState) {
                return;
            }
            if (cell.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(value)) || iState != this.iLastState || !cell.isValid()) {
                this.changeColor(cell, value, iState);
            }
        }

        private void changeColor(TableCell cell) {
            try {
                DownloadManager dm = (DownloadManager)cell.getDataSource();
                if (dm == null) {
                    return;
                }
                this.changeColor(cell, dm.getStats().getDownloadAverage(), dm.getState());
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }

        private void changeColor(TableCell cell, long iSpeed, int iState) {
            try {
                Color newFG = iSpeed < (long)UpSpeedItem.this.iMinActiveSpeed && iState == 60 ? Colors.colorWarning : null;
                ((TableCellCore)cell).setForeground(newFG);
                this.iLastState = iState;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

