/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import java.util.StringTokenizer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GCStringPrinter {
    public static boolean printString(GC gc, String string, Rectangle printArea) {
        int x0 = printArea.x;
        int y0 = printArea.y;
        int height = 0;
        Rectangle oldClipping = gc.getClipping();
        gc.setClipping(printArea);
        String sTabsReplaced = string.replaceAll("\t", "  ");
        StringBuffer outputLine = new StringBuffer();
        StringTokenizer stLine = new StringTokenizer(sTabsReplaced, "\n");
        while (stLine.hasMoreElements()) {
            int iLineHeight = 0;
            String sLine = stLine.nextToken();
            if (gc.stringExtent((String)sLine).x > printArea.width) {
                StringTokenizer stWord = new StringTokenizer(sLine, " ");
                String space = "";
                int iLineLength = 0;
                iLineHeight = gc.stringExtent((String)" ").y;
                while (stWord.hasMoreElements()) {
                    String word = stWord.nextToken();
                    Point ptWordSize = gc.stringExtent(String.valueOf(word) + " ");
                    if ((iLineLength += ptWordSize.x) > printArea.width) {
                        iLineLength = ptWordSize.x;
                        height += iLineHeight;
                        iLineHeight = ptWordSize.y;
                        space = "\n";
                    }
                    if (iLineHeight < ptWordSize.y) {
                        iLineHeight = ptWordSize.y;
                    }
                    outputLine.append(String.valueOf(space) + word);
                    space = " ";
                }
            } else {
                outputLine.append(sLine);
                iLineHeight = gc.stringExtent((String)sLine).y;
            }
            outputLine.append("\n");
            height += iLineHeight;
        }
        String sOutputLine = outputLine.toString();
        gc.drawText(sOutputLine, x0, y0, true);
        gc.setClipping(oldClipping);
        return height <= printArea.height;
    }

    private static int getAdvanceWidth(GC gc, String s) {
        int result = 0;
        int i = 0;
        while (i < s.length()) {
            result += gc.getAdvanceWidth(s.charAt(i)) - 1;
            ++i;
        }
        return result;
    }
}

