/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.sharing.progress;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.animations.Animator;
import org.gudy.azureus2.ui.swt.animations.shell.AnimableShell;
import org.gudy.azureus2.ui.swt.animations.shell.LinearAnimator;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.shells.PopupShell;

public class ProgressWindow
implements ShareManagerListener {
    protected progressDialog dialog;
    protected Display display = MainWindow.getWindow().getDisplay();
    protected StyledText tasks;
    protected ProgressBar progress;
    protected Button cancel_button;
    protected boolean shell_opened;

    public ProgressWindow() {
        if (this.display.isDisposed()) {
            return;
        }
        try {
            this.dialog = new progressDialog(this.display);
            PluginInitializer.getDefaultInterface().getShareManager().addListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
    }

    public void resourceAdded(ShareResource resource) {
        this.reportCurrentTask("Resource added: " + resource.getName());
    }

    public void resourceModified(ShareResource resource) {
        this.reportCurrentTask("Resource modified: " + resource.getName());
    }

    public void resourceDeleted(ShareResource resource) {
        this.reportCurrentTask("Resource deleted: " + resource.getName());
    }

    public void reportProgress(final int percent_complete) {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (ProgressWindow.this.progress != null && !ProgressWindow.this.progress.isDisposed()) {
                        ProgressWindow.this.cancel_button.setEnabled(percent_complete < 100);
                        ProgressWindow.this.progress.setSelection(percent_complete);
                    }
                }
            });
        }
    }

    public void reportCurrentTask(final String task_description) {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (ProgressWindow.this.tasks != null && !ProgressWindow.this.tasks.isDisposed()) {
                        ProgressWindow.this.dialog.showPanel();
                        ProgressWindow.this.tasks.append(String.valueOf(task_description) + Text.DELIMITER);
                        int lines = ProgressWindow.this.tasks.getLineCount();
                        ProgressWindow.this.tasks.setTopIndex(lines - 1);
                    }
                }
            });
        }
    }

    protected class progressDialog
    extends PopupShell
    implements AnimableShell {
        Animator currentAnimator;
        int x0;
        int y0;
        int x1;
        int y1;
        boolean isAnimated;
        boolean hideAfter;

        protected progressDialog(Display dialog_display) {
            super(dialog_display);
            if (dialog_display.isDisposed()) {
                return;
            }
            this.shell.setText(MessageText.getString("sharing.progress.title"));
            ProgressWindow.this.tasks = new StyledText((Composite)this.shell, 2824);
            ProgressWindow.this.tasks.setBackground(dialog_display.getSystemColor(1));
            ProgressWindow.this.progress = new ProgressBar((Composite)this.shell, 0);
            ProgressWindow.this.progress.setMinimum(0);
            ProgressWindow.this.progress.setMaximum(100);
            Button hide_button = new Button((Composite)this.shell, 8);
            hide_button.setText(MessageText.getString("sharing.progress.hide"));
            ProgressWindow.this.cancel_button = new Button((Composite)this.shell, 8);
            ProgressWindow.this.cancel_button.setText(MessageText.getString("sharing.progress.cancel"));
            ProgressWindow.this.cancel_button.setEnabled(false);
            FormData formData = new FormData();
            formData.right = new FormAttachment(100, -5);
            formData.bottom = new FormAttachment(100, -10);
            hide_button.setLayoutData((Object)formData);
            formData = new FormData();
            formData.right = new FormAttachment((Control)hide_button, -5);
            formData.bottom = new FormAttachment(100, -10);
            ProgressWindow.this.cancel_button.setLayoutData((Object)formData);
            formData = new FormData();
            formData.right = new FormAttachment((Control)ProgressWindow.this.cancel_button, -5);
            formData.left = new FormAttachment(0, 50);
            formData.bottom = new FormAttachment(100, -10);
            ProgressWindow.this.progress.setLayoutData((Object)formData);
            formData = new FormData();
            formData.right = new FormAttachment(100, -5);
            formData.bottom = new FormAttachment(100, -50);
            formData.top = new FormAttachment(0, 5);
            formData.left = new FormAttachment(0, 5);
            ProgressWindow.this.tasks.setLayoutData((Object)formData);
            this.layout();
            ProgressWindow.this.cancel_button.addListener(13, new Listener(this){
                final /* synthetic */ progressDialog this$1;
                {
                    this.this$1 = progressDialog2;
                }

                public void handleEvent(Event e) {
                    try {
                        progressDialog.access$1((progressDialog)this.this$1).cancel_button.setEnabled(false);
                        PluginInitializer.getDefaultInterface().getShareManager().cancelOperation();
                    }
                    catch (ShareException f) {
                        Debug.printStackTrace(f);
                    }
                }
            });
            hide_button.addListener(13, new Listener(this){
                final /* synthetic */ progressDialog this$1;
                {
                    this.this$1 = progressDialog2;
                }

                public void handleEvent(Event e) {
                    this.this$1.hidePanel();
                }
            });
            this.shell.setDefaultButton(hide_button);
            this.shell.addListener(31, new Listener(this){
                final /* synthetic */ progressDialog this$1;
                {
                    this.this$1 = progressDialog2;
                }

                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        this.this$1.hidePanel();
                    }
                }
            });
            Rectangle bounds = dialog_display.getClientArea();
            this.x0 = bounds.x + bounds.width - 255;
            this.x1 = bounds.x + bounds.width;
            this.y0 = bounds.y + bounds.height;
            this.y1 = bounds.y + bounds.height - 155;
            this.shell.setLocation(this.x0, this.y0);
        }

        protected void hidePanel() {
            this.currentAnimator = new LinearAnimator(this, new Point(this.x0, this.y1), new Point(this.x1, this.y1), 15, 30);
            this.currentAnimator.start();
            this.hideAfter = true;
        }

        protected void showPanel() {
            boolean animate = false;
            if (!ProgressWindow.this.shell_opened) {
                ProgressWindow.this.shell_opened = true;
                this.shell.open();
                animate = true;
            }
            this.shell.moveAbove((Control)MainWindow.getWindow().getShell());
            if (!this.shell.isVisible()) {
                this.shell.setVisible(true);
                animate = true;
            }
            if (animate && this.currentAnimator == null) {
                this.currentAnimator = new LinearAnimator(this, new Point(this.x0, this.y0), new Point(this.x0, this.y1), 15, 30);
                this.currentAnimator.start();
            }
        }

        public void animationEnded(Animator source) {
            if (source != this.currentAnimator) {
                return;
            }
            this.isAnimated = false;
            this.currentAnimator = null;
            if (this.hideAfter) {
                this.hideAfter = false;
                if (ProgressWindow.this.display == null || ProgressWindow.this.display.isDisposed()) {
                    return;
                }
                ProgressWindow.this.display.asyncExec((Runnable)new AERunnable(this){
                    final /* synthetic */ progressDialog this$1;
                    {
                        this.this$1 = progressDialog2;
                    }

                    public void runSupport() {
                        progressDialog.access$0(this.this$1).setVisible(false);
                    }
                });
            }
        }

        public void animationStarted(Animator source) {
        }

        public Shell getShell() {
            return this.shell;
        }

        public void reportPercent(int percent) {
        }

        static /* synthetic */ Shell access$0(progressDialog progressDialog2) {
            return progressDialog2.shell;
        }

        static /* synthetic */ ProgressWindow access$1(progressDialog progressDialog2) {
            return progressDialog2.ProgressWindow.this;
        }
    }
}

