/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCoreListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Initializer;

public class SplashWindow
implements AzureusCoreListener {
    Display display;
    Initializer initializer;
    Shell splash;
    Label currentTask;
    ProgressBar percentDone;
    Color white;

    private SplashWindow(Display display, Initializer initializer) {
        this.display = display;
        this.initializer = initializer;
        this.white = new Color((Device)display, 255, 255, 255);
        this.splash = new Shell(display, 0);
        this.splash.setText("Azureus");
        if (!Constants.isOSX) {
            this.splash.setImage(ImageRepository.getImage("azureus"));
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.splash.setLayout((Layout)layout);
        Label label = new Label((Composite)this.splash, 0);
        label.setImage(ImageRepository.getImage("azureus_splash"));
        this.currentTask = new Label((Composite)this.splash, 2048);
        GridData gridData = new GridData(768);
        this.currentTask.setLayoutData((Object)gridData);
        this.currentTask.setBackground(this.white);
        this.currentTask.setText("(: Azureus :)");
        this.percentDone = new ProgressBar((Composite)this.splash, 256);
        this.percentDone.setMinimum(0);
        this.percentDone.setMaximum(100);
        gridData = new GridData(768);
        this.percentDone.setLayoutData((Object)gridData);
        this.splash.pack();
        this.splash.layout();
        Utils.centreWindow(this.splash);
        this.splash.open();
        initializer.addListener(this);
    }

    public static void create(final Display display, final Initializer initializer) {
        if (display != null && !display.isDisposed()) {
            display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    new SplashWindow(display, initializer, null);
                }
            });
        }
    }

    private void closeSplash() {
        if (this.initializer != null) {
            this.initializer.removeListener(this);
        }
        if (this.splash != null && !this.splash.isDisposed()) {
            this.splash.dispose();
        }
        if (this.white != null && !this.white.isDisposed()) {
            this.white.dispose();
        }
    }

    public void reportCurrentTask(final String task) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (SplashWindow.this.currentTask == null || SplashWindow.this.currentTask.isDisposed()) {
                    return;
                }
                SplashWindow.this.currentTask.setText(task);
            }
        });
    }

    public void reportPercent(final int percent) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (SplashWindow.this.percentDone == null || SplashWindow.this.percentDone.isDisposed()) {
                    return;
                }
                SplashWindow.this.percentDone.setSelection(percent);
                if (percent > 100) {
                    SplashWindow.this.closeSplash();
                }
            }
        });
    }

    /* synthetic */ SplashWindow(Display display, Initializer initializer, SplashWindow splashWindow) {
        this(display, initializer);
    }
}

