/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;

public class StringListParameter
extends Parameter {
    Combo list;
    final String name;
    final String default_value;

    public StringListParameter(Composite composite, String _name, String defaultValue, String[] labels, final String[] values) {
        this.name = _name;
        this.default_value = defaultValue;
        if (labels.length != values.length) {
            return;
        }
        String value = COConfigurationManager.getStringParameter(this.name, defaultValue);
        int index = this.findIndex(value, values);
        this.list = new Combo(composite, 12);
        int i = 0;
        while (i < labels.length) {
            this.list.add(labels[i]);
            ++i;
        }
        this.list.select(index);
        this.list.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                COConfigurationManager.setParameter(StringListParameter.this.name, values[StringListParameter.this.list.getSelectionIndex()]);
                if (StringListParameter.this.change_listeners != null) {
                    int i = 0;
                    while (i < StringListParameter.this.change_listeners.size()) {
                        ((ParameterChangeListener)StringListParameter.this.change_listeners.get(i)).parameterChanged(StringListParameter.this, false);
                        ++i;
                    }
                }
            }
        });
    }

    private int findIndex(String value, String[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(value)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void setLayoutData(Object layoutData) {
        this.list.setLayoutData(layoutData);
    }

    public Control getControl() {
        return this.list;
    }

    public String getValue() {
        return COConfigurationManager.getStringParameter(this.name, this.default_value);
    }
}

