/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import sun.misc.BASE64Decoder;

public class TRTrackerServerProcessorTCP
extends TRTrackerServerProcessor {
    protected static final int SOCKET_TIMEOUT = 5000;
    protected static final char CR = '\r';
    protected static final char FF = '\n';
    protected static final String NL = "\r\n";
    protected static final byte[] HTTP_RESPONSE_START = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nServer: Azureus 2.2.0.2\r\nConnection: close\r\nContent-Length: ".getBytes();
    protected static final byte[] HTTP_RESPONSE_END_GZIP = "\r\nContent-Encoding: gzip\r\n\r\n".getBytes();
    protected static final byte[] HTTP_RESPONSE_END_NOGZIP = "\r\n\r\n".getBytes();
    protected TRTrackerServerTCP server;
    protected Socket socket;
    protected int timeout_ticks = 1;
    protected boolean disable_timeouts = false;
    protected String current_request;

    protected TRTrackerServerProcessorTCP(TRTrackerServerTCP _server, Socket _socket) {
        this.server = _server;
        this.socket = _socket;
    }

    public void runSupport() {
        try {
            this.setTaskState("entry");
            try {
                this.socket.setSoTimeout(5000);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            String header_plus = "";
            this.setTaskState("reading header");
            try {
                String lowercase_header;
                String actual_header;
                InputStream is = this.socket.getInputStream();
                byte[] buffer = new byte[1024];
                while (header_plus.length() < 4096) {
                    int len = is.read(buffer);
                    if (len == -1 || (header_plus = String.valueOf(header_plus) + new String(buffer, 0, len, "ISO-8859-1")).endsWith("\r\n\r\n") || header_plus.indexOf("\r\n\r\n") != -1) break;
                }
                if (LGLogger.isLoggingOn()) {
                    String log_str = header_plus;
                    int pos = log_str.indexOf(NL);
                    if (pos != -1) {
                        log_str = log_str.substring(0, pos);
                    }
                    LGLogger.log(0, 0, 0, "Tracker Server: received header '" + log_str + "'");
                }
                InputStream post_is = null;
                File post_file = null;
                boolean head = false;
                if (header_plus.startsWith("GET ")) {
                    this.timeout_ticks = 1;
                    actual_header = header_plus;
                    lowercase_header = actual_header.toLowerCase();
                } else if (header_plus.startsWith("HEAD ")) {
                    this.timeout_ticks = 1;
                    actual_header = header_plus;
                    lowercase_header = actual_header.toLowerCase();
                    head = true;
                } else if (header_plus.startsWith("POST ")) {
                    OutputStream data_os;
                    this.timeout_ticks = TRTrackerServerTCP.PROCESSING_POST_MULTIPLIER;
                    if (this.timeout_ticks == 0) {
                        this.disable_timeouts = true;
                    }
                    this.setTaskState("reading content");
                    int header_end = header_plus.indexOf("\r\n\r\n");
                    if (header_end == -1) {
                        throw new TRTrackerServerException("header truncated");
                    }
                    actual_header = header_plus.substring(0, header_end + 4);
                    lowercase_header = actual_header.toLowerCase();
                    int cl_start = lowercase_header.indexOf("content-length:");
                    if (cl_start == -1) {
                        throw new TRTrackerServerException("header Content-Length start missing");
                    }
                    int cl_end = actual_header.indexOf(NL, cl_start);
                    if (cl_end == -1) {
                        throw new TRTrackerServerException("header Content-Length end missing");
                    }
                    int content_length = Integer.parseInt(actual_header.substring(cl_start + 15, cl_end).trim());
                    ByteArrayOutputStream baos = null;
                    FileOutputStream fos = null;
                    if (content_length <= 262144) {
                        baos = new ByteArrayOutputStream();
                        data_os = baos;
                    } else {
                        post_file = AETemporaryFileHandler.createTempFile("AZU", null);
                        post_file.deleteOnExit();
                        fos = new FileOutputStream(post_file);
                        data_os = fos;
                    }
                    int rem = header_plus.length() - (header_end + 4);
                    if (rem > 0) {
                        content_length -= rem;
                        data_os.write(header_plus.substring(header_plus.length() - rem).getBytes("ISO-8859-1"));
                    }
                    while (content_length > 0) {
                        int len = is.read(buffer);
                        if (len < 0) {
                            throw new TRTrackerServerException("premature end of input stream");
                        }
                        data_os.write(buffer, 0, len);
                        content_length -= len;
                    }
                    if (baos != null) {
                        post_is = new ByteArrayInputStream(baos.toByteArray());
                    } else {
                        fos.close();
                        post_is = new BufferedInputStream(new FileInputStream(post_file), 262144);
                    }
                } else {
                    throw new TRTrackerServerException("header doesn't start with GET or POST ('" + (header_plus.length() > 256 ? header_plus.substring(0, 256) : header_plus) + "')");
                }
                this.setTaskState("processing request");
                this.current_request = actual_header;
                try {
                    String url;
                    int pos;
                    if (post_is == null) {
                        post_is = new ByteArrayInputStream(new byte[0]);
                    }
                    if ((pos = (url = actual_header.substring(4).trim()).indexOf(" ")) == -1) {
                        throw new TRTrackerServerException("header doesn't have space in right place");
                    }
                    url = url.substring(0, pos);
                    if (head) {
                        ByteArrayOutputStream head_response = new ByteArrayOutputStream(4096);
                        this.processRequest(actual_header, lowercase_header, url, this.socket.getInetAddress().getHostAddress(), post_is, head_response);
                        byte[] head_data = head_response.toByteArray();
                        int header_length = head_data.length;
                        int i = 3;
                        while (i < head_data.length) {
                            if (head_data[i - 3] == 13 && head_data[i - 2] == 10 && head_data[i - 1] == 13 && head_data[i] == 10) {
                                header_length = i + 1;
                                break;
                            }
                            ++i;
                        }
                        this.setTaskState("writing head response");
                        this.socket.getOutputStream().write(head_data, 0, header_length);
                        this.socket.getOutputStream().flush();
                    } else {
                        this.processRequest(actual_header, lowercase_header, url, this.socket.getInetAddress().getHostAddress(), post_is, this.socket.getOutputStream());
                    }
                }
                finally {
                    if (post_is != null) {
                        post_is.close();
                    }
                    if (post_file != null) {
                        post_file.delete();
                    }
                }
            }
            catch (SocketTimeoutException is) {
            }
            finally {
            }
        }
        finally {
            this.setTaskState("final socket close");
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void interruptTask() {
        try {
            if (!this.disable_timeouts) {
                --this.timeout_ticks;
                if (this.timeout_ticks <= 0) {
                    Debug.out("Tracker task interrupted in state '" + this.getTaskState() + "' : processing time limit exceeded");
                    this.socket.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void processRequest(String input_header, String lowercase_input_header, String url_path, String client_ip_address, InputStream is, OutputStream os) throws IOException {
        String str = url_path;
        try {
            Map root = null;
            TRTrackerServerTorrentImpl specific_torrent = null;
            boolean gzip_reply = false;
            try {
                int e_pos;
                int request_type;
                if (str.startsWith("/announce?")) {
                    request_type = 1;
                    str = str.substring(10);
                } else if (str.startsWith("/scrape?")) {
                    request_type = 2;
                    str = str.substring(8);
                } else if (str.equals("/scrape")) {
                    request_type = 3;
                    str = "";
                } else {
                    this.setTaskState("external request");
                    this.disable_timeouts = true;
                    if (!this.doAuthentication(url_path, input_header, os, false)) {
                        this.setTaskState("final os flush");
                        os.flush();
                        return;
                    }
                    if (this.handleExternalRequest(client_ip_address, str, input_header, is, os)) {
                        this.setTaskState("final os flush");
                        os.flush();
                        return;
                    }
                    os.write("HTTP/1.1 404 Not Found\r\n\r\n".getBytes());
                    os.flush();
                    this.setTaskState("final os flush");
                    os.flush();
                    return;
                }
                if (!this.doAuthentication(url_path, input_header, os, true)) {
                    this.setTaskState("final os flush");
                    os.flush();
                    return;
                }
                int enc_pos = lowercase_input_header.indexOf("accept-encoding:");
                if (enc_pos != -1 && (e_pos = input_header.indexOf(NL, enc_pos)) != -1) {
                    gzip_reply = input_header.substring(enc_pos + 16, e_pos).toLowerCase().indexOf("gzip") != -1;
                }
                this.setTaskState("decoding announce/scrape");
                int pos = 0;
                String hash_str = null;
                HashWrapper peer_id = null;
                int port = 0;
                String event = null;
                long uploaded = 0L;
                long downloaded = 0L;
                long left = 0L;
                int num_want = -1;
                boolean no_peer_id = false;
                boolean compact = false;
                String key = null;
                while (pos < str.length()) {
                    String token;
                    int p1 = str.indexOf(38, pos);
                    if (p1 == -1) {
                        token = str.substring(pos);
                    } else {
                        token = str.substring(pos, p1);
                        pos = p1 + 1;
                    }
                    int p2 = token.indexOf(61);
                    if (p2 == -1) {
                        throw new Exception("format invalid");
                    }
                    String lhs = token.substring(0, p2).toLowerCase();
                    String rhs = URLDecoder.decode(token.substring(p2 + 1), "ISO-8859-1");
                    if (lhs.equals("info_hash")) {
                        hash_str = rhs;
                    } else if (lhs.equals("peer_id")) {
                        peer_id = new HashWrapper(rhs.getBytes("ISO-8859-1"));
                    } else if (lhs.equals("no_peer_id")) {
                        no_peer_id = rhs.equals("1");
                    } else if (lhs.equals("compact")) {
                        if (this.server.isCompactEnabled()) {
                            compact = rhs.equals("1");
                        }
                    } else if (lhs.equals("key")) {
                        if (this.server.isKeyEnabled()) {
                            key = rhs;
                        }
                    } else if (lhs.equals("port")) {
                        port = Integer.parseInt(rhs);
                    } else if (lhs.equals("event")) {
                        event = rhs;
                    } else if (lhs.equals("ip")) {
                        client_ip_address = rhs;
                    } else if (lhs.equals("uploaded")) {
                        uploaded = Long.parseLong(rhs);
                    } else if (lhs.equals("downloaded")) {
                        downloaded = Long.parseLong(rhs);
                    } else if (lhs.equals("left")) {
                        left = Long.parseLong(rhs);
                    } else if (lhs.equals("numwant")) {
                        num_want = Integer.parseInt(rhs);
                    }
                    if (p1 == -1) break;
                }
                byte[] hash_bytes = null;
                if (hash_str != null) {
                    hash_bytes = hash_str.getBytes("ISO-8859-1");
                }
                Map[] root_out = new Map[1];
                TRTrackerServerPeerImpl[] peer_out = new TRTrackerServerPeerImpl[1];
                specific_torrent = this.processTrackerRequest(this.server, root_out, peer_out, request_type, hash_bytes, peer_id, no_peer_id, compact, key, event, port, client_ip_address, downloaded, uploaded, left, num_want);
                root = root_out[0];
                if (root.get("_data") == null) {
                    this.server.postProcess(peer_out[0], specific_torrent, request_type, root);
                }
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null || message.length() == 0) {
                    message = e.toString();
                }
                root = new HashMap<String, Object>();
                root.put("failure reason", message);
            }
            this.setTaskState("writing response");
            byte[] data = (byte[])root.get("_data");
            if (data == null) {
                data = BEncoder.encode(root);
                root.put("_data", data);
            }
            if (gzip_reply) {
                byte[] gzip_data = (byte[])root.get("_gzipdata");
                if (gzip_data == null) {
                    ByteArrayOutputStream tos = new ByteArrayOutputStream(data.length);
                    GZIPOutputStream gos = new GZIPOutputStream(tos);
                    gos.write(data);
                    gos.close();
                    gzip_data = tos.toByteArray();
                    root.put("_gzipdata", gzip_data);
                }
                data = gzip_data;
            }
            this.setTaskState("writing header");
            os.write(HTTP_RESPONSE_START);
            byte[] length_bytes = String.valueOf(data.length).getBytes();
            os.write(length_bytes);
            int header_len = HTTP_RESPONSE_START.length + length_bytes.length;
            this.setTaskState("writing content");
            if (gzip_reply) {
                os.write(HTTP_RESPONSE_END_GZIP);
                header_len += HTTP_RESPONSE_END_GZIP.length;
            } else {
                os.write(HTTP_RESPONSE_END_NOGZIP);
                header_len += HTTP_RESPONSE_END_NOGZIP.length;
            }
            os.write(data);
            this.server.updateStats(specific_torrent, input_header.length(), header_len + data.length);
        }
        finally {
            this.setTaskState("final os flush");
            os.flush();
        }
    }

    protected boolean doAuthentication(String url_path, String header, OutputStream os, boolean tracker) throws IOException {
        boolean apply_torrent_password;
        boolean apply_web_password = !tracker && this.server.isWebPasswordEnabled();
        boolean bl = apply_torrent_password = tracker && this.server.isTrackerPasswordEnabled();
        if (apply_web_password && this.server.isWebPasswordHTTPSOnly() && !this.server.isSSL()) {
            os.write("HTTP/1.1 403 BAD\r\n\r\nAccess Denied\r\n".getBytes());
            os.flush();
            return false;
        }
        if (apply_torrent_password || apply_web_password) {
            int x = header.indexOf("Authorization:");
            if (x == -1) {
                if (this.server.hasExternalAuthorisation()) {
                    try {
                        String resource_str = String.valueOf(this.server.isSSL() ? "https" : "http") + "://" + this.server.getHost() + ":" + this.server.getPort() + url_path;
                        URL resource = new URL(resource_str);
                        if (this.server.performExternalAuthorisation(resource, "", "")) {
                            return true;
                        }
                    }
                    catch (MalformedURLException e) {
                        Debug.printStackTrace(e);
                    }
                }
            } else {
                int p1 = header.indexOf(32, x);
                int p2 = header.indexOf(32, p1 + 1);
                String body = header.substring(p2, header.indexOf(13, p2)).trim();
                String decoded = new String(new BASE64Decoder().decodeBuffer(body));
                int cp = decoded.indexOf(58);
                String user = decoded.substring(0, cp);
                String pw = decoded.substring(cp + 1);
                boolean auth_failed = false;
                if (this.server.hasExternalAuthorisation()) {
                    try {
                        String resource_str = String.valueOf(this.server.isSSL() ? "https" : "http") + "://" + this.server.getHost() + ":" + this.server.getPort() + url_path;
                        URL resource = new URL(resource_str);
                        if (this.server.performExternalAuthorisation(resource, user, pw)) {
                            return true;
                        }
                    }
                    catch (MalformedURLException e) {
                        Debug.printStackTrace(e);
                    }
                    auth_failed = true;
                }
                if (this.server.hasInternalAuthorisation() && !auth_failed) {
                    try {
                        byte[] internal_pw;
                        SHA1Hasher hasher = new SHA1Hasher();
                        byte[] password = pw.getBytes();
                        byte[] encoded = password.length > 0 ? hasher.calculateHash(password) : new byte[]{};
                        if (user.equals("<internal>") ? Arrays.equals(internal_pw = new BASE64Decoder().decodeBuffer(pw), this.server.getPassword()) : user.equalsIgnoreCase(this.server.getUsername()) && Arrays.equals(encoded, this.server.getPassword())) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            os.write(("HTTP/1.1 401 BAD\r\nWWW-Authenticate: Basic realm=\"" + this.server.getName() + "\"\r\n\r\nAccess Denied\r\n").getBytes());
            os.flush();
            return false;
        }
        return true;
    }

    protected boolean handleExternalRequest(String client_address, String url, String header, InputStream is, OutputStream os) throws IOException {
        return this.server.handleExternalRequest(client_address, url, header, is, os);
    }
}

