/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.FieldDef;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.Pointer;

public class Field
implements Insertable {
    protected Buffer buffer;
    protected int offset;
    protected int length;

    public Field(byte[] bytes) {
        this.buffer = new Buffer(bytes);
        this.offset = 0;
        this.length = bytes.length;
    }

    public Field(byte[] bytes, int offset, int length) {
        this.buffer = new Buffer(bytes);
        this.offset = offset;
        this.length = Math.min(bytes.length, length);
    }

    public Field(byte[] bytes, FieldDef d) {
        this.buffer = new Buffer(bytes);
        this.offset = d.offset;
        this.length = Math.min(bytes.length, d.length);
    }

    public Field(int n) {
        this.buffer = new Buffer(n);
        this.offset = 0;
        this.length = n;
    }

    public Field(Buffer buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public Field(Buffer buffer, FieldDef d) {
        this.buffer = buffer;
        this.offset = d.offset;
        this.length = d.length;
    }

    public Field(Insertable anObject) {
        this.buffer = new Buffer(anObject);
        this.offset = 0;
        this.length = this.buffer.length();
    }

    public Field clear() {
        this.buffer.clear(this.offset, this.length);
        return this;
    }

    public Field clear(byte value) {
        this.buffer.clear(this.offset, this.length, value);
        return this;
    }

    public int compareTo(Field that) {
        return Buffer.compare(this.buffer, this.offset, this.length, that.buffer, that.offset, that.length);
    }

    public Field subfield(int offset, int length) {
        if (offset + length > this.length) {
            throw new IllegalArgumentException();
        }
        return this.buffer.getField(this.offset + offset, length);
    }

    public Field subfield(FieldDef d) {
        if (d.offset + d.length > this.length) {
            throw new IllegalArgumentException();
        }
        return this.buffer.getField(this.offset + d.offset, d.length);
    }

    public Field subfield(int offset) {
        return this.subfield(offset, this.length - offset);
    }

    public byte[] get() {
        return this.buffer.get(this.offset, this.length);
    }

    public int getInt() {
        return this.buffer.getInt(this.offset, this.length);
    }

    public long getLong() {
        return this.buffer.getLong(this.offset, this.length);
    }

    public int getUInt() {
        return this.buffer.getUInt(this.offset, this.length);
    }

    public byte[] get(FieldDef d) {
        return this.subfield(d).get();
    }

    public int getInt(FieldDef d) {
        return this.subfield(d).getInt();
    }

    public long getLong(FieldDef d) {
        return this.subfield(d).getLong();
    }

    public int getUInt(FieldDef d) {
        return this.subfield(d).getUInt();
    }

    public int length() {
        return this.length;
    }

    public int offset() {
        return this.offset;
    }

    public Pointer pointTo(int offset) {
        return new Pointer(this.buffer, this.offset + offset);
    }

    public Field put(byte[] b) {
        this.buffer.put(this.offset, this.length, b);
        return this;
    }

    public Field put(int n) {
        this.buffer.put(this.offset, this.length, n);
        return this;
    }

    public Field put(long n) {
        this.buffer.put(this.offset, this.length, n);
        return this;
    }

    public Field put(Insertable anObject) {
        this.put(anObject.toByteArray());
        return this;
    }

    public Field put(FieldDef d, byte[] b) {
        this.subfield(d).put(b);
        return this;
    }

    public Field put(FieldDef d, int n) {
        this.subfield(d).put(n);
        return this;
    }

    public Field put(FieldDef d, long n) {
        this.subfield(d).put(n);
        return this;
    }

    public Field put(FieldDef d, Insertable anObject) {
        this.subfield(d).put(anObject.toByteArray());
        return this;
    }

    public byte[] toByteArray() {
        return this.get();
    }
}

