/*
 * Decompiled with CFR 0.152.
 */
package $installer$.org.aspectj;

import $installer$.org.aspectj.InstallContext;
import $installer$.org.aspectj.InstallPane;
import $installer$.org.aspectj.Main;
import $installer$.org.aspectj.Options;
import $installer$.org.aspectj.WizardPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

abstract class Installer {
    static final String EXIT_MESSAGE = "Are you sure you want to cancel the installation?";
    static final String EXIT_TITLE = "Exiting installer";
    public static final String RESOURCE_DIR = "resources";
    JFrame frame;
    InstallContext context;
    InstallPane installPane;
    protected WizardPane[] panes = new WizardPane[0];
    Component header;
    Component footer;
    Component body;

    protected void setInstallPane(InstallPane installPane) {
        this.installPane = installPane;
    }

    public InstallPane getInstallPane() {
        return this.installPane;
    }

    public void run() {
        if (null != this.installPane) {
            this.installPane.run();
        }
    }

    public abstract String getPrefix();

    public String getReadmeFilename() {
        return "README-" + this.getPrefix().toUpperCase() + ".html";
    }

    public void setContext(InstallContext context) {
        this.context = context;
        context.installer = this;
    }

    public InstallContext getContext() {
        return this.context;
    }

    public String getTitle() {
        return "AspectJ(TM) Installer";
    }

    public int getWidth() {
        return 640;
    }

    public int getHeight() {
        return 460;
    }

    public WizardPane[] getPanes() {
        return this.panes;
    }

    public int findPaneIndex(WizardPane pane) {
        for (int i = 0; i < this.panes.length; ++i) {
            if (this.panes[i] != pane) continue;
            return i;
        }
        return -1;
    }

    public void runGUI() {
        this.frame = new JFrame(this.getTitle());
        WindowAdapter wl = new WindowAdapter(){

            public void windowClosing(WindowEvent arg0) {
                Main.exit(-1);
            }
        };
        this.frame.addWindowListener(wl);
        if (Options.forceError1) {
            throw new RuntimeException("forced error1 for testing purposes");
        }
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)(size.getWidth() - (double)this.getWidth()) / 2;
        int y = (int)(size.getHeight() - (double)this.getHeight()) / 2;
        if (x < 0) {
            x = 0;
        }
        if (x > 600) {
            x = 600;
        }
        if (y < 0) {
            y = 0;
        }
        if (y > 400) {
            y = 400;
        }
        ((Component)this.frame).setLocation(x, y);
        ((Component)this.frame).setSize(this.getWidth(), this.getHeight());
        this.moveToPane(this.getPanes()[0]);
        ((Component)this.frame).setVisible(true);
    }

    public void moveToPane(WizardPane pane) {
        WizardPane.setContext(this.context);
        Dimension size = this.frame.getContentPane().getSize();
        JPanel contents = new JPanel();
        contents.setLayout(new BorderLayout());
        this.header = this.makeHeader();
        contents.add(this.header, "North");
        this.body = pane.getPanel();
        contents.add(this.body, "Center");
        this.footer = pane.getButtons();
        contents.add(this.footer, "South");
        contents.revalidate();
        contents.setSize(size);
        this.frame.setContentPane(contents);
        pane.run();
    }

    public Icon loadImage(String name) {
        return new ImageIcon(this.getClass().getResource(name));
    }

    public Component makeHeader() {
        return new JLabel(this.loadImage("resources/aspectjBanner.gif"));
    }

    public ActionListener makeNextAction(final WizardPane pane) {
        int nextPaneIndex = this.findPaneIndex(pane) + 1;
        if (nextPaneIndex >= this.getPanes().length) {
            return null;
        }
        final WizardPane nextPane = this.getPanes()[nextPaneIndex];
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                pane.finish();
                Installer.this.moveToPane(nextPane);
            }
        };
    }

    public ActionListener makeBackAction(WizardPane pane) {
        int nextPaneIndex = this.findPaneIndex(pane) - 1;
        if (nextPaneIndex < 0) {
            return null;
        }
        final WizardPane nextPane = this.getPanes()[nextPaneIndex];
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Installer.this.moveToPane(nextPane);
            }
        };
    }

    public ActionListener makeCancelAction(WizardPane pane) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int ret = JOptionPane.showConfirmDialog(Installer.this.frame, Installer.EXIT_MESSAGE, Installer.EXIT_TITLE, 0, 3);
                if (ret == 0) {
                    Main.exit(-1);
                }
            }
        };
    }

    public ActionListener makeFinishAction(WizardPane pane) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.exit(0);
            }
        };
    }
}

