/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Ant", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.tools.ant.taskdefs;

import java.io.File;

/**
 * Proxy interface for XSLT processors.
 *
 * @author <a href="mailto:rubys@us.ibm.com">Sam Ruby</a>
 * @author <a href="mailto:sbailliez@apache.org">Stephane Bailliez</a>
 * @see #XSLTProcess
 */
public interface XSLTLiaison {

    /**
     * the file protocol prefix for systemid.
     * This file protocol must be appended to an absolute path.
     * Typically: <tt>FILE_PROTOCOL_PREFIX + file.getAbsolutePath()</tt>
     * This is not correct in specification terms since an absolute
     * url in Unix is file:// + file.getAbsolutePath() while it is
     * file:/// + file.getAbsolutePath() under Windows.
     * Whatever, it should not be a problem to put file:/// in every
     * case since most parsers for now incorrectly makes no difference
     * between it.. and users also have problem with that :)
     */
    public final static String FILE_PROTOCOL_PREFIX = "file:///";

    /**
     * set the stylesheet to use for the transformation.
     * @param stylesheet the stylesheet to be used for transformation.
     */
    public void setStylesheet(File stylesheet) throws Exception;

    /**
     * Add a parameter to be set during the XSL transformation.
     * @param name the parameter name.
     * @param expression the parameter value as an expression string.
     * @throws Exception thrown if any problems happens.
     */
    public void addParam(String name, String expression) throws Exception;

    /**
     * Perform the transformation of a file into another.
     * @param infile the input file, probably an XML one. :-)
     * @param outfile the output file resulting from the transformation
     * @throws Exception thrown if any problems happens.
     * @see #setStylesheet(File)
     */
    public void transform(File infile, File outfile) throws Exception;

} //-- XSLTLiaison
