package IPC::Open2;

use strict;
our ($VERSION, @ISA, @EXPORT);

require 5.000;
require Exporter;

$VERSION	= 1.01;
@ISA		= qw(Exporter);
@EXPORT		= qw(open2);

# &open2: tom christiansen, <tchrist@convex.com>
#
# usage: $pid = open2('rdr', 'wtr', 'some cmd and args');
#    or  $pid = open2('rdr', 'wtr', 'some', 'cmd', 'and', 'args');
#
# spawn the given $cmd and connect $rdr for
# reading and $wtr for writing.  return pid
# of child, or 0 on failure.  
# 
# WARNING: this is dangerous, as you may block forever
# unless you are very careful.  
# 
# $wtr is left unbuffered.
# 
# abort program if
#	rdr or wtr are null
# 	a system call fails

require IPC::Open3;

sub open2 {
    local $Carp::CarpLevel = $Carp::CarpLevel + 1;
    return IPC::Open3::_open3('open2', scalar caller,
				$_[1], $_[0], '>&STDERR', @_[2 .. $#_]);
}

1
