#
# This file is auto-generated. ***ANY*** changes here will be lost
#

package Errno;
use vars qw(@EXPORT_OK %EXPORT_TAGS @ISA $VERSION %errno $AUTOLOAD);
use Exporter ();
use Config;
use strict;

$Config{'myarchname'} eq "sparc64-linux" or
	die "Errno architecture (sparc64-linux) does not match executable architecture ($Config{'myarchname'})";

$VERSION = "1.111";
@ISA = qw(Exporter);

@EXPORT_OK = qw(EFAULT ELIBBAD ELIBACC EAFNOSUPPORT ECHILD EL2HLT
	ENOTSUP EL2NSYNC EEXIST ECONNABORTED EUSERS EREMCHG EISNAM ELOOP
	ENODEV ECONNREFUSED ENOTTY ERREMOTE ENOMEDIUM E2BIG ENOMSG ENOTNAM
	EPIPE EDOTDOT ENOTUNIQ ECONNRESET ESRMNT ENODATA EIO EUCLEAN
	EADDRNOTAVAIL EINVAL EROFS EBADSLT EILSEQ ENOTCONN EAGAIN ENOSPC
	ENAMETOOLONG EBADE EMFILE EBADF ETIME EBADR ENOMEM EINTR ENXIO ELNRNG
	ENOSR EBUSY EL3HLT ENETRESET ETIMEDOUT EINPROGRESS ECOMM EDQUOT
	EPROTONOSUPPORT EPERM EPROTOTYPE ETOOMANYREFS ENOANO ENOSYS ENETDOWN
	EMSGSIZE EALREADY ENOEXEC ENOENT EDEADLK EISCONN ENOTBLK ENOLINK EIDRM
	EBADRQC ERANGE EBADMSG ECANCELED ECHRNG EMULTIHOP EDESTADDRREQ
	EOVERFLOW EXDEV EBFONT ESTALE ELIBSCN ENAVAIL EISDIR ENOCSI ESHUTDOWN
	ESOCKTNOSUPPORT EADDRINUSE ENOTEMPTY ESPIPE EUNATCH EREMOTEIO ENONET
	ENOPROTOOPT EREMOTE ENETUNREACH ENOTDIR EPROCLIM EFBIG EADV ELIBEXEC
	EACCES EMEDIUMTYPE EHOSTUNREACH ESTRPIPE ENOBUFS ENFILE ETXTBSY
	EPFNOSUPPORT EBADFD ENOSTR EWOULDBLOCK ENOLCK EL3RST EMLINK ELIBMAX
	ENOPKG EDOM ENOTSOCK ERESTART EXFULL ESRCH EPROTO EHOSTDOWN EDEADLOCK
	EOPNOTSUPP);

%EXPORT_TAGS = (
    POSIX => [qw(
	E2BIG EACCES EADDRINUSE EADDRNOTAVAIL EAFNOSUPPORT EAGAIN EALREADY
	EBADF EBUSY ECHILD ECONNABORTED ECONNREFUSED ECONNRESET EDEADLK
	EDESTADDRREQ EDOM EDQUOT EEXIST EFAULT EFBIG EHOSTDOWN EHOSTUNREACH
	EINPROGRESS EINTR EINVAL EIO EISCONN EISDIR ELOOP EMFILE EMLINK
	EMSGSIZE ENAMETOOLONG ENETDOWN ENETRESET ENETUNREACH ENFILE ENOBUFS
	ENODEV ENOENT ENOEXEC ENOLCK ENOMEM ENOPROTOOPT ENOSPC ENOSYS ENOTBLK
	ENOTCONN ENOTDIR ENOTEMPTY ENOTSOCK ENOTTY ENXIO EOPNOTSUPP EPERM
	EPFNOSUPPORT EPIPE EPROCLIM EPROTONOSUPPORT EPROTOTYPE ERANGE EREMOTE
	ERESTART EROFS ESHUTDOWN ESOCKTNOSUPPORT ESPIPE ESRCH ESTALE ETIMEDOUT
	ETOOMANYREFS ETXTBSY EUSERS EWOULDBLOCK EXDEV
    )]
);

sub EPERM () { 1 }
sub ENOENT () { 2 }
sub ESRCH () { 3 }
sub EINTR () { 4 }
sub EIO () { 5 }
sub ENXIO () { 6 }
sub E2BIG () { 7 }
sub ENOEXEC () { 8 }
sub EBADF () { 9 }
sub ECHILD () { 10 }
sub EWOULDBLOCK () { 11 }
sub EAGAIN () { 11 }
sub ENOMEM () { 12 }
sub EACCES () { 13 }
sub EFAULT () { 14 }
sub ENOTBLK () { 15 }
sub EBUSY () { 16 }
sub EEXIST () { 17 }
sub EXDEV () { 18 }
sub ENODEV () { 19 }
sub ENOTDIR () { 20 }
sub EISDIR () { 21 }
sub EINVAL () { 22 }
sub ENFILE () { 23 }
sub EMFILE () { 24 }
sub ENOTTY () { 25 }
sub ETXTBSY () { 26 }
sub EFBIG () { 27 }
sub ENOSPC () { 28 }
sub ESPIPE () { 29 }
sub EROFS () { 30 }
sub EMLINK () { 31 }
sub EPIPE () { 32 }
sub EDOM () { 33 }
sub ERANGE () { 34 }
sub EINPROGRESS () { 36 }
sub EALREADY () { 37 }
sub ENOTSOCK () { 38 }
sub EDESTADDRREQ () { 39 }
sub EMSGSIZE () { 40 }
sub EPROTOTYPE () { 41 }
sub ENOPROTOOPT () { 42 }
sub EPROTONOSUPPORT () { 43 }
sub ESOCKTNOSUPPORT () { 44 }
sub ENOTSUP () { 45 }
sub EOPNOTSUPP () { 45 }
sub EPFNOSUPPORT () { 46 }
sub EAFNOSUPPORT () { 47 }
sub EADDRINUSE () { 48 }
sub EADDRNOTAVAIL () { 49 }
sub ENETDOWN () { 50 }
sub ENETUNREACH () { 51 }
sub ENETRESET () { 52 }
sub ECONNABORTED () { 53 }
sub ECONNRESET () { 54 }
sub ENOBUFS () { 55 }
sub EISCONN () { 56 }
sub ENOTCONN () { 57 }
sub ESHUTDOWN () { 58 }
sub ETOOMANYREFS () { 59 }
sub ETIMEDOUT () { 60 }
sub ECONNREFUSED () { 61 }
sub ELOOP () { 62 }
sub ENAMETOOLONG () { 63 }
sub EHOSTDOWN () { 64 }
sub EHOSTUNREACH () { 65 }
sub ENOTEMPTY () { 66 }
sub EPROCLIM () { 67 }
sub EUSERS () { 68 }
sub EDQUOT () { 69 }
sub ESTALE () { 70 }
sub EREMOTE () { 71 }
sub ENOSTR () { 72 }
sub ETIME () { 73 }
sub ENOSR () { 74 }
sub ENOMSG () { 75 }
sub EBADMSG () { 76 }
sub EIDRM () { 77 }
sub EDEADLK () { 78 }
sub ENOLCK () { 79 }
sub ENONET () { 80 }
sub ERREMOTE () { 81 }
sub ENOLINK () { 82 }
sub EADV () { 83 }
sub ESRMNT () { 84 }
sub ECOMM () { 85 }
sub EPROTO () { 86 }
sub EMULTIHOP () { 87 }
sub EDOTDOT () { 88 }
sub EREMCHG () { 89 }
sub ENOSYS () { 90 }
sub ESTRPIPE () { 91 }
sub EOVERFLOW () { 92 }
sub EBADFD () { 93 }
sub ECHRNG () { 94 }
sub EL2NSYNC () { 95 }
sub EL3HLT () { 96 }
sub EL3RST () { 97 }
sub ELNRNG () { 98 }
sub EUNATCH () { 99 }
sub ENOCSI () { 100 }
sub EL2HLT () { 101 }
sub EBADE () { 102 }
sub EBADR () { 103 }
sub EXFULL () { 104 }
sub ENOANO () { 105 }
sub EBADRQC () { 106 }
sub EBADSLT () { 107 }
sub EDEADLOCK () { 108 }
sub EBFONT () { 109 }
sub ELIBEXEC () { 110 }
sub ENODATA () { 111 }
sub ELIBBAD () { 112 }
sub ENOPKG () { 113 }
sub ELIBACC () { 114 }
sub ENOTUNIQ () { 115 }
sub ERESTART () { 116 }
sub EUCLEAN () { 117 }
sub ENOTNAM () { 118 }
sub ENAVAIL () { 119 }
sub EISNAM () { 120 }
sub EREMOTEIO () { 121 }
sub EILSEQ () { 122 }
sub ELIBMAX () { 123 }
sub ELIBSCN () { 124 }
sub ECANCELED () { 125 }
sub ENOMEDIUM () { 125 }
sub EMEDIUMTYPE () { 126 }

sub TIEHASH { bless [] }

sub FETCH {
    my ($self, $errname) = @_;
    my $proto = prototype("Errno::$errname");
    if (defined($proto) && $proto eq "") {
	no strict 'refs';
        return $! == &$errname;
    }
    require Carp;
    Carp::confess("No errno $errname");
} 

sub STORE {
    require Carp;
    Carp::confess("ERRNO hash is read only!");
}

*CLEAR = \&STORE;
*DELETE = \&STORE;

sub NEXTKEY {
    my($k,$v);
    while(($k,$v) = each %Errno::) {
	my $proto = prototype("Errno::$k");
	last if (defined($proto) && $proto eq "");
	
    }
    $k
}

sub FIRSTKEY {
    my $s = scalar keys %Errno::;
    goto &NEXTKEY;
}

sub EXISTS {
    my ($self, $errname) = @_;
    my $proto = prototype($errname);
    defined($proto) && $proto eq "";
}

tie %!, __PACKAGE__;

1;
__END__

=head1 NAME

Errno - System errno constants

=head1 SYNOPSIS

    use Errno qw(EINTR EIO :POSIX);

=head1 DESCRIPTION

C<Errno> defines and conditionally exports all the error constants
defined in your system C<errno.h> include file. It has a single export
tag, C<:POSIX>, which will export all POSIX defined error numbers.

C<Errno> also makes C<%!> magic such that each element of C<%!> has a non-zero
value only if C<$!> is set to that value, eg

    use Errno;
    
    unless (open(FH, "/fangorn/spouse")) {
        if ($!{ENOENT}) {
            warn "Get a wife!\n";
        } else {
            warn "This path is barred: $!";
        } 
    } 

=head1 AUTHOR

Graham Barr <gbarr@pobox.com>

=head1 COPYRIGHT

Copyright (c) 1997-8 Graham Barr. All rights reserved.
This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

