/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * Mutex.h
 *
 * $Id: Mutex.h,v 1.3 2000/12/27 16:59:27 rex Exp $
 *
 * Copyright (c) 2000 Benoit Joly <benoit@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifndef MUTEX_HH
#define MUTEX_HH

#include <pthread.h>

/**
 * This class is a wrapper for the system pthread_mutex.
 */

class Mutex
{
  public:
    /// Constructor
    Mutex();

    /// Destructor
    ~Mutex();

    /// This method lock the object
    void lock();

    /// This method unlock the object
    void unlock();

    /// This method return true if the lock was successful or not
    bool trylock();
    
    
  private:
    /// The system mutex
    pthread_mutex_t a_mutex;
};
#endif
