/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * PgDbMetaData.cc
 *   description goes here
 *
 * $Id: PgDbMetaData.cc,v 1.6 2000/12/27 16:59:27 rex Exp $
 *
 * Copyright (c) 2000 Benoit Joly <benoit@ddts.org>
 *                and Remi Lefebvre <remi@dhis.net>
 *                and Luca Filipozzi <lfilipoz@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#include "PgDbMetaData.h"
#include <string.h>
#include <stdlib.h>

PgDbMetaData::TypeContainer::TypeContainer()
{
    type = UNDEFINED;
}

PgDbMetaData::TypeContainer::TypeContainer(eDataType type)
{    
    this->type = type;
}

PgDbMetaData::TypeContainer::TypeContainer(const char *typeName)
{
    if (strstr(typeName, "char") == 0)
    {
        type = STRING;
    }
    else if (strstr(typeName, "int") == 0)
    {
        type = INT;
    }
    else if (strstr(typeName, "float") == 0)
    {
        type = FLOAT;
    }
    else if (strcmp(typeName, "date") == 0)
    {
        type = DATE;
    }
    else if (strcmp(typeName, "time") == 0)
    {
        type = TIME;
    }
    else if (strcmp(typeName, "bool") == 0)
    {
        type = BOOL;
    }
    else if (strcmp(typeName, "numberic") == 0)
    {
        type = INT;
    }
    else
    {
        type = UNDEFINED;
    }
}

void PgDbMetaData::initTypes(PgDatabase &pgdb)
{
    if (pgdb.ExecTuplesOk("SELECT oid, typname FROM pg_type"))
    {
        int nbRows = pgdb.Tuples();
//        int nbColumns = pgdb.Fields();
        const char *oid;
        const char *typeName;
       

        for (int row = 0; row < nbRows; row++)
        {
            oid = pgdb.GetValue(row, 0);
            typeName = pgdb.GetValue(row, 1);

            oidToEnum[atoi(oid)] = TypeContainer(typeName);
        }
    }
}

PgDbMetaData::PgDbMetaData(PgDatabase &pgdb)
{
    init(pgdb);
}

PgDbMetaData::~PgDbMetaData() { /* empty */ }

void PgDbMetaData::init(PgDatabase &pgdb)
{
    int pgType;
//    eDataType type;

    const char *name;
    int size;

    int nbFields;
//    ColumnMetaData *cmd;
    TypeContainer typeContainer;
  
    nbFields = pgdb.Fields();

    for (int i = 0; i < nbFields; i++)
    {
        name = pgdb.FieldName(i);
        pgType = pgdb.FieldType(i);
        size = pgdb.FieldSize(i);

        typeContainer = oidToEnum[pgType];

        if (typeContainer.type == UNDEFINED)
        {
            // type not found
        }

        metaDataVector.push_back
            (ColumnMetaData(string(name), size, typeContainer.type));
    }
}
