#ifndef _RHEOLEF_LDLT_SEQ_BUILTIN_H
#define _RHEOLEF_LDLT_SEQ_BUILTIN_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
// LDLt : factorization of symmetric matrix (sequential version)
// implementation: inspirated from the Tim Davis "LDLT" library
//
// author: Pierre.Saramito@imag.fr
//
// date: 15 september 2014
//
#include <valarray>
#include "rheolef/csr.h"

namespace rheolef {

template <typename T>
class ldlt_seq_builtin {
  public:
    ldlt_seq_builtin();
    ldlt_seq_builtin(const csr_rep<T,sequential>& a);
    void update_values (const csr_rep<T,sequential>& a);
    bool is_singular() const { return !status; }
    template<class M2>
    vec<T,M2>& inplace_solve (vec<T,M2>& x) const;
    template<class M2>
    vec<T,M2>  solve (const vec<T,M2>& b) const;
    size_t nnz() const { return L.nnz(); }
    size_t flops() const { return fp; }
    template <typename U> friend
    odiststream& operator<< (odiststream&, const ldlt_seq_builtin<U>&);
  protected:
    csr_rep<T,sequential>     L;
    vec<T,sequential>     D;
    std::valarray<size_t> perm;
    bool                  status;
    size_t                fp;
};

} // namespace rheolef
#endif // _RHEOLEF_LDLT_SEQ_BUILTIN_H
