/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2017 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::semiPermeableBaffleVelocityFvPatchVectorField

Group
    grpGenericBoundaryConditions

Description
    This is a velocity boundary condition for a semi-permeable baffle.

    This is a velocity boundary condition for baffles which are permeable to a
    some species and impermeable to others. It must be used in conjunction
    with the corresponding mass-fraction condition,
    semiPermeableBaffleMassFractionFvPatchScalarField.

    This condition sums the species fluxes generated by the the mass-fraction
    conditions, and uses this total to set the velocity.

Usage
    \table
        Property | Description               | Req'd? | Default
        rho      | Name of the density field | no     | rho
    \endtable

See also
    Foam::semiPermeableBaffleMassFractionFvPatchScalarField

SourceFiles
    semiPermeableBaffleVelocityFvPatchVectorField.C

\*---------------------------------------------------------------------------*/

#ifndef semiPermeableBaffleVelocityFvPatchVectorField_H
#define semiPermeableBaffleVelocityFvPatchVectorField_H

#include "mappedPatchBase.H"
#include "fixedValueFvPatchFields.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

class basicSpecieMixture;

/*---------------------------------------------------------------------------*\
       Class semiPermeableBaffleVelocityFvPatchVectorField Declaration
\*---------------------------------------------------------------------------*/

class semiPermeableBaffleVelocityFvPatchVectorField
:
    public fixedValueFvPatchVectorField
{
    // Private data

        //- Name of the density field
        const word rhoName_;


    // Private Member Functions

        //- Return the composition
        const basicSpecieMixture& composition() const;


public:

    //- Runtime type information
    TypeName("semiPermeableBaffleVelocity");


    // Constructors

        //- Construct from patch and internal field
        semiPermeableBaffleVelocityFvPatchVectorField
        (
            const fvPatch&,
            const DimensionedField<vector, volMesh>&
        );

        //- Construct from patch, internal field and dictionary
        semiPermeableBaffleVelocityFvPatchVectorField
        (
            const fvPatch&,
            const DimensionedField<vector, volMesh>&,
            const dictionary&
        );

        //- Construct by mapping given fixedValueTypeFvPatchField
        //  onto a new patch
        semiPermeableBaffleVelocityFvPatchVectorField
        (
            const semiPermeableBaffleVelocityFvPatchVectorField&,
            const fvPatch&,
            const DimensionedField<vector, volMesh>&,
            const fvPatchFieldMapper&
        );

        //- Construct as copy
        semiPermeableBaffleVelocityFvPatchVectorField
        (
            const semiPermeableBaffleVelocityFvPatchVectorField&
        );

        //- Construct and return a clone
        virtual tmp<fvPatchVectorField> clone() const
        {
            return tmp<fvPatchVectorField>
            (
                new semiPermeableBaffleVelocityFvPatchVectorField(*this)
            );
        }

        //- Construct as copy setting internal field reference
        semiPermeableBaffleVelocityFvPatchVectorField
        (
            const semiPermeableBaffleVelocityFvPatchVectorField&,
            const DimensionedField<vector, volMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchVectorField> clone
        (
            const DimensionedField<vector, volMesh>& iF
        ) const
        {
            return tmp<fvPatchVectorField>
            (
                new semiPermeableBaffleVelocityFvPatchVectorField
                (
                    *this,
                    iF
                )
            );
        }


    // Member functions

        // Evaluation functions

            //- Update the coefficients associated with the patch field
            virtual void updateCoeffs();


        //- Write
        virtual void write(Ostream&) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //


#endif

// ************************************************************************* //
