'\" t
.\" -*- nroff -*-
.\"
.\"
.\"     Copyright (C) 1996-2018 Michael R. Elkins <me@cs.hmc.edu>
.\"
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 2 of the License, or
.\"     (at your option) any later version.
.\"
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
.\"
.TH neomutt 1 "@MAN_DATE@" Unix "User Manuals"
.\" --------------------------------------------------------------------
.SH NAME
.\" --------------------------------------------------------------------
neomutt \- The NeoMutt Mail User Agent (MUA)
.
.\" --------------------------------------------------------------------
.SH SYNTAX
.\" --------------------------------------------------------------------
.SY neomutt
.OP \-Enx
.OP \-e command
.OP \-F config
.OP \-H draft
.OP \-i include
.br
.OP \-b address
.OP \-c address
.OP \-s subject
.RB [ \-a
.IR file " [" .\|.\|.\& ]
.BR \-\- ]
.IR address " [" .\|.\|.\& ]
.YS
.
.SY neomutt
.OP \-nx
.OP \-e command
.OP \-F config
.OP \-b address
.OP \-c address
.br
.OP \-s subject
.RB [ \-a
.IR file " [" .\|.\|.\& ]
.BR \-\- ]
.IR address " [" .\|.\|.\& "] < message"
.YS
.
.SY neomutt
.OP \-nRy
.OP \-e command
.OP \-F config
.OP \-f mailbox
.OP \-m type
.YS
.
.SY neomutt
.OP \-n
.OP \-e command
.OP \-F config
.BI \-A " alias"
.YS
.
.SY neomutt
.OP \-n
.OP \-e command
.OP \-F config
.BR \-B
.YS
.
.SY neomutt
.OP \-n
.OP \-e command
.OP \-F config
.BR \-D " [" \-S ]
.YS
.
.SY neomutt
.OP \-n
.OP \-e command
.OP \-F config
.BI \-d " level"
.BI \-l " file"
.YS
.
.SY neomutt
.OP \-n
.OP \-e command
.OP \-F config
.BI \-G
.YS
.
.SY neomutt
.OP \-n
.OP \-e command
.OP \-F config
.BI \-g " server"
.YS
.
.SY neomutt
.OP \-n
.OP \-e command
.OP \-F config
.BI \-p
.YS
.
.SY neomutt
.OP \-n
.OP \-e command
.OP \-F config
.BI \-Q " variable"
.YS
.
.SY neomutt
.OP \-n
.OP \-e command
.OP \-F config
.BI \-Z
.YS
.
.SY neomutt
.OP \-n
.OP \-e command
.OP \-F config
.BI \-z
.OP \-f mailbox
.YS
.
.SY neomutt
.BR \-v [ v ]
.YS
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.PP
NeoMutt is a small but very powerful text based program for reading and sending
electronic mail under Unix operating systems, including support for color
terminals, MIME, OpenPGP, and a threaded sorting mode.
.
.PP
.B Note:
This manual page gives a brief overview of NeoMutt's command line options. You
should find a copy of the full manual in \fI@MAN_DOCDIR@\fP, in plain text,
HTML, and/or PDF format.
.
.\" --------------------------------------------------------------------
.SH OPTIONS
.\" --------------------------------------------------------------------
.TP
.BI \-\-
Special argument forces NeoMutt to stop option parsing and treat remaining
arguments as \fIaddress\fPes even if they start with a dash
.
.TP
.BI \-A " alias"
Print an expanded version of the given \fIalias\fP to stdout and exit
.
.TP
.BI \-a " file"
Attach one or more \fIfile\fPs to a message (must be the last option). Add any
addresses after the \(aq\fB\-\-\fP\(aq argument, e.g.:
.RS
.IP
.EX
.BI "neomutt \-a " "image.jpg " "\-\- " "address1 "
.BI "neomutt \-a " "image.jpg *.png " "\-\- " "address1 address2 "
.EE
.RE
.IP
.
.TP
.BI \-B
Run in batch mode (do not start the ncurses UI)
.
.TP
.BI \-b " address"
Specify a blind carbon copy (Bcc) recipient
.
.TP
.BI \-c " address"
Specify a carbon copy (Cc) recipient
.
.TP
.BI \-D
Dump all configuration variables as
.RB \(aq name = value \(aq
pairs to stdout
.
.TP
.BI \-D\ \-S
Like \fB\-D\fP, but hide the value of sensitive variables
.
.TP
.BI \-d " level"
Log debugging output to a file (default is \(dq\fI~/.neomuttdebug0\fP\(dq).
The \fIlevel\fP can range from 1\(en5 and affects verbosity (a value of 2 is
recommended)
.IP
Using this option along with \fB\-l\fP is useful to log the early startup
process (before reading any configuration and hence $debug_level and
$debug_file)
.
.TP
.BI \-E
Edit \fIdraft\fP (\fB\-H\fP) or \fIinclude\fP (\fB\-i\fP) file during message
composition
.
.TP
.BI \-e " command"
Specify a \fIcommand\fP to be run after reading the config files
.
.TP
.BI \-F " config"
Specify an alternative initialization file to read, see \fIFILES\fP section
below for a list of regular configuration files
.
.TP
.BI \-f " mailbox"
Specify a \fImailbox\fP (as defined with \fBmailboxes\fP command) to load
.
.TP
.BI \-G
Start NeoMutt with a listing of subscribed newsgroups
.
.TP
.BI \-g " server"
Like \fB\-G\fP, but start at specified news \fIserver\fP
.
.TP
.BI \-H " draft"
Specify a \fIdraft\fP file with header and body for message composing
.
.TP
.BI \-h
Print this help message and exit
.
.TP
.BI \-i " include"
Specify an \fIinclude\fP file to be embedded in the body of a message
.
.TP
.BI \-l " file"
Specify a \fIfile\fP for debugging output (default
\(dq\fI~/.neomuttdebug0\fP\(dq)
.IP
This overrules $debug_file setting and NeoMutt keeps up to five debug logs
.RI "({ " file " | $debug_file | " ~/.neomuttdebug " }[" 0 - 4 ])
before override the oldest file
.
.TP
.BI \-m " type"
Specify a default mailbox format \fItype\fP for newly created folders
.IP
The \fItype\fP is either MH, MMDF, Maildir or mbox (case-insensitive)
.
.TP
.BI \-n
Do not read the system-wide configuration file
.
.TP
.BI \-p
Resume a prior postponed message, if any
.
.TP
.BI \-Q " variable"
Query a configuration \fIvariable\fP and print its value to stdout (after the
config has been read and any commands executed)
.
.TP
.BI \-R
Open mailbox in read-only mode
.
.TP
.BI \-s " subject"
Specify a \fIsubject\fP (must be enclosed in quotes if it has spaces)
.
.TP
.BI \-v
Print the NeoMutt version and compile-time definitions and exit
.
.TP
.BI \-vv
Print the NeoMutt license and copyright information and exit
.
.TP
.BI \-x
Simulate the
.BR mailx (1)
send mode
.
.TP
.BI \-y
Start NeoMutt with a listing of all defined mailboxes
.
.TP
.BI \-Z
Open the first mailbox with new message or exit immediately with exit code 1 if
none is found in all defined mailboxes
.
.TP
.BI \-z
Open the first or specified (\fB\-f\fP) mailbox if it holds any message or exit
immediately with exit code 1 otherwise
.
.\" --------------------------------------------------------------------
.SH ENVIRONMENT
.\" --------------------------------------------------------------------
.TP
.SM
.B EDITOR
Specifies the editor to use if \fIVISUAL\fP is unset. Defaults to the \fBVi\fP
editor if unset.
.
.TP
.SM
.B EGDSOCKET
For OpenSSL since version 0.9.5, files, mentioned at \fIRANDFILE\fP below, can
be Entropy Gathering Daemon (EGD) sockets. Also, and if exists,
\fI~/.entropy\fP and \fI/tmp/entropy\fP will be used to initialize SSL library
functions. Specified sockets must be owned by the user and have permission of
600 (octal number representing).
.
.TP
.SM
.B EMAIL
The user's email address.
.
.TP
.SM
.B HOME
Full path of the user's home directory.
.
.TP
.SM
.B MAIL
Full path of the user's spool mailbox.
.
.TP
.SM
.B MAILCAPS
Path to search for mailcap files. If unset, a RFC1524 compliant search path
that is extended with NeoMutt related paths (at position two and three):
.\" .RS
.\" .IP
.RI \(dq \
"$HOME/\:.mailcap" \:: \
"@MAN_DATADIR@/\:mailcap" \:: \
"@MAN_SYSCONFDIR@/\:mailcap" \:: \
"/etc/\:mailcap" \:: \
"/usr/\:etc/\:mailcap" \:: \
"/usr/\:local/\:etc/\:mailcap" \(dq
.\" .RE
.\" .IP
will be used instead.
.
.TP
.SM
.B MAILDIR
Full path of the user's spool mailbox if \fIMAIL\fP is unset. Commonly used
when the spool mailbox is a
.BR maildir (5)
folder.
.
.TP
.SM
.B MM_NOASK
If this variable is set, mailcap are always used without prompting first.
.
.TP
.SM
.B NNTPSERVER
Similar to configuration variable $news_server, specifies the domain name or
address of the default NNTP server to connect. If unset,
\fI@MAN_SYSCONFDIR@/nntpserver\fP is used but can be overridden by command line
option \fB\-g\fP.
.
.TP
.SM
.B RANDFILE
Like configuration variable $entropy_file, defines a path to a file which
includes random data that is used to initialize SSL library functions. If
unset, \fI~/.rnd\fP is used. DO NOT store important data in the specified file.
.
.TP
.SM
.B REPLYTO
When set, specifies the default Reply-To address.
.
.TP
.SM
.B TEXTDOMAINDIR
Defines an absolute path corresponding to \fI@MAN_TEXTDOMAINDIR@\fP that will
be recognised by GNU
.BR gettext (1)
and used for Native Language Support (NLS) if enabled.
.
.TP
.SM
.B TMPDIR
Directory in which temporary files are created. Defaults to \fI/tmp\fP if
unset. Configuration variable $tmpdir takes precedence over this one.
.
.TP
.SM
.B VISUAL
Specifies the editor to use when composing messages.
.
.TP
.SM
.B XDG_CONFIG_DIRS
Specifies a X Desktop Group (XDG) compliant location for the system-wide
configuration file, as described in \fIFILES\fP section below. This variable
defaults to \fI/etc/xdg\fP. Bypass loading with command line option \fB\-n\fP.
.
.TP
.SM
.B XDG_CONFIG_HOME
Specifies a XDG compliant location for the user-specific configuration file, as
described in \fIFILES\fP section below. This variable defaults to
\fI$HOME/.config\fP. Can be overridden by command line option \fB\-F\fP.
.
.\" --------------------------------------------------------------------
.SH FILES
.\" --------------------------------------------------------------------
.SS "\s-1Configuration files\s0"
.\" --------------------------------------------------------------------
.PP
NeoMutt will read just the first found configuration file of system-wide and
user-specific category, from the list below and in that order.
.
.PP
But it allows building of a recursive configuration by using the \fBsource\fP
command.
.
.PP
.na
.TS
allbox tab(|);
cb cb cb
r lxi lxi .
\0#N|system-wide|user-specific
1|T{
\%$XDG_CONFIG_DIRS/\:neomutt/\:neomuttrc
T}|T{
\%$XDG_CONFIG_HOME/\:neomutt/\:neomuttrc
T}
2|T{
\%$XDG_CONFIG_DIRS/\:neomutt/\:Muttrc \fB*\fP\fR)\fP
T}|T{
\%$XDG_CONFIG_HOME/\:neomutt/\:muttrc
T}
3|T{
\%@MAN_SYSCONFDIR@/\:neomuttrc
T}|T{
\%$XDG_CONFIG_HOME/\:mutt/\:neomuttrc
T}
4|T{
\%@MAN_SYSCONFDIR@/\:Muttrc \fB*\fP\fR)\fP
T}|T{
\%$XDG_CONFIG_HOME/\:mutt/\:muttrc
T}
5|T{
\%@MAN_DATADIR@/\:neomuttrc
T}|T{
\%~/\:.neomutt/\:neomuttrc
T}
6|T{
\%@MAN_DATADIR@/\:Muttrc \fB*\fP\fR)\fP
T}|T{
\%~/\:.neomutt/\:muttrc
T}
.T&
r c li .
7|\(em|~/.mutt/neomuttrc
8|\(em|~/.mutt/muttrc
9|\(em|~/.neomuttrc
10|\(em|~/.muttrc
.T&
l s s .
\0\h'0m'\fB*\fP) Note the case of the filename
.TE
\p
.ad
.
.SS "\s-1Other relevant files\s0"
.\" --------------------------------------------------------------------
.PP
Unless otherwise stated, NeoMutt will process all grouped files in the order
(from top to bottom) as they are specified in that listing.
.
.TP
.IR "~/.mailcap"
.TQ
.IR "@MAN_SYSCONFDIR@/mailcap"
User-specific and system-wide definitions for handling non-text MIME types,
look at environment variable \fBMAILCAPS\fP above for additional search
locations.
.
.TP
.IR "~/.neomuttdebug0"
User's default debug log file. For further details or customising file path see
command line options \fB\-d\fP and \fB\-l\fP above.
.
.TP
.IR "/etc/mime.types"
.TQ
.IR "@MAN_SYSCONFDIR@/mime.types"
.TQ
.IR "@MAN_DATADIR@/mime.types"
.TQ
.IR "~/.mime.types"
Description files for simple plain text mapping between MIME types and filename
extensions. NeoMutt parses these files in the stated order while processing
attachments to determine their MIME type.
.
.TP
.IR "@MAN_DOCDIR@/manual." { html , pdf , txt }
The full NeoMutt manual in HTML, PDF or plain text format.
.
.TP
.IR "/tmp/neomutt-XXXX-XXXX-XXXX"
Temporary files created by NeoMutt. For custom locations look at description of
the environment variable \fBTMPDIR\fP above. Notice that the suffix
\fI-XXXX-XXXX-XXXX\fP is just a placeholder for, e.g. hostname, user name/ID,
process ID and/or other random data.
.
.\" --------------------------------------------------------------------
.SH BUGS
.\" --------------------------------------------------------------------
.PP
See issue tracker at <https://github.com/neomutt/neomutt/issues>.
.
.\" --------------------------------------------------------------------
.SH NO WARRANTIES
.\" --------------------------------------------------------------------
.PP
This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
A PARTICULAR PURPOSE. See the GNU General Public License for more details.
.
.\" --------------------------------------------------------------------
.SH SEE ALSO
.\" --------------------------------------------------------------------
.PP
.\" sorted by category and name
.BR gettext (1),
.BR mailx (1),
.BR msmtp (1),
.BR notmuch (1),
.BR sendmail (1),
.BR smail (1),
.BR RAND_egd (3),
.BR curses (3),
.BR ncurses (3),
.BR mailcap (5),
.BR maildir (5),
.BR mbox (5),
.BR neomuttrc (5).
.
.PP
For further NeoMutt information:
.RS 4
.TP
\(bu the full manual, see \fIFILES\fP section above
.TQ
\(bu the home page, <https://neomutt.org>
.RE
.
.\" --------------------------------------------------------------------
.SH AUTHOR
.\" --------------------------------------------------------------------
.PP
Michael Elkins, and others. Use <neomutt-devel@\:neomutt.org> to contact the
developers.
.
