/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef TreeViewSearchLine_H
#define TreeViewSearchLine_H

#include "AbstractSearchLine.h"

#include <QModelIndex>

class QTreeView;
class TreeModelMatchCollector;

class TreeViewSearchLine : public AbstractSearchLine
{
    Q_OBJECT

public:
    explicit TreeViewSearchLine(QWidget* parent);
    ~TreeViewSearchLine();
    void setView(QTreeView* view);

public Q_SLOTS:
    void slotFind(QString);
    void slotFindNext();
    void slotFindPrev();
    void slotFindNext(bool) { slotFindNext(); }
    void slotFindPrev(bool) { slotFindPrev(); }
    void slotSortHappened(int, Qt::SortOrder);
    void slotUpdate();
    void slotUpdate(const QModelIndex&, const QModelIndex&);
    void matchModeChanged(int newIndex);
    void on_actionCaseSensitive__toggled(bool);
    void on_actionWholeWords__toggled(bool);
    void slotClose();

protected:
    void refreshSearch();
    void selectIndex(const QModelIndex& index);
    void clearRequested() {}

    QTreeView* view_;
    int currentResultItem_;
    TreeModelMatchCollector* collector_;
};

#endif
