/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2017 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Benesi Sphere to Cube transform
 * Warps a sphere to a cube; transform made by M.Benesi, optimized by
 * Luca.  Scavenged and edited from code optimized by Luca.
 * @reference http://www.fractalforums.com/mathematics/circle2square/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "TransfBenesiSphereCubeIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfBenesiSphereCubeIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	Q_UNUSED(fractal);
	Q_UNUSED(aux);

	z *= z;
	// if (z.z == 0.0f) z.z = 1e-21f;
	REAL rCyz = native_divide(z.y, z.z);
	if (rCyz < 1.0f)
		rCyz = native_rsqrt(rCyz + 1.0f);
	else
		rCyz = native_rsqrt(native_recip(rCyz) + 1.0f);

	z.y *= rCyz;
	z.z *= rCyz;

	// if (z.x == 0.0f) z.x = 1e-21f;
	REAL rCxyz = native_divide((mad(z.y, z.y, z.z * z.z)), z.x);

	if (rCxyz < 1.0f)
		rCxyz = native_rsqrt(rCxyz + 1.0f);
	else
		rCxyz = native_rsqrt(native_recip(rCxyz) + 1.0f);

	z *= rCxyz * SQRT_3_2;
	return z;
}