// license:BSD-3-Clause
// copyright-holders:David Haywood, Pierpaolo Prazzoli
#ifndef MAME_INCLUDES_SCOTRSHT_H
#define MAME_INCLUDES_SCOTRSHT_H

#pragma once

#include "machine/gen_latch.h"
#include "emupal.h"

class scotrsht_state : public driver_device
{
public:
	scotrsht_state(const machine_config &mconfig, device_type type, const char *tag) :
		driver_device(mconfig, type, tag),
		m_maincpu(*this, "maincpu"),
		m_audiocpu(*this, "audiocpu"),
		m_gfxdecode(*this, "gfxdecode"),
		m_palette(*this, "palette"),
		m_soundlatch(*this, "soundlatch"),
		m_colorram(*this, "colorram"),
		m_videoram(*this, "videoram"),
		m_spriteram(*this, "spriteram"),
		m_scroll(*this, "scroll")
	{ }

	void scotrsht(machine_config &config);

private:
	required_device<cpu_device> m_maincpu;
	required_device<cpu_device> m_audiocpu;
	required_device<gfxdecode_device> m_gfxdecode;
	required_device<palette_device> m_palette;
	required_device<generic_latch_8_device> m_soundlatch;

	required_shared_ptr<uint8_t> m_colorram;
	required_shared_ptr<uint8_t> m_videoram;
	required_shared_ptr<uint8_t> m_spriteram;
	required_shared_ptr<uint8_t> m_scroll;

	tilemap_t *m_bg_tilemap;

	int m_irq_enable;
	int m_charbank;
	int m_palette_bank;

	DECLARE_WRITE8_MEMBER(ctrl_w);
	DECLARE_WRITE8_MEMBER(soundlatch_w);
	DECLARE_WRITE8_MEMBER(videoram_w);
	DECLARE_WRITE8_MEMBER(colorram_w);
	DECLARE_WRITE8_MEMBER(charbank_w);
	DECLARE_WRITE8_MEMBER(palettebank_w);

	TILE_GET_INFO_MEMBER(get_bg_tile_info);

	DECLARE_WRITE_LINE_MEMBER(vblank_irq);

	virtual void video_start() override;
	void scotrsht_palette(palette_device &palette) const;

	uint32_t screen_update(screen_device &screen, bitmap_ind16 &bitmap, const rectangle &cliprect);
	void draw_sprites(bitmap_ind16 &bitmap, const rectangle &cliprect );
	void scotrsht_map(address_map &map);
	void scotrsht_sound_map(address_map &map);
	void scotrsht_sound_port(address_map &map);
};

#endif // MAME_INCLUDES_SCOTRSHT_H
