/**************************************************************************\
 ibtk (Insomnia's Basic ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef IGBOX_H
#define IGBOX_H

#include <X11/X.h>   
#include <X11/Xlib.h>
#include "idodad.h"
#include "iwindow.h"

class IGBox : public IDoDad  {
public:
  IGBox(IWindow *w, int xp, int yp, int xs, int ys);
  virtual ~IGBox();
  virtual int Type()  { return DODAD_BOX; };
  void Disable();
  void Enable();
  virtual void Redraw();
  virtual void Rebuild();
  virtual void Resize(int, int);
  virtual void Move(int, int);
  virtual void MoveAndResize(int, int, int, int);
  virtual int Press(int b, int x, int y);
  virtual int Release(int b, int x, int y);
  void SetClickCallback(void (*cb)(IDoDad *, IDoDad *, int, int));
  void SetDragCallback(void (*cb)(IDoDad *, IDoDad *, int, int, int, int));
  void DrawPoint(int x, int y, int r, int g, int b);
  void DrawLine(int x1, int y1, int x2, int y2, int r, int g, int b);
  void DrawRect(int x1, int y1, int x2, int y2, int r, int g, int b);
  void FillRect(int xp, int yp, int xs, int ys, int r, int g, int b);
protected:
  IGBox() {};
  void Init(IWindow *w, int xp, int yp, int xs, int ys);
  void Create();
  Pixmap Img;
  int xpos, ypos, xsize, ysize;
  int lastx, lasty;
  void (*clickcallback)(IDoDad *, IDoDad *, int, int);
  void (*dragcallback)(IDoDad *, IDoDad *, int, int, int, int);
  };

#endif
