/* ==================================================================== 
 * The Kannel Software License, Version 1.0 
 * 
 * Copyright (c) 2001-2014 Kannel Group  
 * Copyright (c) 1998-2001 WapIT Ltd.   
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 * 
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in 
 *    the documentation and/or other materials provided with the 
 *    distribution. 
 * 
 * 3. The end-user documentation included with the redistribution, 
 *    if any, must include the following acknowledgment: 
 *       "This product includes software developed by the 
 *        Kannel Group (http://www.kannel.org/)." 
 *    Alternately, this acknowledgment may appear in the software itself, 
 *    if and wherever such third-party acknowledgments normally appear. 
 * 
 * 4. The names "Kannel" and "Kannel Group" must not be used to 
 *    endorse or promote products derived from this software without 
 *    prior written permission. For written permission, please  
 *    contact org@kannel.org. 
 * 
 * 5. Products derived from this software may not be called "Kannel", 
 *    nor may "Kannel" appear in their name, without prior written 
 *    permission of the Kannel Group. 
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED.  IN NO EVENT SHALL THE KANNEL GROUP OR ITS CONTRIBUTORS 
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,  
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT  
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR  
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,  
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE  
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,  
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 * ==================================================================== 
 * 
 * This software consists of voluntary contributions made by many 
 * individuals on behalf of the Kannel Group.  For more information on  
 * the Kannel Group, please see <http://www.kannel.org/>. 
 * 
 * Portions of this software are based upon software originally written at  
 * WapIT Ltd., Helsinki, Finland for the Kannel project.  
 */ 

/*
 * pki.c: PKI and certificate handling routines
 *
 */

#include <stdio.h>

#include "gwlib/gwlib.h"
 
#if (HAVE_WTLS_OPENSSL)
 
#include <openssl/rsa.h>
#include <openssl/evp.h>
#include <openssl/objects.h>
#include <openssl/x509.h>
#include <openssl/err.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>

#include "pki.h"

void pki_init(void)
{
        OpenSSL_add_all_algorithms();
        ERR_load_crypto_strings();
}

void pki_shutdown(void)
{
        EVP_cleanup();
}


void get_cert_from_file(Octstr *s, X509 **x509)
{
		char *filename;
		
        /* Check errors!!!! */
        FILE* fp;
        
        /* Open the file specified by "s" */
		filename = octstr_get_cstr(s);
        fp = fopen(filename,"r");
        if (fp == NULL) warning(0,"Can't read certificate %s", filename);

        /* Load up that there certificate */
        *x509 = PEM_read_X509(fp,NULL,NULL,NULL);

        /* Close the file specified by "s" */        
        fclose(fp);

        if (x509 == NULL) {
                ERR_print_errors_fp (stderr);
        }
}

void get_privkey_from_file(Octstr* s, RSA** priv_key, Octstr* passwd)
{
		char *password;
		char *filename;
		
        /* Check errors!!!! */
        FILE* fp;

		filename = octstr_get_cstr(s);
		password = passwd != NULL ? octstr_get_cstr(passwd) : NULL;
        
		/* Open the file specified by "s" */
        fp = fopen(filename,"r");
        if (fp == NULL) warning(0,"Can't read private key %s", filename);
        
        /* Load up that there certificate */
        *priv_key = PEM_read_RSAPrivateKey(fp,NULL,NULL,password);

        /* Close the file specified by "s" */        
        fclose(fp);
        
        if (priv_key == NULL) { 
                ERR_print_errors_fp (stderr);
        }
}

void dump_cert(X509* x509)
{
        
}


void dump_privkey(RSA* priv_key)
{
}

#endif
