#ifndef SSHGUARD_WHITELIST_H
#define SSHGUARD_WHITELIST_H

#include "sshguard_addresskind.h"


int whitelist_init(void);

int whitelist_conf_init(void);
int whitelist_conf_fin(void);

int whitelist_fin(void);

int whitelist_file(char *filename);

/* wrapper for _add_ip, _add_block and _add_host */
int whitelist_add(char *str);

int whitelist_add_ipv4(char *ip);
int whitelist_add_ipv6(char *ip);
int whitelist_add_block4(char *address, int masklen);
int whitelist_add_block6(char *address, int masklen);
int whitelist_add_host(char *host);

int whitelist_match(char *addr, int addrkind);

#endif

