/* the symbol table definitions */
%{
#include "attack_parser.tab.h"
#include "attack_parser.h"

YY_BUFFER_STATE bufstate;

int parse_line(char *str) {
    int ret;
    
    yy_scan_string (str);
    ret = yyparse();
    yy_delete_buffer(YY_CURRENT_BUFFER);

    return ret;
}

%}

%option noyywrap

MONTH       (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)
DAYNO       [1-9][0-9]?
HOUR        (0|1)[0-9]|2[0-4]
MINPS       [0-5][0-9]
WORD        [a-zA-Z0-9][-_a-zA-Z0-9]+
NUMBER      [1-9][0-9]*
%%

 /* SSH: invalid or rejected user (cross platform [generated by openssh]) */
"Invalid user "{WORD}" from "                                      { return SSH_INVALUSERPREF; }
"User "{WORD}" from "                                           { return SSH_NOTALLOWEDPREF; }
" not allowed because ".+                                       { return SSH_NOTALLOWEDSUFF; }

 /* SSH: authentication error (user OK, password KO) */
 /* FreeBSD and Mac OS X */
"error: PAM: "[aA]"uthentication "(failure|error)" for "{WORD}" from "           { return SSH_LOGINERR_OPENPAM; }
 /* Linux */
"authentication failure; logname=".*" rhost="                   { return SSH_LOGINERR_LINUXPAMPREF; }
"user=".*                                                       { return SSH_LOGINERR_LINUXPAMSUFF; }
 /* OpenBSD */
"Failed password for "{WORD}" from"                             { return SSH_LOGINERR_OPENBSD; }


 /**         COMMON-USE TOKENS       do not touch these          **/
 /* an IPv4 address */
(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]([0-9])?)(\.(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]([0-9])?|0)){3} { yylval.str = yytext; return IPv4; }
 /* an IPv6 address */
((([a-fA-F0-9]{1,4}:){2}(:[a-fA-F0-9]{1,4}){1,5})|(:(:[a-fA-F0-9]{1,4}){1,6}|([a-fA-F0-9]{1,4}:)(:[a-fA-F0-9]{1,4}){1,6}|([a-fA-F0-9]{1,4}:){2}(:[a-fA-F0-9]{1,4}){1,5}|([a-fA-F0-9]{1,4}:){3}(:[a-fA-F0-9]{1,4}){1,4}|([a-fA-F0-9]{1,4}:){4}(:[a-fA-F0-9]{1,4}){1,3}|([a-fA-F0-9]{1,4}:){5}(:[a-fA-F0-9]{1,4}){1,2}|([a-fA-F0-9]{1,4}:){6}:[a-fA-F0-9]{1,4}))           { yylval.str = yytext; return IPv6;  }

 /* an host address (PTR) */
localhost|([-a-zA-Z0-9]+\.)+[a-zA-Z]+                           { yylval.str = yytext; return HOSTADDR; }
{NUMBER}                                                        { return INTEGER; }
 /* syslog timestamp */
{MONTH}\ +{DAYNO}\ +{HOUR}:{MINPS}:{MINPS}                      { return TIMESTAMP_SYSLOG; }
 /* TAI64 timestamp */
[0-9A-Fa-f]{8}                                                  { return TIMESTAMP_TAI64; }

{WORD}                                                          { return WORD; }
[ \t]+            /* eat blanks */
 /* literals */
\n                                                              { return NEWLINE; }
.                                                               { return yytext[0]; }

 /**         end of COMMON-USE TOKENS                           **/

