#!/usr/bin/perl
#
# POP3 authenticator for Squid
# Copyright (C) 2006 Henrik Nordstrom <henrik@henriknordstrom.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
# 
# Change log:
#   2006-12-10	henrik	Initial revision
#


use Net::POP3;
$|=1;

if ( @ARGV != 1 ) {
    print STDERR "Usage: $0 popserver\n";
    exit 1
}

$server = shift @ARGV;

while(<>) {
    my ($username, $password) = split(/\s+/);
    $username =~ s/%([0-9a-f][0-9a-f])/pack("H2",$1)/gie;
    $password =~ s/%([0-9a-f][0-9a-f])/pack("H2",$1)/gie;

    $pop = Net::POP3->new($server);
    if (!$pop) {
	print "ERR Server not responding\n";
	next;
    }

    # Here apop could be used instead for MD5 support
    if ($pop->login($username, $password)) {
	print "OK\n";
    } else {
	print "ERR\n";
    }
    $pop->quit;
    undef $pop;
}
