/*
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *                                                            1998, 2010
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * Support:
 *     http://sourceforge.net/projects/sarg/forums/forum/363374
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void siteuser(void)
{

   FILE *fp_in, *fp_ou;

   char user[MAXLEN];
   char url[MAXLEN];
   char wuser[MAXLEN];
   char ourl[MAXLEN];
   char csort[255];
   char general[MAXLEN];
   char general2[MAXLEN];
   char per[MAXLEN];
   char sites[MAXLEN];
   char report[MAXLEN];
   char period[100];
   int regs=0;
   int ucount=0;
   char *users;
   long long int nbytes;
   long long int obytes;
   long long int nacc;
   int cstatus;
   struct getwordstruct gwarea;

   if(Privacy)
      return;

   nsitesusers = 0;
   sprintf(general,"%s/sarg-general",dirname);
   sprintf(sites,"%s/sarg-sites",dirname);
   sprintf(general2,"%s/sarg-general2",dirname);
   sprintf(per,"%s/sarg-period",dirname);
   sprintf(report,"%s/siteuser.html",dirname);

   if ((fp_in = fopen(per, "r")) == 0) {
      fprintf(stderr, "SARG: (siteuser) %s: %s\n",text[45],per);
      exit(1);
   }

   if (!fgets(period,sizeof(period),fp_in)) {
      fprintf(stderr,"SARG: (siteuser) read error in %s\n",per);
      exit(1);
   }
   fclose(fp_in);

   sprintf(csort,"sort -k 4,4 -k 1,1 -o \"%s\" \"%s\"",general2,general);
   cstatus=system(csort);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: sort command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: sort command: %s\n",csort);
      exit(1);
   }

   if((fp_in=fopen(general2,"r"))==NULL) {
     fprintf(stderr, "SARG: (topsite) %s: %s\n",text[8],general2);
     fprintf(stderr, "SARG: sort command: %s\n",csort);
     exit(1);
   }

   if((fp_ou=fopen(report,"w"))==NULL) {
     fprintf(stderr, "SARG: (topsite) %s: %s\n",text[8],report);
     exit(1);
   }

   fprintf(fp_ou, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   css(fp_ou);
   fputs("</head>\n",fp_ou);
   //if(strlen(FontFace) > 0) fprintf(fp_ou,"<font face=\"%s\">\n",FontFace);
   fprintf(fp_ou,"<body bgcolor=\"%s\" text=\"%s\" background=\"%s\">\n",BgColor,TxColor,BgImage);
   write_logo_image(fp_ou);

   if(strcmp(IndexTree,"date") == 0)
      show_sarg(fp_ou, "../../..");
   else
      show_sarg(fp_ou, "..");

   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ou);
   fprintf(fp_ou,"<tr><th class=\"title\">%s</th></tr>\n",Title);

   fprintf(fp_ou,"<tr><td class=\"header3\">%s: %s</td></tr>\n",text[89],period);
   fprintf(fp_ou,"<tr><th class=\"header3\">%s</th></tr>\n",text[85]);
   fputs("</table></div>\n",fp_ou);

   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"2\">\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   if(BytesInSitesUsersReport)
      fprintf(fp_ou,"<tr><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th></tr>\n",text[100],text[91],text[93],text[103]);
   else
      fprintf(fp_ou,"<tr><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th></tr>\n",text[100],text[91],text[103]);

   user[0]='\0';
   ourl[0]='\0';
   obytes=0;

   if((users=(char *) malloc(204800))==NULL){
      fprintf(stderr, "SARG: ERROR: %s",text[87]);
      exit(1);
   }
   strcpy(users," ");

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword_start(&gwarea,buf);
      if (getword(user,sizeof(user),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have an invalid user in the %s file of the siteuser.\n",general2);
         exit(1);
      }
      if(strcmp(user,"TOTAL") == 0)
         continue;
      if(userip)
         fixip(user);

      get_usertab_name(user,name,sizeof(name));

      if(dotinuser && strchr(name,'_')) {
         subs(name,sizeof(name),"_",".");
      }

      /*
      In fact, even the first call is unecessary as the resolved user variable is never used.
      if(Ip2Name)
         ip2name(user,sizeof(user));
      */

      /*
      Is this redundant ip2name a mistake or is it really necessary ? It definitely slow down sarg
      if the first ip2name succeed because it will try to resolve a name which is not an IP but if
      the first ip2name failed, the second attempt may find the expected address which was resolved
      in the mean time by the DNS server.
      if(Ip2Name)
         ip2name(user,sizeof(user));
      */

      if (getword_atoll(&nacc,&gwarea,'\t')<0){
         printf("SARG: Maybe you have an invalid number of access in your %s file of the siteuser.\n",general2);
         exit(1);
      }
      if (nacc > 0) nsitesusers = 1;
      if (getword_atoll(&nbytes,&gwarea,'\t')<0){
         printf("SARG: Maybe you have an invalid number of bytes in your %s file of the siteuser.\n",general2);
         exit(1);
      }
      if (getword(url,sizeof(url),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have an invalid url in your %s file of the siteuser.\n",general2);
         exit(1);
      }

      if(!regs) {
         strcpy(ourl,url);
         obytes=nbytes;
         regs++;
      }

      sprintf(wuser," %s ",name);
      if(strstr(users,wuser) == 0 && strcmp(url,ourl) == 0) {
         strcat(users,name);
         strcat(users," ");
         ucount++;
         if(ucount>4) {
            strcat(users,"<br>");
            ucount=0;
         }
      }

      if(SiteUsersReportLimit) {
         if(regs >= SiteUsersReportLimit)
            continue;
      }

      if(BlockIt[0]!='\0')
         sprintf(BlockImage,"<a href=\"%s%s?url=%s\"><img src=\"../images/sarg-squidguard-block.png\" border=\"0\"></a>&nbsp;",wwwDocumentRoot,BlockIt,ourl);
      else BlockImage[0]='\0';

      if(strcmp(url,ourl) != 0 && nsitesusers) {
         if(BytesInSitesUsersReport) {
            sprintf(wwork2,"%s",fixnum(obytes,1));
            fprintf(fp_ou,"<tr><td class=\"data\">%d</td><td class=\"data2\">%s<a href=\"http://%s\">%s</a></td><td class=\"data\">%s</td><td class=\"data2\">%s</td></tr>\n",regs,BlockImage,ourl,ourl,wwork2,users);
         } else
            fprintf(fp_ou,"<tr><td class=\"data\">%d</td><td class=\"data2\">%s<a href=\"http://%s\">%s</a></td><td class=\"data2\">%s</td></tr>\n",regs,BlockImage,ourl,ourl,users);
         regs++;
         ucount=0;
         strcpy(users,name);
         strcat(users," ");
         strcpy(ourl,url);
         obytes=nbytes;
      }
   }

   if(nsitesusers) {
      fprintf(fp_ou,"<tr><td class=\"data\">%d</td><td class=\"data2\"><a href=\"http://%s\">%s</a></td><td class=\"data2\">%s</td></tr>\n",regs,ourl,ourl,users);
   }

   unlink(general2);

   fputs("</table>\n</div>\n",fp_ou);

   show_info(fp_ou);

   fputs("</body>\n</html>\n",fp_ou);

   fclose(fp_in);
   fclose(fp_ou);

   if(users)
      free(users);

   return;

}
