unit AdminServerHealthGraphSettings;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, myx_admin_public_interface, ComCtrls, AuxFuncs,
  TntForms, TntStdCtrls, TntComCtrls,
  AdminServerHealthLineGraph, AdminServerHealthBarGraph;

type
  TAdminServerHealthGraphSettingsForm = class(TTntForm)
    ValueSettingsGBox: TTntGroupBox;
    CancelBtn: TTntButton;
    ApplyBtn: TTntButton;
    Label3: TTntLabel;
    ValueUnitCBox: TTntComboBox;
    ValueFormulaMemo: TTntMemo;
    Label6: TTntLabel;
    GeneralGBox: TTntGroupBox;
    CaptionLbl: TTntLabel;
    CaptionEd: TTntEdit;
    DisplayCaptionCBox: TTntCheckBox;
    Label2: TTntLabel;
    GraphTypeCBox: TTntComboBox;
    MinMaxGBox: TTntGroupBox;
    Label4: TTntLabel;
    MinValueEd: TTntEdit;
    Label5: TTntLabel;
    MaxValueEd: TTntEdit;
    AutoextendValueCBox: TTntCheckBox;
    Label7: TTntLabel;
    MaxFormularEd: TTntEdit;
    Label8: TTntLabel;
    ValueCaptionEd: TTntEdit;
    MaxCaptionLbl: TTntLabel;
    MaxCaptionEd: TTntEdit;
    Label10: TTntLabel;
    RefreshTimeCBox: TTntComboBox;
    CaptionDescLbl: TTntLabel;
    DisplayCaptionDescLbl: TTntLabel;
    GraphTypeDescLbl: TTntLabel;
    Label14: TTntLabel;
    Label15: TTntLabel;
    Label16: TTntLabel;
    Label17: TTntLabel;
    Label18: TTntLabel;
    Label19: TTntLabel;
    Label20: TTntLabel;
    Label21: TTntLabel;
    MaxCaptionDescLbl: TTntLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

    procedure SetGraph(GraphFrameBundle: TGraphFrameBundle);
    procedure ApplyBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure ValueFormulaMemoDragOver(Sender, Source: TObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean);
    procedure ValueFormulaMemoDragDrop(Sender, Source: TObject; X,
      Y: Integer);
    procedure SetGraphValues(graph: TMYX_HEALTH_GRAPH);
    function GetGraphWithValues(pos: integer): TMYX_HEALTH_GRAPH;

    procedure NewGraph(GroupBox: TTntGroupBox);
    procedure FormDeactivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure GraphTypeCBoxCloseUp(Sender: TObject);
    procedure TntFormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    graph: TMYX_HEALTH_GRAPH;
    GraphFrameBundle: TGraphFrameBundle;
    GroupBox: TTntGroupBox;
  public
    { Public declarations }
  end;

implementation

uses AdminServerHealth, ApplicationDataModule;

{$R *.dfm}

procedure TAdminServerHealthGraphSettingsForm.FormCreate(Sender: TObject);
begin
  InitForm(self);
  ApplicationDM.Options.RestoreWindowPos(self);

  GraphFrameBundle:=nil;
  graph:=nil;
end;

procedure TAdminServerHealthGraphSettingsForm.FormDestroy(Sender: TObject);
begin
  //
end;

procedure TAdminServerHealthGraphSettingsForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  ApplicationDM.Options.AddWindowPos(self);
end;

procedure TAdminServerHealthGraphSettingsForm.SetGraph(GraphFrameBundle: TGraphFrameBundle);
begin
  self.GraphFrameBundle:=GraphFrameBundle;
  if(GraphFrameBundle<>nil)then
    self.graph:=GraphFrameBundle.graph
  else
    graph:=nil;

  if(graph<>nil)then
  begin
    CaptionEd.Text:=graph.graph_caption;
    DisplayCaptionCBox.Checked:=(graph.display_graph_caption=1);
    GraphTypeCBox.ItemIndex:=Ord(graph.graphtype)-1;
    GraphTypeCBox.Enabled:=False;
    GraphTypeCBoxCloseUp(self);
    GraphTypeCBox.Enabled:=False;

    ValueFormulaMemo.Text:=graph.value_formula;
    ValueUnitCBox.ItemIndex:=Ord(graph.value_unit);
    ValueCaptionEd.Text:=graph.value_caption;

    MinValueEd.Text:=FormatFloat('#######0.##', graph.min);
    MaxValueEd.Text:=FormatFloat('#######0.##', graph.max);
    AutoextendValueCBox.Checked:=(graph.autoextend_max=1);
    MaxFormularEd.Text:=graph.max_formula;
    MaxCaptionEd.Text:=graph.max_caption;
  end
  else
  begin
    CaptionEd.Text:='';
    DisplayCaptionCBox.Checked:=False;
    GraphTypeCBox.ItemIndex:=0;
    GraphTypeCBox.Enabled:=True;
    GraphTypeCBoxCloseUp(self);
    GraphTypeCBox.Enabled:=True;

    ValueFormulaMemo.Text:='';
    ValueUnitCBox.ItemIndex:=0;
    ValueCaptionEd.Text:='';

    MinValueEd.Text:='0';
    MaxValueEd.Text:='100';
    AutoextendValueCBox.Checked:=False;
    MaxFormularEd.Text:='';
    MaxCaptionEd.Text:='';
  end;
end;

procedure TAdminServerHealthGraphSettingsForm.NewGraph(
  GroupBox: TTntGroupBox);
begin
  self.GroupBox:=GroupBox;

  SetGraph(nil);
end;

procedure TAdminServerHealthGraphSettingsForm.SetGraphValues(
  graph: TMYX_HEALTH_GRAPH);
begin
  GroupBox:=nil;

  graph.graph_caption:=CaptionEd.Text;
  graph.display_graph_caption:=Ord(DisplayCaptionCBox.Checked);
  case GraphTypeCBox.ItemIndex+1 of
    Ord(MYX_LINE_GRAPH):
      graph.graphtype:=MYX_LINE_GRAPH;
    Ord(MYX_BAR_GRAPH):
      graph.graphtype:=MYX_BAR_GRAPH;
  end;


  graph.value_formula:=ValueFormulaMemo.Text;
  case ValueUnitCBox.ItemIndex of
    Ord(MYX_HGVU_PERCENTAGE):
      graph.value_unit:=MYX_HGVU_PERCENTAGE;
    Ord(MYX_HGVU_COUNT):
      graph.value_unit:=MYX_HGVU_COUNT;
    Ord(MYX_HGVU_BYTE):
      graph.value_unit:=MYX_HGVU_BYTE;
    Ord(MYX_HGVU_SECONDS):
      graph.value_unit:=MYX_HGVU_SECONDS;
  end;

  graph.value_caption:=ValueCaptionEd.Text;

  graph.min:=StrToFloat(MinValueEd.Text);
  graph.max:=StrToFloat(MaxValueEd.Text);
  graph.autoextend_max:=Ord(AutoextendValueCBox.Checked);
  graph.max_formula:=MaxFormularEd.Text;
  graph.max_caption:=MaxCaptionEd.Text;

  case RefreshTimeCBox.ItemIndex of
    0:
      graph.refreshtime:=200;
    1:
      graph.refreshtime:=500;
    2:
      graph.refreshtime:=1000;
    3:
      graph.refreshtime:=2000;
    4:
      graph.refreshtime:=5000;
    5:
      graph.refreshtime:=10000;
    6:
      graph.refreshtime:=15000;
    7:
      graph.refreshtime:=30000;
    8:
      graph.refreshtime:=60000;
  end;

  if(GraphFrameBundle.GraphFrame is TAdminServerHealthBarGraphFrame)then
  begin
    with TAdminServerHealthBarGraphFrame(GraphFrameBundle.GraphFrame) do
    begin
      CaptionPnl.Visible:=DisplayCaptionCBox.Checked;
      CaptionLbl.Caption:=CaptionEd.Text;
      ValueUnit:=graph.value_unit;
      ValueCaption:=ValueCaptionEd.Text;
      MaxCaption:=MaxCaptionEd.Text;
    end;
  end
  else if(GraphFrameBundle.GraphFrame is TAdminServerHealthLineGraphFrame)then
  begin
    with TAdminServerHealthLineGraphFrame(GraphFrameBundle.GraphFrame) do
    begin
      ValueUnit:=graph.value_unit;
    end;
  end;
end;

function TAdminServerHealthGraphSettingsForm.GetGraphWithValues(pos: integer): TMYX_HEALTH_GRAPH;
var graph: TMYX_HEALTH_GRAPH;
  graphtype: MYX_HEALTH_GRAPH_TYPE;
  value_unit: MYX_HEALTH_GRAPH_VALUE_UNIT;
  refreshtime: integer;
begin
  case GraphTypeCBox.ItemIndex+1 of
    Ord(MYX_LINE_GRAPH):
      graphtype:=MYX_LINE_GRAPH;
    Ord(MYX_BAR_GRAPH):
      graphtype:=MYX_BAR_GRAPH;
  else
    graphtype:=MYX_LINE_GRAPH;
  end;

  case ValueUnitCBox.ItemIndex of
    Ord(MYX_HGVU_PERCENTAGE):
      value_unit:=MYX_HGVU_PERCENTAGE;
    Ord(MYX_HGVU_COUNT):
      value_unit:=MYX_HGVU_COUNT;
    Ord(MYX_HGVU_BYTE):
      value_unit:=MYX_HGVU_BYTE;
    Ord(MYX_HGVU_SECONDS):
      value_unit:=MYX_HGVU_SECONDS;
  else
    value_unit:=MYX_HGVU_PERCENTAGE;
  end;

  case RefreshTimeCBox.ItemIndex of
    0:
      refreshtime:=200;
    1:
      refreshtime:=500;
    2:
      refreshtime:=1000;
    3:
      refreshtime:=2000;
    4:
      refreshtime:=5000;
    5:
      refreshtime:=10000;
    6:
      refreshtime:=15000;
    7:
      refreshtime:=30000;
    8:
      refreshtime:=60000;
  else
    refreshtime:=1000;
  end;

  graph:=TMYX_HEALTH_GRAPH.create(CaptionEd.Text,
    Ord(DisplayCaptionCBox.Checked), graphtype, value_unit,
    StrToFloat(MinValueEd.Text), StrToFloat(MaxValueEd.Text),
    Ord(AutoextendValueCBox.Checked), ValueFormulaMemo.Text,
    MaxFormularEd.Text, ValueCaptionEd.Text,
    ValueCaptionEd.Text, MaxCaptionEd.Text, MaxCaptionEd.Text,
    refreshtime, pos);

  Result:=graph;
end;

procedure TAdminServerHealthGraphSettingsForm.ApplyBtnClick(
  Sender: TObject);
var current_widget_ypos: integer;
  i: integer;
  PageNr, GroupNr: integer;
begin
  if(graph<>nil)then
    SetGraphValues(graph)
  else
  begin
    graph:=GetGraphWithValues(GroupBox.ComponentCount+1);

    //Add graph to HealthPages
    PageNr:=TTabSheet(GroupBox.Parent.Parent).TabIndex;
    GroupNr:=0;
    for i:=0 to GroupBox.Parent.ControlCount-1 do
      if(GroupBox=GroupBox.Parent.Controls[i])then
      begin
        GroupNr:=i;
        break;
      end;

    if(PageNr<TAdminServerHealthForm(Owner).HealthPages.pages.Count)then
      if(GroupNr<TAdminServerHealthForm(Owner).HealthPages.pages[PageNr].groups.Count)then
        TAdminServerHealthForm(Owner).HealthPages.pages[
          PageNr].groups[GroupNr].graphs.Add(graph);

    current_widget_ypos:=GroupBox.Height;

    TAdminServerHealthForm(Owner).AddGraphToGroupBox(GroupBox, graph, current_widget_ypos);

    for i:=0 to GroupBox.Owner.ComponentCount-1 do
      if(GroupBox.Owner.Components[i] is TTntGroupBox)then
        if(TTntGroupBox(GroupBox.Owner.Components[i]).Top>
          GroupBox.Top)then
          TTntGroupBox(GroupBox.Owner.Components[i]).Top:=
            TTntGroupBox(GroupBox.Owner.Components[i]).Top+
            current_widget_ypos-GroupBox.Height;
            
    GroupBox.Height:=current_widget_ypos;
  end;


  TAdminServerHealthForm(Owner).RefreshSystemVarsInFormulas:=True;

  graph:=nil;

  ModalResult:=mrOK;
  Hide;

  TAdminServerHealthForm(Owner).SaveGraphs;
end;

procedure TAdminServerHealthGraphSettingsForm.CancelBtnClick(
  Sender: TObject);
begin
  graph:=nil;

  ModalResult:=mrCancel;
  Hide;
end;

procedure TAdminServerHealthGraphSettingsForm.ValueFormulaMemoDragOver(
  Sender, Source: TObject; X, Y: Integer; State: TDragState;
  var Accept: Boolean);
begin
  Accept:=False;

  if(Source is TTntListView)then
    if(TTntListView(Source).Owner=Owner)then
      Accept:=True;
end;

procedure TAdminServerHealthGraphSettingsForm.ValueFormulaMemoDragDrop(
  Sender, Source: TObject; X, Y: Integer);
var i: integer;
  lastChar: WideString;
  ListView: TTntListView;
begin
  if(Source is TTntListView)and(Sender.InheritsFrom(TCustomEdit))then
  begin
    with Owner as TAdminServerHealthForm do
    begin
      if(HealthPageControl.ActivePage=ServerStatusTabSheet)then
        ListView:=ServerStatusListView
      else if(HealthPageControl.ActivePage=ServerVariablesTabSheet)then
        ListView:=VariablesListView
      else
        ListView:=nil;

      if(ListView<>nil)then
      begin
        for i:=0 to ListView.Items.Count-1 do
          if(ListView.Items[i].Selected)then
          begin
            lastChar:=Copy(TCustomEdit(Sender).Text, Length(TCustomEdit(Sender).Text), 1);
            if(lastChar<>'')and(lastChar<>'+')and(lastChar<>'-')and
              (lastChar<>'*')and(lastChar<>'/')then
              TCustomEdit(Sender).Text:=TCustomEdit(Sender).Text+'+';

            TCustomEdit(Sender).Text:=TCustomEdit(Sender).Text+
              '['+ListView.Items[i].Caption+']';
          end;
      end;
    end;

    TCustomEdit(Sender).SetFocus;
    TCustomEdit(Sender).SelStart:=Length(TCustomEdit(Sender).Text);
  end;
end;

procedure TAdminServerHealthGraphSettingsForm.FormDeactivate(
  Sender: TObject);
begin
  AlphaBlendValue:=220;
end;

procedure TAdminServerHealthGraphSettingsForm.FormActivate(
  Sender: TObject);
begin
  AlphaBlendValue:=255;
end;

procedure TAdminServerHealthGraphSettingsForm.GraphTypeCBoxCloseUp(
  Sender: TObject);
begin
  if(GraphTypeCBox.ItemIndex=1)then
  begin
    CaptionLbl.Enabled:=True;
    CaptionEd.Enabled:=True;
    CaptionDescLbl.Enabled:=True;

    DisplayCaptionCBox.Enabled:=True;
    DisplayCaptionDescLbl.Enabled:=True;

    MaxCaptionLbl.Enabled:=True;
    MaxCaptionEd.Enabled:=True;
    MaxCaptionDescLbl.Enabled:=True;
  end
  else
  begin
    CaptionLbl.Enabled:=False;
    CaptionEd.Text:='';
    CaptionEd.Enabled:=False;
    CaptionDescLbl.Enabled:=False;

    DisplayCaptionCBox.Enabled:=False;
    DisplayCaptionCBox.Checked:=False;
    DisplayCaptionDescLbl.Enabled:=False;

    MaxCaptionLbl.Enabled:=False;
    MaxCaptionEd.Enabled:=False;
    MaxCaptionDescLbl.Enabled:=False;
  end;
end;

procedure TAdminServerHealthGraphSettingsForm.TntFormKeyDown(
  Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if(Key=VK_ESCAPE)then
    CancelBtnClick(self);
end;

end.
