/*
	coloranim2.c - animate color2

	Author:	Susumu Shiohara (shiohara@tpp.epson.co.jp)

	  Copyright 1993-1997 by Susumu Shiohara

			All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

#define RedPercent		0.299
#define GreenPercent	0.587
#define BluePercent		0.114

typedef struct {
	int	idx;
	double	intensity;
} IntensT;

static IntensT t[256];
static int mapsize;

#if defined(__STDC__) || defined(__cplusplus)
static void qsortIntens(int from,int to)
#else
static void qsortIntens(from,to)
int from,to;
#endif
{
int i,j;
double mean;
IntensT tmp;

	i = from;
	j = to;
	mean = (t[i].intensity + t[j].intensity) / 2;

	while(True){
		while(t[i].intensity < mean)
			i++;

		while(t[j].intensity > mean)
			j--;

		if(i <= j){
			tmp  = t[i];
			t[i] = t[j];
			t[j] = tmp;
			i++;
			j--;
		}
		else
			break;
	}

	if(from < j)
		qsortIntens(from, j);

	if(i < to)
		qsortIntens(i, to);
}

static void colorAnimate2()
{
int i,j;
XColor xc;

	for (i = 0; i < mapsize; i++) {
		t[i].intensity =  xcolors[i].red * RedPercent 
						+ xcolors[i].green * GreenPercent 
						+ xcolors[i].blue * BluePercent;
		t[i].idx = i;
	}

	/* Sort color table by it's intensity */
	qsortIntens(0, mapsize - 1);

	for(i = 0; i < mapsize; i++)
		if(t[i].intensity != 0)
			break;

	for(; i < mapsize; i++){
		for(j = 0; j < 256; j++){
			xc.red   = (word)((int)xcolors[t[i].idx].red   * j / 255);
			xc.green = (word)((int)xcolors[t[i].idx].green * j / 255);
			xc.blue  = (word)((int)xcolors[t[i].idx].blue  * j / 255);
			xc.flags = xcolors[t[i].idx].flags;
			xc.pixel = xcolors[t[i].idx].pixel;
			StoreColors(&xc, 1);
			myusleep(0); /* Flush */
			if(gotSomeAction == True)
				return;
		}
		myusleep(app_data.colorAnimTicks);	/* Force procs */
	}
}

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xcoloranimate2show(char *fname)	/* color animate2 */
#else
ActionStatus xcoloranimate2show(fname)
char *fname;
#endif
{
	mapsize = gim.subImageList->mapsize;

	PreDisplay();
	PreFadeColors(mapsize);

	if(app_data.showFileName)
		createFileNameWindow(fname);

	ShowImage(  (windowWidth-gim.subImageList->width)/2,
				(windowHeight-gim.subImageList->height)/2,
				gim.subImageList->width,gim.subImageList->height);

	colorAnimate2();

	StoreColors(xcolors,mapsize);

	if(app_data.showFileName)
		raiseFileNameWindow();

	return(mywait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxcoloranimate2show(char *fname)	/* color animate2 */
#else
void postxcoloranimate2show(fname)
char *fname;
#endif
{
	if(app_data.showFileName)
		removeFileNameWindow();

	FadeColors(True, mapsize);
}

