#!/bin/bash
# Another 'cat' here document, using parameter substitution.

# Try it with no command line parameters,   ./scriptname
# Try it with one command line parameter,   ./scriptname Mortimer
# Try it with one two-word quoted command line parameter,
#                           ./scriptname "Mortimer Jones"

CMDLINEPARAM=1     # Expect at least command line parameter.

if [ $# -ge $CMDLINEPARAM ]
then
  NAME=$1          # If more than one command line param,
                   # then just take the first.
else
  NAME="John Doe"  # Default, if no command line parameter.
fi  

RESPONDENT="the author of this fine script"  
  

cat &lt;&lt;Endofmessage

Hello, there, $NAME.
Greetings to you, $NAME, from $RESPONDENT.

# This comment shows up in the output (why?).

Endofmessage

# Note that the blank lines show up in the output.
# So does the "comment".

exit 0
