#########################################################
#                                                       #
#             Test PloneArticle                         #
#                                                       #
#              (c)2002 Ingeniweb                        #
#                                                       #
#########################################################

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))


from Products.PloneTestCase import PloneTestCase
from Testing import ZopeTestCase

from Acquisition import aq_base

#Security/Permission
from AccessControl.Permissions import change_images_and_files, view_management_screens
from AccessControl.SecurityManagement import newSecurityManager, noSecurityManager, getSecurityManager
from AccessControl import Unauthorized
from Products.CMFCore.CMFCorePermissions import *
from AccessControl.User import UnrestrictedUser

_standard_permissions = ZopeTestCase._standard_permissions
_member_permissions   = [ListPortalMembers, ListUndoableChanges, ReplyToItem, SetOwnPassword, SetOwnProperties, ] + _standard_permissions  # Plone member permissions
_access_permissions   = [view_management_screens,]                      # Access attachment attributes (this is a silly permissions, for test purposes only)
_edit_permissions     = [change_images_and_files,]                      # Edit attachment attributes (silly permission as well)
_all_permissions      = _standard_permissions+_access_permissions

# Get global vars
from Products.PloneArticle.global_symbols import *

#Install our product 
PloneTestCase.installProduct('PloneArticle')
PloneTestCase.setupPloneSite()



# Other imports
from Products.CMFCore.utils import getToolByName

from Products.CMFCore.interfaces.DublinCore import DublinCore




# Set log options if Log module is available
# This is done to set LOG_PROCESSORs to file logs instead of Zope logs
try:
    import Log

    Log.LOG_LEVEL = Log.LOG_DEBUG

    Log.LOG_PROCESSOR = {
        Log.LOG_NONE: Log.logFile,
        Log.LOG_CRITICAL: Log.logFile,
        Log.LOG_ERROR: Log.logFile,
        Log.LOG_WARNING: Log.logFile,
        Log.LOG_NOTICE: Log.logFile,
        Log.LOG_DEBUG: Log.logFile,
        }

    from Log import *
    Log(LOG_NOTICE, "Starting %s at %d debug level" % (os.path.dirname(__file__), LOG_LEVEL, ))

except:
    print "Log module not available"
    LOG_DEBUG = None
    LOG_NOTICE = None
    LOG_WARNING = None
    LOG_ERROR = None
    LOG_CRITICAL = None
    def Log(*args, **kw):
        pass
    raise

class TestPloneArticle(PloneTestCase.PloneTestCase):

    """
    def login(self, user = None):
        "user must be an acl_user's user"
        self.logout()                   # Is this necessary ? Well, at least, it's clean.
        if not user:
            user = self._user
        newSecurityManager(None, user)

    def loginMember(self, name):
        uf = self.plone.acl_users
        self.login(uf.getUserById(name).__of__(uf))             # The __of__ is necessary in order to make Owned.ownerInfo (line 239 of AccessControl.Owned) work


       # Get Zope user and CMF member objects
        u = uf.getUserById(name).__of__(uf)
        self.login(u)
        member = self.membership_tool.getAuthenticatedMember()

        # Create member area if necessary
        portal_user = self.memberdata_tool.wrapUser(u)
        if self.membership_tool.getHomeUrl(portal_user.getId()) is None:
            #Log(LOG_DEBUG, "Create personal member area for %s" % (name, ))
            self.membership_tool.createMemberarea(portal_user.getId())
        #Log(LOG_DEBUG, "Joined user '%s'" % (name,))
        return u
    """
    def createMember(self, id, pw, email, roles=('Member',)):
        pr = self.portal.portal_registration
        member = pr.addMember(id, pw, roles, properties={ 'username': id, 'email' : email })
        #self.failUnless(id in self.portal.Members.objectIds())
        return member
    
    def installation(self, productName):
        self.qi = self.portal.portal_quickinstaller
        self.qi.installProduct(productName)
        
    def setupSecurityContext(self,):
        self.logout()
        self.loginAsPortalOwner()
        # Create a few members
        self.user1 = self.createMember('user1', 'abcd4', 'abc@domain.tld')
        self.user2 = self.createMember('user2', 'abcd4', 'abc@domain.tld')
        self.user3 = self.createMember('user3', 'abcd4', 'abc@domain.tld')
        
        self.folder = self.portal.portal_membership.getHomeFolder('user1')
        self.installation('PloneArticle')
        self.logout()
    
    def afterSetUp(self,):
        """
        afterSetUp(self) => This method is called to create an empty PloneArticle.
        It also joins three users called 'user1', 'user2' and 'user3'.
        """
        #some usefull properties/tool
        self.catalog = getToolByName(self.portal, "portal_catalog")
        self.workflow = getToolByName(self.portal, "portal_workflow")
        self.membershipTool = getToolByName(self.portal, "portal_membership")
        self.memberdataTool = getToolByName(self.portal, "portal_memberdata")
        
        self.setupSecurityContext()
        
        self.login('user1')
        self.createArticle()
        
        
        
        
        
    """
    def getSampleArticle(self,):
        # Login
        self.loginMember("user1")
        home = self.membership_tool.getHomeFolder()

        # Content creation
        content_id = "article"
        self.membership_tool.getHomeFolder().invokeFactory(
            type_name = 'PloneArticle',
            id = content_id
            )
        return getattr(home, content_id)
    """
    
    def createArticle(self, ):
        """
        Create new folder in home directory & check its basic properties and behaviour
        """
        # Content creation
        self.contentId = 'myArticle'
        
        self.folder.invokeFactory(type_name='PloneArticle', id=self.contentId)
        self.failUnless(self.contentId in self.folder.objectIds(), "Object has not been created or not with the right id")
        self.article = getattr(self.folder, self.contentId)

        self.assertEqual(self.article.title, '')
        self.assertEqual(self.article.id, self.contentId)
        self.failUnless('portal_article' in self.portal.objectIds(), "plone_article tool was not installed")
        self.portal_article = getToolByName(self.portal, "portal_article")


    def test_01_editContent(self,):
        """
        Editing article
        """
        
        title = "A dummy title"
        text = "My dummy text"
        description = "A dummy description"
        
        # Edit content
        self.article.edit(text = text, text_format = 'html')
        pt = getToolByName(self.portal, "plone_utils")
        pt.contentEdit(self.article, title = title, description = description, text = text)
        
        self.failUnless(self.article.text == text)
        self.failUnless(self.article.Title() == title, "title didn't change")
        self.failUnless(self.article.Description() == description, "description didn't change")
        self.failUnless(self.article.title == title)
        self.failUnless(self.article.description == description)
        

    def test_02_addPloneArticleTool(self,):
        """
        Test adding of plone_article_tool
        """
        self.failUnless('portal_article' in self.portal.objectIds(), "plone_article tool was not installed")

    def test_03_PloneArticleTool_maxattachmentsize(self, size=4242):
        """
        Test max attachment size setting in Plone Article Tool
        """
        # Default should be 0: Unlimited
        self.failUnless(self.portal_article.getMaxAttachmentSize()==0)
        
        # Change to size
        self.portal_article.setMaxAttachmentSize(size)
        self.failUnless(self.portal_article.getMaxAttachmentSize()==size)


    def test_04_PloneArticleTool_maximagesize(self, size=4242):
        """
        Test max attachment size setting in Plone Article Tool
        """
        # Default should be 0: Unlimited
        self.failUnless(self.portal_article.getMaxImageSize()==0)

        # Change to size
        self.portal_article.setMaxImageSize(size)
        self.failUnless(self.portal_article.getMaxImageSize()==size)

    def test_ArticleToolLockSupport(self,):
        hasLockSupport = self.portal_article.hasLockSupport()
        
        #default is 0
        self.assertEqual(hasLockSupport, 0)
        
        #set lock support to 1
        
        
        
        
        
    def test_05_PloneArticleTool_preview(self,):
        """
        Test preview setting in Plone Article Tool
        """

        # Default should be 1: Switched on
        self.failUnless(self.portal_article.isPreviewActivated()==1)

        self.portal_article.activatePreview()
        self.failUnless(self.portal_article.isPreviewActivated()==1)

        # Change to 0
        self.portal_article.desactivatePreview()
        self.failUnless(self.portal_article.isPreviewActivated()==0)

    def test_06_PloneArticleTool_text_format(self,):
        """
        Test text format setting in Plone Article Tool
        """
        # Default should be html
        self.assertEqual(self.portal_article.getSiteTextFormats(), ('html', ))
        
        # Should be html, plain and structured-text
        self.failUnless(
            self.portal_article.getAvailableTextFormats() == [
                'html', 'plain', 'structured-text',
                ],
            )
        
        # Structured Text
        self.portal_article.setSiteTextFormats(['structured-text',])
        self.assertEqual(self.portal_article.getSiteTextFormats(), ('structured-text', ))

        # HTML
        self.portal_article.setSiteTextFormats(['html',])
        self.assertEqual(self.portal_article.getSiteTextFormats(), ('html', ))
        
        #self.failUnless('html' in self.portal_article.getSiteTextFormats())
        #self.failIf('plain' in self.portal_article.getSiteTextFormats())
        #self.failIf('structured-text' in self.portal_article.getSiteTextFormats())

        # Plain text
        self.portal_article.setSiteTextFormats(['plain'])
        self.assertEqual(
            self.portal_article.getSiteTextFormats(), 
            ('plain', )
        )
        
        #self.failUnless('plain' in self.portal_article.getSiteTextFormats())
        #self.failIf('html' in self.portal_article.getSiteTextFormats())
        #self.failIf('structured-text' in self.portal_article.getSiteTextFormats())

        # Should be plain and structured-text
        self.portal_article.setSiteTextFormats(['plain','structured-text'])
        self.assertEqual(
            self.portal_article.getSiteTextFormats(), 
            ('plain','structured-text')
        )

        #self.failUnless('plain' in self.portal_article.getSiteTextFormats())
        #self.failUnless('structured-text' in self.portal_article.getSiteTextFormats())
        #self.failIf('html' in self.portal_article.getSiteTextFormats())

        # Should be html, plain and structured-text
        self.portal_article.setSiteTextFormats(['plain','html','structured-text'])
        self.assertEqual(
            self.portal_article.getSiteTextFormats(), 
            ('plain','html','structured-text', )
        )
        
        #self.failUnless('plain' in self.portal_article.getSiteTextFormats())
        #self.failUnless('structured-text' in self.portal_article.getSiteTextFormats())
        #self.failUnless('html' in self.portal_article.getSiteTextFormats())
        
        # Should be html and structured-text
        self.portal_article.setSiteTextFormats(['plain','structured-text'])
        self.assertEqual(
            self.portal_article.getSiteTextFormats(), 
            ('plain','structured-text', )
        )


    def test_07_getModel(self,):
        """
        Test if model is available
        """
        # Basic things
        
        model = self.article.getModel()

        # Check that model exists and is default
        Log(LOG_DEBUG, "Model", model)
        self.failUnless(model is not None)
        self.failUnless(model == "PloneArticleModel")
        
    def test_08_setModel(self,):
        """
        Test model changing
        """
        # Set a valid model
        Log(LOG_DEBUG, "Models available : ", self.portal_article.getAvailableModels())
        Log(LOG_DEBUG, "Site Models : ", self.portal_article.getSiteModels())
        
        #test the default situation : only model can be chosen
        self.assertEqual(len(self.portal_article.getSiteModels()), 1)
        
        # Set a valid model
        site_models = self.portal_article.getAvailableModels()
        self.portal_article.setSiteModels(site_models)
        self.article.setModel("PloneArticleModel2")
        model = self.article.getModel()
        self.failUnless(model == "PloneArticleModel2")

        # Set an invalid model => must raise ValueError
        self.assertRaises(ValueError, self.article.setModel("ZORGLUB"))
        """
        try:
            article.setModel("ZORGLUB")
        except ValueError:
            pass
        else:
            self.failUnless(0)
        """
        # Force an invalid model => must get back to the default one
        self.article.model = "ZORGLUB"
        model = self.article.getModel()
        self.failUnless(model == "PloneArticleModel")
        

if __name__ == '__main__':
    framework(descriptions=1, verbosity=1)
else:
    import unittest
    def test_suite():
        suite = unittest.TestSuite()
        suite.addTest(unittest.makeSuite(TestPloneArticle))
        return suite

