/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#include <gtk/gtk.h>
#include <sqlite.h>

#define VERSION "0.1.0"
#define PLUGIN_NAME "XMMS-Stats"

/* the configuration file (xmms handles it very comfortably for us) */
#define CONFIGFILE "/.xmms/xmms-stats"
#define DATABASE_PATH "/.xmms/xmms_stats.db"

/* length for a song name*/
#define BUFSIZE 256

/* the structure for a record */
struct RecordStat{
	char title[BUFSIZE];
	int timelength;
	int timelistening;
};

extern int fd;
extern int hits;
extern int listen_time;
extern int rc;
extern sqlite *db;
extern int delete_timer;

/* the functions */
void *xmmsstats_thread(void *args);
void xmmsstats_init(void);
void xmmsstats_about(void);
void xmmsstats_config(void);
void xmmsstats_config_save(GtkWidget *wid, gpointer data);
void xmmsstats_cleanup(void);
void read_config (GtkWidget *wid, gpointer data);
void update_struct(struct RecordStat* rs, int pos);
void insert_data(struct RecordStat record);

/* sqlite_functions*/
void update_db();


