/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.LastPositionFinder;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.DocumentOrderComparer;
import com.icl.saxon.sort.QuickSort;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NodeSetExtent
extends NodeSetValue
implements NodeList {
    private NodeInfo[] value;
    private int length;
    private boolean sorted;
    private boolean reverseSorted;

    public NodeSetExtent() {
        this.value = new NodeInfo[0];
        this.length = 0;
        this.sorted = true;
        this.reverseSorted = true;
    }

    public NodeSetExtent(NodeInfo[] nodeInfoArray) {
        this.value = nodeInfoArray;
        this.length = nodeInfoArray.length;
        this.sorted = this.length < 2;
        this.reverseSorted = this.length < 2;
    }

    public NodeSetExtent(Vector vector) {
        this.value = new NodeInfo[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            this.value[n] = (NodeInfo)vector.elementAt(n);
            ++n;
        }
        this.length = vector.size();
        this.sorted = this.length < 2;
        this.reverseSorted = this.length < 2;
    }

    public NodeSetExtent(NodeEnumeration nodeEnumeration) throws SAXException {
        int n = nodeEnumeration instanceof LastPositionFinder ? ((LastPositionFinder)((Object)nodeEnumeration)).getLastPosition() : 20;
        this.value = new NodeInfo[n];
        int n2 = 0;
        while (nodeEnumeration.hasMoreElements()) {
            if (n2 >= n) {
                NodeInfo[] nodeInfoArray = new NodeInfo[n *= 2];
                System.arraycopy(this.value, 0, nodeInfoArray, 0, n2);
                this.value = nodeInfoArray;
            }
            this.value[n2++] = nodeEnumeration.nextElement();
        }
        this.sorted = nodeEnumeration.isSorted() || n2 < 2;
        this.reverseSorted = nodeEnumeration.isReverseSorted() || n2 < 2;
        this.length = n2;
    }

    public Expression simplify() throws SAXException {
        if (this.length == 0) {
            return new EmptyNodeSet();
        }
        if (this.length == 1) {
            return new SingletonNodeSet(this.value[0]);
        }
        return this;
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public String asString() throws SAXException {
        return this.length > 0 ? this.getFirst().getValue() : "";
    }

    public int getCount() throws SAXException {
        this.sort();
        return this.length;
    }

    public boolean isEmpty() throws SAXException {
        return this.length == 0;
    }

    public boolean isSingular() {
        return this.length == 1;
    }

    public boolean contains(NodeInfo nodeInfo) {
        int n = 0;
        while (n < this.length) {
            if (this.value[n] == nodeInfo) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Vector getVector() {
        Vector<NodeInfo> vector = new Vector<NodeInfo>(this.length);
        int n = 0;
        while (n < this.length) {
            vector.addElement(this.value[n]);
            ++n;
        }
        return vector;
    }

    public NodeInfo[] getNodes() {
        if (this.value.length == this.length) {
            return this.value;
        }
        NodeInfo[] nodeInfoArray = new NodeInfo[this.length];
        System.arraycopy(this.value, 0, nodeInfoArray, 0, this.length);
        this.value = nodeInfoArray;
        return this.value;
    }

    public NodeSetValue sort() throws SAXException {
        if (this.length < 2) {
            this.sorted = true;
        }
        if (this.sorted) {
            return this;
        }
        if (this.reverseSorted) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            NodeInfo[] nodeInfoArray = new NodeInfo[this.length];
            int n = 0;
            while (n < this.length) {
                nodeInfoArray[n] = this.value[this.length - n - 1];
                ++n;
            }
            this.value = nodeInfoArray;
            this.sorted = true;
            this.reverseSorted = false;
        } else {
            DocumentOrderComparer documentOrderComparer = new DocumentOrderComparer();
            QuickSort quickSort = new QuickSort(documentOrderComparer);
            quickSort.sort(this.value, this.length);
            int n = 1;
            int n2 = 1;
            while (n2 < this.length) {
                if (!this.value[n2].isSameNode(this.value[n2 - 1])) {
                    this.value[n++] = this.value[n2];
                }
                ++n2;
            }
            this.length = n;
            this.sorted = true;
            this.reverseSorted = false;
        }
        return this;
    }

    public NodeInfo getFirst() throws SAXException {
        if (this.length == 0) {
            return null;
        }
        NodeInfo nodeInfo = null;
        long l = Long.MAX_VALUE;
        int n = 0;
        while (n < this.length) {
            long l2 = this.value[n].getSequenceNumber();
            if (l2 < l) {
                nodeInfo = this.value[n];
                l = l2;
            }
            ++n;
        }
        return nodeInfo;
    }

    public NodeInfo selectFirst(Context context) throws SAXException {
        return this.getFirst();
    }

    public NodeEnumeration enumerate() throws SAXException {
        return new NodeSetValueEnumeration();
    }

    public String toString() {
        return "NODESET " + this.value.toString();
    }

    public int getLength() {
        try {
            return this.getCount();
        }
        catch (SAXException sAXException) {
            return 0;
        }
    }

    public Node item(int n) {
        try {
            this.sort();
            if (this.length > n) {
                return this.value[n];
            }
            return null;
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    private class NodeSetValueEnumeration
    implements NodeEnumeration,
    LastPositionFinder {
        int index = 0;

        public boolean hasMoreElements() {
            return this.index < NodeSetExtent.this.length;
        }

        public NodeInfo nextElement() {
            return NodeSetExtent.this.value[this.index++];
        }

        public boolean isSorted() {
            return NodeSetExtent.this.sorted;
        }

        public boolean isReverseSorted() {
            return NodeSetExtent.this.reverseSorted;
        }

        public boolean isPeer() {
            return false;
        }

        public int getLastPosition() {
            return NodeSetExtent.this.length;
        }
    }
}

