#include <stdio.h>

#ifdef linux
#   include <fcntl.h>
#else

#   include <sys/param.h>

#   if !defined(__FreeBSD__) && !defined(__NetBSD__) && !defined(__OpenBSD__)
#      include <rpcsvc/rstat.h>
#   endif 

#   if defined(SVR4) || defined (SYSV)
#      include <netdb.h>

#      ifndef hpux
#         include <sys/systeminfo.h>
#      endif

#      ifndef FSCALE
#      define FSCALE	(1 << 8)
#      endif

      char hostname[MAXHOSTNAMELEN];
      struct statstime res;

#   endif

#endif

#ifdef OSF1
 
#   define TBL_LOADAVG             3
#   define TBL_SYSINFO             12 

/*
 *  TBL_LOADAVG data layout
 */
struct tbl_loadavg {
   union {
      long   l[3];
      double d[3];
   } tl_avenrun;
   int    tl_lscale;           /* 0 scale when floating point */
   long   tl_mach_factor[3];
};
 
/*
 *      TBL_SYSINFO data layout
 */
struct tbl_sysinfo {
   long    si_user;                /* User time */
   long    si_nice;                /* Nice time */
   long    si_sys;                 /* System time */
   long    si_idle;                /* Idle time */
   long    si_hz;
   long    si_phz;
   long    si_boottime;            /* Boot time in seconds */
   long wait; /* Wait time */
#define usr si_user
#define sys si_sys
#define idle si_idle
};
  
#endif


void GetLoad(float *,float *,float *);

#ifdef linux
/* linux version */
void GetLoad(float *small,float *medium,float *large)
{ 
  char buffer[100];
  int fd, len;

  fd = open("/proc/loadavg", O_RDONLY);
  len = read(fd, buffer, sizeof(buffer)-1);
  close(fd);
  buffer[len] = '\0';
  
  sscanf(buffer,"%f%f%f",small,medium,large);
  /* pas de verif ... */
}
#endif

#if defined(SVR4) || defined (SYSV)
void GetLoad(float *small,float *medium,float *large)
{
   /*
    * originally written by Matthieu Herrb - Mon Oct  5 1992
    * modified for optimization
    */

    if (rstat(hostname, &res) != 0) {
	perror("rstat");
	*small = *medium = *large = 0.0;
	return;
    }

    *small  = (float)res.avenrun[0]/FSCALE;
    *medium = (float)res.avenrun[1]/FSCALE;
    *large  = (float)res.avenrun[2]/FSCALE;
}
#endif

#if defined(__FreeBSD) || defined(__NetBSD__) || defined(__OpenBSD__)
void GetLoad(float *small, float *medium, float *large)
{
   static double loadavg[3];
   /* 
    * Written by Geir Inge Jensen, Tue Dec 22 1997
    */
 
   if (getloadavg(&loadavg, 3) < 0) {
      perror("getloadavg");
      *small = *medium = *large = 0.0;
      return;
   }
 
   *small = (float)loadavg[0];
   *medium = (float)loadavg[1];
   *large = (float)loadavg[2];
}

#endif

#ifdef OSF1
void GetLoad(float *small,float *medium,float *large)
{
   int		i;
   double	avenrun[3] ;
   struct	tbl_loadavg labuf;
   struct	tbl_sysinfo sibuf;
   
   /* get load averages */
   if (table(TBL_LOADAVG,0,&labuf,1,sizeof(struct tbl_loadavg))<0) {
      perror("TBL_LOADAVG");
      *small = *medium = *large = 0.0;
      return;
   }
   if (labuf.tl_lscale != 0)   /* scaled */
      for(i=0;i<3;i++) 
	 avenrun[i] = (labuf.tl_avenrun.l[i]/(double)labuf.tl_lscale) ;
   else                   /* not scaled */
      for(i=0;i<3;i++) 
	 avenrun[i] = labuf.tl_avenrun.d[i] ;

   *small  = (float)avenrun[0];
   *medium = (float)avenrun[1];
   *large  = (float)avenrun[2];
}
#endif
